/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.base.Initializers;
import apex.jorje.lsp.impl.index.ApexIndex;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.index.symbol.Modifiers;
import apex.jorje.lsp.impl.index.symbol.VirtualCodeUnitDetails;
import apex.jorje.lsp.impl.index.symbol.VirtualFieldTableInitializer;
import apex.jorje.lsp.impl.index.symbol.VirtualMethodTableInitializer;
import apex.jorje.lsp.impl.utils.TypeInfoCache;
import apex.jorje.semantic.ast.compilation.VirtualMethodsCreator;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.member.variable.StandardFieldTable;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.StandardTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.parent.ParentTable;
import apex.jorje.semantic.symbol.type.parent.StandardParentTable;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.exception.CompilationException;
import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.IReader;

public class VirtualStandardTypeInfo
extends AbstractTypeInfo
implements StandardTypeInfo {
    private final VirtualCodeUnitDetails codeUnit;
    private final ApexTypeId typeId;
    private final Builder builder;
    private TypeInfo enclosingType;

    private VirtualStandardTypeInfo(Builder builder) {
        super(builder);
        this.builder = builder;
        this.typeId = builder.typeId;
        SourceFile sourceFile = builder.uri != null ? new SourceFile.Builder().setKnownName(builder.uri).setNamespace(builder.namespace).build() : null;
        this.codeUnit = new VirtualCodeUnitDetails(this, sourceFile, true);
    }

    @Override
    public <T> T accept(TypeInfoVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CodeUnitDetails getCodeUnitDetails() {
        return this.codeUnit;
    }

    public ApexTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public TypeInfo getEnclosingType() {
        if (this.enclosingType != null) {
            return this.enclosingType;
        }
        try (IReader ignored = ((ApexIndex)this.builder.getApexIndexProvider().get()).getNd().acquireReadLock();){
            String apexName;
            TypeInfo info;
            ApexTypeId enclosingTypeId = this.typeId.getEnclosingType();
            this.enclosingType = enclosingTypeId != null ? ((info = TypeInfoCache.getTypeInfo(apexName = enclosingTypeId.getApexName().toString().toLowerCase())) != null ? info : this.builder.createEnclosingType(enclosingTypeId)) : null;
            TypeInfo typeInfo = this.enclosingType;
            return typeInfo;
        }
    }

    public static class Builder
    extends AbstractTypeInfo.Builder<Builder, VirtualStandardTypeInfo> {
        private final Provider<ApexIndex> apexIndexProvider;
        private final SymbolResolver symbolResolver;
        private ApexTypeId typeId;
        private String uri;
        private Namespace namespace;

        public Builder(SymbolResolver symbolResolver, Provider<ApexIndex> apexIndexProvider) {
            this.symbolResolver = symbolResolver;
            this.apexIndexProvider = apexIndexProvider;
        }

        public Builder setApexTypeId(ApexTypeId typeId) {
            this.typeId = typeId;
            return this;
        }

        @Override
        public VirtualStandardTypeInfo build() {
            try (IReader ignored = ((ApexIndex)this.apexIndexProvider.get()).getNd().acquireReadLock();){
                ApexType apexType = this.typeId.getType();
                String lowercaseApexName = this.typeId.getApexName().toString().toLowerCase();
                if (apexType != null) {
                    this.uri = this.typeId.getType().getFile().getFilename().getString();
                    this.namespace = Namespaces.create(this.typeId.getApexNamespace().getString());
                    this.setApexName(this.typeId.getApexName().getString());
                    this.setBytecodeName(this.typeId.getBytecodeName().getString());
                    this.setUnitType(this.unitTypeFrom(this.typeId.getType().getUnitType().getString()));
                    this.setNamespace(this.namespace);
                    this.setModifiers(Modifiers.toModifierGroup(this.typeId.getType().getModifiers().getString()));
                    this.setParents(this.createParentTable());
                    this.setFields(Initializers.memoize(new VirtualFieldTableInitializer(this.symbolResolver, this.apexIndexProvider, this.typeId.getType())));
                    this.setMethods(Initializers.memoize(new VirtualMethodTableInitializer(this.symbolResolver, this.apexIndexProvider, this.typeId.getType())));
                    this.setVirtualMethods(new StandardMethodTable());
                } else {
                    this.uri = null;
                    this.setApexName(this.typeId.getApexName().getString());
                    this.setBytecodeName(this.typeId.getBytecodeName().getString());
                    this.setUnitType(UnitType.CLASS);
                    this.setModifiers(Modifiers.toModifierGroup("virtual global"));
                    StandardParentTable emptyTable = new StandardParentTable();
                    emptyTable.resolveSuperTypes(null);
                    emptyTable.resolveInterfaces(Collections.emptyList());
                    this.setParents(emptyTable);
                    this.setBasicType(BasicType.APEX_OBJECT);
                    this.setFields(new StandardFieldTable());
                    this.setMethods(new StandardMethodTable());
                }
                VirtualStandardTypeInfo info = new VirtualStandardTypeInfo(this);
                TypeInfoCache.addTypeInfo(info);
                ArrayListMultimap<TypeInfo, CompilationException> errorsMap = ArrayListMultimap.create();
                VirtualMethodsCreator.create(errorsMap, this.symbolResolver, info);
                VirtualStandardTypeInfo virtualStandardTypeInfo = info;
                return virtualStandardTypeInfo;
            }
        }

        private TypeInfo createEnclosingType(ApexTypeId enclosingTypeId) {
            return enclosingTypeId != null ? (TypeInfo)new Builder(this.symbolResolver, this.apexIndexProvider).setApexTypeId(enclosingTypeId).buildResolved() : null;
        }

        Provider<ApexIndex> getApexIndexProvider() {
            return this.apexIndexProvider;
        }

        private ParentTable createParentTable() {
            StandardParentTable parentTable = new StandardParentTable();
            ApexTypeId parentId = this.typeId.getParent();
            TypeInfo parentInfo = null;
            if (parentId != null) {
                parentInfo = this.getOrCreateTypeInfo(parentId);
            }
            parentTable.resolveSuperTypes(parentInfo);
            List<ApexTypeId> interfaces = this.typeId.getInterfaces();
            ArrayList<TypeInfo> interfaceInfos = new ArrayList<TypeInfo>();
            for (ApexTypeId interfaceId : interfaces) {
                interfaceInfos.add(this.getOrCreateTypeInfo(interfaceId));
            }
            parentTable.resolveInterfaces(interfaceInfos);
            return parentTable;
        }

        private TypeInfo getOrCreateTypeInfo(ApexTypeId typeId) {
            String apexName = typeId.getApexName().toString().toLowerCase();
            TypeInfo existingTypeInfo = TypeInfoCache.getTypeInfo(apexName);
            return existingTypeInfo != null ? existingTypeInfo : new Builder(this.symbolResolver, this.apexIndexProvider).setApexTypeId(typeId).buildResolved();
        }

        private UnitType unitTypeFrom(String unitType) {
            return UnitType.valueOf(unitType);
        }
    }
}

