/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.symbol;

import apex.common.tuple.IntPair;
import apex.jorje.data.TypeRefBuilder;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.OldVersionProvider;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.compiler.StructuredVersion;
import apex.jorje.semantic.compiler.StructuredVersionRange;
import apex.jorje.semantic.symbol.type.CodeUnitDetails;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.reference.TypeReference;
import apex.jorje.services.Version;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class VirtualCodeUnitDetails
implements CodeUnitDetails {
    private final TypeInfo typeInfo;
    private final SourceFile sourceFile;
    private final boolean isSourceBased;

    VirtualCodeUnitDetails(TypeInfo typeInfo, SourceFile sourceFile, boolean isSourceBased) {
        this.typeInfo = typeInfo;
        this.sourceFile = sourceFile;
        this.isSourceBased = isSourceBased;
    }

    @Override
    public boolean isTrusted() {
        return false;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public boolean isMocked() {
        return false;
    }

    @Override
    @Nullable
    public OldVersionProvider getVersionProvider() {
        return null;
    }

    @Override
    public Map<Namespace, StructuredVersion> getReferencedPackageVersions() {
        return Collections.emptyMap();
    }

    @Override
    public Map<IntPair, StructuredVersionRange> getExportedPackageVersions() {
        return Collections.emptyMap();
    }

    @Override
    public Map<IntPair, Map<String, StructuredVersion>> getInterfacePackageVersions() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isApexSourceBased() {
        return this.isSourceBased;
    }

    @Override
    public SourceFile getSource() {
        if (this.sourceFile != null) {
            return this.sourceFile;
        }
        throw new UnsupportedOperationException("Can't get source for non source code unit");
    }

    @Override
    public String getName() {
        return this.typeInfo.getApexName();
    }

    @Override
    public Version getVersion() {
        return Version.CURRENT;
    }

    @Override
    public TypeReference getTriggerType() {
        throw new UnsupportedOperationException("Can't get source from  a virtual code unit");
    }

    @Override
    public Optional<TypeRef> getSuperTypeRef() {
        TypeInfo typeInfo = this.typeInfo.parents().superType();
        return Optional.ofNullable(typeInfo != null ? TypeRefBuilder.withNames(typeInfo.getApexName()).build() : null);
    }

    @Override
    public List<TypeRef> getInterfaceTypeRefs() {
        List<TypeInfo> typeInfos = this.typeInfo.parents().immediateInterfaces();
        return typeInfos.stream().map(t -> TypeRefBuilder.withNames(t.getApexName()).build()).collect(Collectors.toList());
    }
}

