/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.index.node;

import apex.jorje.lsp.impl.index.node.ApexMethodParameter;
import apex.jorje.lsp.impl.index.node.ApexType;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.db.IString;
import org.eclipse.jdt.internal.core.nd.field.FieldByte;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.eclipse.jdt.internal.core.nd.field.FieldString;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class ApexMethod
extends NdNode {
    public static final StructDef<ApexMethod> type = StructDef.create(ApexMethod.class, (StructDef)NdNode.type);
    static final FieldManyToOne<ApexType> OWNER = FieldManyToOne.createOwner(type, ApexType.METHODS);
    static final FieldOneToMany<ApexMethodParameter> PARAMETERS = FieldOneToMany.create(type, ApexMethodParameter.OWNER);
    static final FieldManyToOne<ApexTypeId> RETURN_TYPE = FieldManyToOne.create(type, ApexTypeId.USED_AS_RETURN_TYPE);
    private static final FieldString METHOD_NAME = type.addString();
    private static final FieldByte IS_CONSTRUCTOR = type.addByte();
    private static final FieldString MODIFIERS = type.addString();
    private ApexTypeId returnType;

    public ApexMethod(Nd nd, long address) {
        super(nd, address);
    }

    public ApexMethod(ApexType owner) {
        super(owner.getNd());
        OWNER.put(this.getNd(), this.address, (NdNode)owner);
    }

    public IString getMethodName() {
        return METHOD_NAME.get(this.getNd(), this.address);
    }

    public void setMethodName(String methodName) {
        METHOD_NAME.put(this.getNd(), this.address, methodName);
    }

    public void setIsConstructor() {
        IS_CONSTRUCTOR.put(this.getNd(), this.address, (byte)1);
    }

    public boolean isConstructor() {
        return IS_CONSTRUCTOR.get(this.getNd(), this.address) > 0;
    }

    public IString getModifiers() {
        return MODIFIERS.get(this.getNd(), this.address);
    }

    public void setModifiers(String modifiers) {
        MODIFIERS.put(this.getNd(), this.address, modifiers);
    }

    public ApexTypeId getReturnType() {
        return (ApexTypeId)RETURN_TYPE.get(this.getNd(), this.address);
    }

    public void setReturnType(ApexTypeId returnType) {
        RETURN_TYPE.put(this.getNd(), this.address, (NdNode)returnType);
    }

    public List<ApexMethodParameter> getParameters() {
        return PARAMETERS.asList(this.getNd(), this.address);
    }

    static {
        type.done();
    }
}

