/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.document;

import apex.jorje.lsp.api.document.PositionTracker;
import apex.jorje.lsp.impl.document.BadLocationException;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

public class StandardPositionTracker
implements PositionTracker {
    private static final String[] DELIMITERS = new String[]{"\r", "\n", "\r\n"};
    private final List<Line> lines;
    private final DelimiterInfo fDelimiterInfo = new DelimiterInfo();
    private int sourceLength;

    public StandardPositionTracker(@Nonnull String source) {
        this.lines = Lists.newArrayList();
        this.set(source);
    }

    @Override
    public int getNumberOfLines() {
        int numLines = this.lines.size();
        if (numLines == 0) {
            return 1;
        }
        Line lastLine = this.lines.get(numLines - 1);
        return lastLine.delimiter != null ? numLines + 1 : numLines;
    }

    @Override
    public int getLineOffset(int line) throws BadLocationException {
        int numLines = this.lines.size();
        if (line < 0 || line > numLines) {
            throw new BadLocationException();
        }
        if (numLines == 0) {
            return 0;
        }
        if (line == numLines) {
            Line lastLine = this.lines.get(line - 1);
            if (lastLine.delimiter != null) {
                return lastLine.offset + lastLine.length;
            }
            throw new BadLocationException();
        }
        return this.lines.get((int)line).offset;
    }

    @Override
    public int getLineLength(int line) throws BadLocationException {
        int numLines = this.lines.size();
        if (line < 0 || line > numLines) {
            throw new BadLocationException();
        }
        if (numLines == 0 || numLines == line) {
            return 0;
        }
        return this.lines.get((int)line).length;
    }

    @Override
    public int getLineNumberOfOffset(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.sourceLength) {
            throw new BadLocationException();
        }
        if (offset == this.sourceLength) {
            int lastLine = this.lines.size() - 1;
            if (lastLine < 0) {
                return 0;
            }
            Line line = this.lines.get(lastLine);
            return line.delimiter != null ? lastLine + 1 : lastLine;
        }
        return this.findLine(offset);
    }

    private void set(String text) {
        this.lines.clear();
        if (text != null) {
            this.sourceLength = text.length();
            this.createLines(text, 0, 0);
        }
    }

    private int findLine(int offset) {
        if (this.lines.isEmpty()) {
            return -1;
        }
        int left = 0;
        int right = this.lines.size() - 1;
        int mid = 0;
        Line line = null;
        while (left < right) {
            mid = (left + right) / 2;
            line = this.lines.get(mid);
            if (offset < line.offset) {
                right = left == mid ? left : mid - 1;
                continue;
            }
            if (offset > line.offset) {
                left = right == mid ? right : mid + 1;
                continue;
            }
            if (offset != line.offset) continue;
            left = right = mid;
        }
        line = this.lines.get(left);
        if (line.offset > offset) {
            --left;
        }
        return left;
    }

    private int createLines(String text, int insertPosition, int offset) {
        int count = 0;
        int start = 0;
        DelimiterInfo delimiterInfo = this.nextDelimiterInfo(text, 0);
        while (delimiterInfo != null && delimiterInfo.delimiterIndex > -1) {
            int index = delimiterInfo.delimiterIndex + (delimiterInfo.delimiterLength - 1);
            if (insertPosition + count >= this.lines.size()) {
                this.lines.add(new Line(offset + start, offset + index, delimiterInfo.delimiter));
            } else {
                this.lines.add(insertPosition + count, new Line(offset + start, offset + index, delimiterInfo.delimiter));
            }
            ++count;
            start = index + 1;
            delimiterInfo = this.nextDelimiterInfo(text, start);
        }
        if (start < text.length()) {
            if (insertPosition + count < this.lines.size()) {
                Line l = this.lines.get(insertPosition + count);
                int delta = text.length() - start;
                l.offset -= delta;
                l.length += delta;
            } else {
                this.lines.add(new Line(offset + start, offset + text.length() - 1, null));
                ++count;
            }
        }
        return count;
    }

    private DelimiterInfo nextDelimiterInfo(String text, int offset) {
        int length = text.length();
        for (int i = offset; i < length; ++i) {
            char ch = text.charAt(i);
            if (ch == '\r') {
                if (i + 1 < length && text.charAt(i + 1) == '\n') {
                    this.fDelimiterInfo.delimiter = DELIMITERS[2];
                    this.fDelimiterInfo.delimiterIndex = i;
                    this.fDelimiterInfo.delimiterLength = 2;
                    return this.fDelimiterInfo;
                }
                this.fDelimiterInfo.delimiter = DELIMITERS[0];
                this.fDelimiterInfo.delimiterIndex = i;
                this.fDelimiterInfo.delimiterLength = 1;
                return this.fDelimiterInfo;
            }
            if (ch != '\n') continue;
            this.fDelimiterInfo.delimiter = DELIMITERS[1];
            this.fDelimiterInfo.delimiterIndex = i;
            this.fDelimiterInfo.delimiterLength = 1;
            return this.fDelimiterInfo;
        }
        return null;
    }

    static class DelimiterInfo {
        public int delimiterIndex;
        public int delimiterLength;
        public String delimiter;

        DelimiterInfo() {
        }
    }

    static class Line {
        final String delimiter;
        int offset;
        int length;

        Line(int offset, int end, String delimiter) {
            this.offset = offset;
            this.delimiter = delimiter;
            this.length = end - offset + 1;
        }
    }
}

