/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.diagnostics;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.document.DocumentLifecycleHandler;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.diagnostics.CompilationExceptionDispatcher;
import apex.jorje.lsp.impl.diagnostics.DiagnosticCompilationExceptionVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.services.exception.CompilationException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DiagnosticsReporter
implements DocumentLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosticsReporter.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final Provider<LanguageClient> languageClientProvider;
    private final DiagnosticCompilationExceptionVisitor diagnosticVisitor = new DiagnosticCompilationExceptionVisitor();

    @Inject
    public DiagnosticsReporter(Provider<LanguageClient> languageClientProvider, ApexCompilerService compilerService, ApexDocumentService documentService) {
        this.languageClientProvider = languageClientProvider;
        this.compilerService = compilerService;
        this.documentService = documentService;
    }

    @Override
    public void handleDidOpen(DidOpenTextDocumentParams params) {
        Optional<Document> document = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        document.map(this::publishDiagnostics);
    }

    @Override
    public void handleDidChange(DidChangeTextDocumentParams params) {
        Optional<Document> document = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        document.map(this::publishDiagnostics);
    }

    @Override
    public void handleDidClose(DidCloseTextDocumentParams params) {
        this.clearDiagnostics(params);
    }

    @Override
    public void handleDidSave(DidSaveTextDocumentParams params) {
        Optional<Document> document = this.documentService.retrieve(URI.create(params.getTextDocument().getUri()));
        document.map(this::publishDiagnostics);
    }

    private void clearDiagnostics(DidCloseTextDocumentParams params) {
        PublishDiagnosticsParams diagnostics = new PublishDiagnosticsParams();
        diagnostics.setUri(params.getTextDocument().getUri());
        diagnostics.setDiagnostics(Collections.emptyList());
        LanguageClient languageClient = (LanguageClient)this.languageClientProvider.get();
        languageClient.publishDiagnostics(diagnostics);
    }

    private Optional<PublishDiagnosticsParams> publishDiagnostics(Document document) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        PublishDiagnosticsParams diagnosticsParams = this.generateDiagnostics(document);
        LanguageClient languageClient = (LanguageClient)this.languageClientProvider.get();
        languageClient.publishDiagnostics(diagnosticsParams);
        stopwatch.stop();
        logger.info("Error analysis took: {}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return Optional.of(diagnosticsParams);
    }

    @VisibleForTesting
    PublishDiagnosticsParams generateDiagnostics(Document document) {
        CodeUnit codeUnit = this.analyzeErrors(document);
        return this.transformErrors(document, codeUnit);
    }

    private PublishDiagnosticsParams transformErrors(Document document, CodeUnit codeUnit) {
        ArrayList diagnostics = Lists.newArrayList();
        PublishDiagnosticsParams diagnosticsParams = new PublishDiagnosticsParams();
        diagnosticsParams.setUri(String.valueOf(document.getUri()));
        List<CompilationException> compilationExceptions = codeUnit.getErrors().get();
        diagnostics.addAll(compilationExceptions.stream().map(e -> CompilationExceptionDispatcher.dispatch(e, this.diagnosticVisitor)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        diagnosticsParams.setDiagnostics(diagnostics);
        diagnosticsParams.setUri(String.valueOf(document.getUri()));
        return diagnosticsParams;
    }

    private CodeUnit analyzeErrors(Document document) {
        List<CodeUnit> codeUnits = this.compilerService.addSources(document).compile();
        return CodeUnits.getMatchingElement(codeUnits, document.getUri().toString());
    }
}

