/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions.triggers;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Optional;
import org.eclipse.lsp4j.Position;

public class TriggerValidationBasedCompletionActivationStrategy {
    private final ApexCompilerService compilerService;
    private final Document document;
    private final Position position;
    private ContextDeterminer contextDeterminer;

    @AssistedInject
    public TriggerValidationBasedCompletionActivationStrategy(ApexCompilerService compilerService, @Assisted Document document, @Assisted Position position) {
        this.compilerService = compilerService;
        this.document = document;
        this.position = position;
    }

    void analyze() throws BadLocationException {
        int lineOffset = this.document.getLineOffset(this.position.getLine());
        int offset = lineOffset + this.position.getCharacter();
        this.contextDeterminer = new ContextDeterminer(offset);
        this.compilerService.setVisitor(this.contextDeterminer).addSources(this.document).compile();
    }

    Optional<TriggerVariableExpression> getExpression() {
        assert (this.contextDeterminer != null) : "Call analyze() to begin analysis first";
        return this.contextDeterminer != null ? this.contextDeterminer.getExpression() : Optional.empty();
    }

    static final class ContextDeterminer
    extends AstVisitor<AdditionalPassScope> {
        private final int activationOffset;
        private TriggerVariableExpression varExpression;

        ContextDeterminer(int activationOffset) {
            this.activationOffset = activationOffset;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(TriggerVariableExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            int startIndex = node.getLoc().getStartIndex();
            int endIndex = node.getLoc().getEndIndex();
            if (this.activationOffset >= startIndex && endIndex >= this.activationOffset) {
                this.varExpression = node;
            }
        }

        Optional<TriggerVariableExpression> getExpression() {
            return Optional.ofNullable(this.varExpression);
        }
    }
}

