/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.utils.NamesCompletionStrategies;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;

@Singleton
public class MethodNamesCompletionStrategy
implements CompletionStrategy {
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public MethodNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        return NamesCompletionStrategies.provideCompletions(params, this.documentService, this.compilerService, this.factory, new MethodProcessor());
    }

    private class MethodProcessor
    implements NamesCompletionStrategies.NameProcessor {
        private MethodProcessor() {
        }

        @Override
        public void processClass(TypeInfo compiledType, List<CompletionItem> items) {
            items.addAll(compiledType.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, compiledType)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
            items.addAll(compiledType.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, compiledType)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), compiledType, m.getDefiningType(), m.getModifiers(), false)).map(method -> CompletionItemTransformer.transform(method, "5/")).collect(Collectors.toList()));
        }
    }
}

