/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.utils.NamesCompletionStrategies;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.TextDocumentPositionParams;

@Singleton
public class FieldNamesCompletionStrategy
implements CompletionStrategy {
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;

    @Inject
    public FieldNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        return NamesCompletionStrategies.provideCompletions(params, this.documentService, this.compilerService, this.factory, new FieldProcessor());
    }

    private class FieldProcessor
    implements NamesCompletionStrategies.NameProcessor {
        private FieldProcessor() {
        }

        @Override
        public void processClass(TypeInfo typeInfo, List<CompletionItem> items) {
            TypeInfo typeToProcess = typeInfo;
            while (typeToProcess != null) {
                TypeInfo definingType = typeToProcess;
                items.addAll(typeToProcess.fields().all().stream().filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), typeInfo, definingType, f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(field -> CompletionItemTransformer.transform(field, "4/", field.getMemberType() == Member.Type.PROPERTY ? CompletionItemKind.Property : CompletionItemKind.Field)).collect(Collectors.toList()));
                typeToProcess = typeToProcess.parents().superType();
            }
        }
    }
}

