/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.impl.completions.CompletionItemBuilder;
import apex.jorje.lsp.impl.index.node.ApexTypeId;
import apex.jorje.lsp.impl.utils.NamesCompletionStrategies;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.naming.TypeNameProvider;
import apex.jorje.semantic.symbol.visibility.Visibility;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;

public class CompletionItemTransformer {
    public static final String LOCALS_SORT_PREFIX = "3/";
    static final String FIELDS_SORT_PREFIX = "4/";
    static final String METHODS_SORT_PREFIX = "5/";
    static final String SYSTEM_FIELDS_SORT_PREFIX = "6/";
    static final String SYSTEM_METHODS_SORT_PREFIX = "7/";
    static final String SYSTEM_TYPE_SORT_PREFIX = "8/";
    static final String NAMESPACE_SORT_PREFIX = "9/";

    static List<CompletionItem> transformNamespaces(List<String> namespaces) {
        return namespaces.stream().map(namespace -> new CompletionItemBuilder((String)namespace).kind(CompletionItemKind.Module).insertText((String)namespace).sortText(NAMESPACE_SORT_PREFIX + namespace).documentation("").build()).collect(Collectors.toList());
    }

    public static List<CompletionItem> transformTriggerVariables(List<String> fields) {
        return fields.stream().map(field -> new CompletionItemBuilder((String)field).kind(CompletionItemKind.Field).insertText((String)field).sortText(FIELDS_SORT_PREFIX + field).build()).collect(Collectors.toList());
    }

    public static List<CompletionItem> transform(String prefix, List<ApexTypeId> typeIds) {
        return typeIds.stream().map(t -> CompletionItemTransformer.transform(prefix, t)).collect(Collectors.toList());
    }

    private static CompletionItem transform(String prefix, ApexTypeId typeId) {
        String label = typeId.getApexName().getString();
        label = label.replaceFirst("^System\\.", "");
        String text = prefix.endsWith(".") ? label.replaceFirst("(?i)" + prefix, "") : label;
        text = text.replaceFirst("^System\\.", "");
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Class).insertText(text).sortText(SYSTEM_TYPE_SORT_PREFIX + label).documentation("").build();
    }

    public static List<CompletionItem> transform(TypeInfo typeInfo, TypeInfo referencingType, @Nullable IdentifierContext identifierContext) {
        ArrayList<CompletionItem> items = Lists.newArrayList();
        if (identifierContext != null) {
            switch (identifierContext) {
                case OBJECT: {
                    items.addAll(typeInfo.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                    break;
                }
                case STATIC: {
                    items.addAll(typeInfo.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                    break;
                }
                case NONE: {
                    items.addAll(typeInfo.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                    items.addAll(typeInfo.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, typeInfo)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, m.getDefiningType(), m.getModifiers(), false)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                }
            }
            switch (identifierContext) {
                case OBJECT: {
                    CompletionItemTransformer.addNonStaticFields(items, typeInfo, referencingType);
                    break;
                }
                case STATIC: {
                    items.addAll(typeInfo.fields().all().stream().filter(f -> CompletionItemTransformer.isStatic(f)).filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, f.getDefiningType(), f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                    break;
                }
                case NONE: {
                    items.addAll(typeInfo.fields().all().stream().map(CompletionItemTransformer::transform).collect(Collectors.toList()));
                }
            }
        }
        return items;
    }

    static CompletionItem transform(FieldInfo f) {
        CompletionItemKind kind = f.getMemberType() == Member.Type.PROPERTY ? CompletionItemKind.Property : CompletionItemKind.Field;
        return CompletionItemTransformer.transform(f, SYSTEM_FIELDS_SORT_PREFIX, kind);
    }

    static CompletionItem transform(FieldInfo f, String systemFieldsSortPrefix, CompletionItemKind kind) {
        String label = f.getName();
        String doc = f.getType().getApexName() + " " + label;
        return new CompletionItemBuilder(label).kind(kind).sortText(systemFieldsSortPrefix + label).documentation(doc).build();
    }

    static CompletionItem transform(MethodInfo m) {
        return CompletionItemTransformer.transform(m, SYSTEM_METHODS_SORT_PREFIX);
    }

    static CompletionItem transform(MethodInfo m, String systemMethodsSortPrefix) {
        String parameterNames = m.getParameters().stream().map(p -> p.getName().getValue()).collect(Collectors.joining(", "));
        String parameterTypes = m.getParameterTypes().stream().map(TypeNameProvider::getApexName).collect(Collectors.joining(", "));
        String label = m.getCanonicalName() + "(" + parameterNames + ")";
        String doc = m.getReturnType().getApexName() + " " + m.getCanonicalName() + "(" + parameterTypes + ")";
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Method).sortText(systemMethodsSortPrefix + label).documentation(doc).build();
    }

    static CompletionItem transform(LocalInfo l) {
        String label = l.getName();
        String doc = l.getType().getApexName() + " " + label;
        return new CompletionItemBuilder(label).kind(CompletionItemKind.Variable).sortText(LOCALS_SORT_PREFIX + label).documentation(doc).build();
    }

    static List<CompletionItem> dedup(List<CompletionItem> items) {
        return items.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CompletionItem>(Comparator.comparing(CompletionItem::getLabel))), ArrayList::new));
    }

    private static boolean isStatic(FieldInfo fieldInfo) {
        return fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC);
    }

    private static boolean isStatic(MethodInfo methodInfo) {
        return methodInfo.getModifiers().has(ModifierTypeInfos.STATIC);
    }

    private static void addNonStaticFields(List<CompletionItem> items, TypeInfo typeInfo, TypeInfo referencingType) {
        TypeInfo typeToProcess = typeInfo;
        while (typeToProcess != null) {
            TypeInfo definingType = typeToProcess;
            items.addAll(typeToProcess.fields().all().stream().filter(f -> !CompletionItemTransformer.isStatic(f)).filter(f -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), referencingType, definingType, f.getModifiers(), f.getMemberType() == Member.Type.PROPERTY)).map(CompletionItemTransformer::transform).collect(Collectors.toList()));
            typeToProcess = typeToProcess.parents().superType();
        }
    }
}

