/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeLens;

import apex.jorje.lsp.api.codeLenses.CodeLensProvider;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.utils.CodeUnits;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.compiler.CodeUnit;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ApexTestRunCodeLensesProvider
implements CodeLensProvider {
    private static final String APEX_TEST_CLASS_COMMAND_REFERENCE_ID = "sfdx.force.apex.test.class.run.delegate";
    private static final String APEX_TEST_CLASS_TITLE = "Run All Tests";
    private static final String APEX_TEST_METHOD_COMMAND_REFERENCE_ID = "sfdx.force.apex.test.method.run.delegate";
    private static final String APEX_TEST_METHOD_TITLE = "Run Test";
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;

    @Inject
    public ApexTestRunCodeLensesProvider(ApexCompilerService compilerService, ApexDocumentService documentService) {
        this.compilerService = compilerService;
        this.documentService = documentService;
    }

    public static Command generateTestClassCommand(String label) {
        return new Command(APEX_TEST_CLASS_TITLE, APEX_TEST_CLASS_COMMAND_REFERENCE_ID, Lists.newArrayList(label));
    }

    public static Command generateTestMethodCommand(String label) {
        return new Command(APEX_TEST_METHOD_TITLE, APEX_TEST_METHOD_COMMAND_REFERENCE_ID, Lists.newArrayList(label));
    }

    @Override
    public List<? extends CodeLens> provideCodeLenses(CodeLensParams codeLensParams) {
        LinkedList codeLenses = Lists.newLinkedList();
        Optional<Document> optDoc = this.documentService.retrieve(URI.create(codeLensParams.getTextDocument().getUri()));
        optDoc.ifPresent(doc -> {
            Visitor codeActionsVisitor = new Visitor(codeLenses);
            CodeUnit codeUnit = CodeUnits.getMatchingElement(this.compilerService.addSources((Document)doc).compileByPassValidation(), doc.getUri().toString());
            codeUnit.additionalValidate(codeActionsVisitor);
        });
        return codeLenses;
    }

    public static CodeLens createCodeLens(Command cmd, int line) {
        CodeLens codeLens = new CodeLens();
        codeLens.setCommand(cmd);
        int lineNumberOffset = line - 1;
        Position position = new Position();
        position.setLine(lineNumberOffset);
        codeLens.setRange(new Range(position, position));
        return codeLens;
    }

    static final class Visitor
    extends AstVisitor<AdditionalPassScope> {
        private final List<CodeLens> codeLenses;

        Visitor(List<CodeLens> codeLenses) {
            this.codeLenses = codeLenses;
        }

        @Override
        public boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(UserClass node, AdditionalPassScope scope) {
            ModifierNode modifier = node.getModifiers();
            ModifierGroup modifierGroup = modifier.getModifiers();
            if (modifierGroup.isTest()) {
                Command cmd = ApexTestRunCodeLensesProvider.generateTestClassCommand(node.getDefiningType().getApexName());
                CodeLens codeLens = ApexTestRunCodeLensesProvider.createCodeLens(cmd, node.getLoc().getLine());
                this.codeLenses.add(codeLens);
            }
        }

        @Override
        public void visitEnd(Method node, AdditionalPassScope scope) {
            MethodInfo methodInfo = node.getMethodInfo();
            if (methodInfo.getModifiers().isTest()) {
                String label = methodInfo.getDefiningType().getApexName() + "." + methodInfo.getCanonicalName();
                Command cmd = ApexTestRunCodeLensesProvider.generateTestMethodCommand(label);
                CodeLens codeLens = ApexTestRunCodeLensesProvider.createCodeLens(cmd, node.getLoc().getLine());
                this.codeLenses.add(codeLens);
            }
        }
    }
}

