/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions;

import apex.jorje.lsp.api.codeActions.CodeActionsProvider;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeActionsProviderAggregator
implements CodeActionsProvider {
    private static final Logger logger = LoggerFactory.getLogger(CodeActionsProviderAggregator.class);
    private final Set<CodeActionsProvider> codeActionsProviders;

    @Inject
    public CodeActionsProviderAggregator(Set<CodeActionsProvider> codeActionsProviders) {
        this.codeActionsProviders = codeActionsProviders;
    }

    @Override
    public List<Either<Command, CodeAction>> provideCodeActions(CodeActionParams params) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LinkedList<Either<Command, CodeAction>> cmds = Lists.newLinkedList();
        this.codeActionsProviders.forEach(codeActionsProvider -> {
            try {
                cmds.addAll(codeActionsProvider.provideCodeActions(params));
            }
            catch (Exception e) {
                logger.error(String.format("Encountered an error with code action provider %s", codeActionsProvider), (Throwable)e);
            }
        });
        stopwatch.stop();
        logger.info("CodeActions for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return cmds;
    }
}

