/*
 * Decompiled with CFR 0.152.
 */
package apex.common.tuple;

import apex.common.tuple.IntPairFactory;
import apex.common.tuple.PairingFunctions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;

public class IntPairInterner<T> {
    private final Interner<T> interner;
    private final Cache<Integer, T> cache;
    private final IntPairFactory<T> factory;

    public IntPairInterner(IntPairFactory<T> factory) {
        this.factory = factory;
        this.cache = CacheBuilder.newBuilder().weakValues().build();
        this.interner = Interners.newWeakInterner();
    }

    public T intern(int x, int y) {
        if (x < 0 || x > Short.MAX_VALUE || y < 0 || y > Short.MAX_VALUE) {
            return this.interner.intern(this.factory.create(x, y));
        }
        int key = PairingFunctions.shortSzudzik(x, y);
        T value = this.cache.getIfPresent(key);
        if (value == null) {
            value = this.factory.create(x, y);
            this.cache.put(key, value);
        }
        return value;
    }

    @VisibleForTesting
    Cache<Integer, T> getCache() {
        return this.cache;
    }
}

