/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.Predicate;

public class MoreIterables {
    public static <T> boolean ensureNone(List<T> list, Predicate<T> predicate) {
        return !MoreIterables.ensureAny(list, predicate);
    }

    public static <T> boolean ensureNone(Iterable<T> iterable, Predicate<T> predicate) {
        return !MoreIterables.ensureAny(iterable, predicate);
    }

    public static <T> boolean ensureAny(List<T> list, Predicate<T> predicate) {
        if (list instanceof RandomAccess) {
            for (int i = 0; i < list.size(); ++i) {
                if (!predicate.test(list.get(i))) continue;
                return true;
            }
            return false;
        }
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean ensureAny(Iterable<T> iterable, Predicate<T> predicate) {
        if (iterable instanceof List && iterable instanceof RandomAccess) {
            return MoreIterables.ensureAny((List)iterable, predicate);
        }
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean ensureAll(List<T> list, Predicate<T> predicate) {
        return MoreIterables.ensureNone(list, predicate.negate());
    }

    public static <T> boolean ensureAll(Iterable<T> iterable, Predicate<T> predicate) {
        return MoreIterables.ensureNone(iterable, predicate.negate());
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return MoreIterables.getFirst((List)iterable);
        }
        return Iterators.get(iterable.iterator(), 0);
    }

    public static <T> T getFirst(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        return list.get(0);
    }

    public static <T> T getFirst(Iterable<T> iterable, T defaultValue) {
        if (iterable instanceof List) {
            return MoreIterables.getFirst((List)iterable, defaultValue);
        }
        return Iterables.getFirst(iterable, defaultValue);
    }

    public static <T> T getFirst(List<T> list, T defaultValue) {
        if (list.isEmpty()) {
            return defaultValue;
        }
        return list.get(0);
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        if (iterable instanceof List) {
            return MoreIterables.getOnlyElement((List)iterable);
        }
        return Iterables.getOnlyElement(iterable);
    }

    public static <T> T getOnlyElement(List<T> list) {
        if (list.size() != 1) {
            throw new IllegalArgumentException("Expected list of size 1 but was: " + list.toString());
        }
        return list.get(0);
    }
}

