/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import java.io.IOException;
import java.util.Vector;
import junit.framework.TestCase;
import org.apache.tools.ant.util.regexp.RegexpMatcher;

public abstract class RegexpMatcherTest
extends TestCase {
    public static final String UNIX_LINE = "\n";
    private RegexpMatcher reg;

    public abstract RegexpMatcher getImplementation();

    protected final RegexpMatcher getReg() {
        return this.reg;
    }

    public RegexpMatcherTest(String name) {
        super(name);
    }

    public void setUp() {
        this.reg = this.getImplementation();
    }

    public void testMatches() {
        this.reg.setPattern("aaaa");
        RegexpMatcherTest.assertTrue("aaaa should match itself", this.reg.matches("aaaa"));
        RegexpMatcherTest.assertTrue("aaaa should match xaaaa", this.reg.matches("xaaaa"));
        RegexpMatcherTest.assertTrue("aaaa shouldn't match xaaa", !this.reg.matches("xaaa"));
        this.reg.setPattern("^aaaa");
        RegexpMatcherTest.assertTrue("^aaaa shouldn't match xaaaa", !this.reg.matches("xaaaa"));
        RegexpMatcherTest.assertTrue("^aaaa should match aaaax", this.reg.matches("aaaax"));
        this.reg.setPattern("aaaa$");
        RegexpMatcherTest.assertTrue("aaaa$ shouldn't match aaaax", !this.reg.matches("aaaax"));
        RegexpMatcherTest.assertTrue("aaaa$ should match xaaaa", this.reg.matches("xaaaa"));
        this.reg.setPattern("[0-9]+");
        RegexpMatcherTest.assertTrue("[0-9]+ should match 123", this.reg.matches("123"));
        RegexpMatcherTest.assertTrue("[0-9]+ should match 1", this.reg.matches("1"));
        RegexpMatcherTest.assertTrue("[0-9]+ shouldn't match ''", !this.reg.matches(""));
        RegexpMatcherTest.assertTrue("[0-9]+ shouldn't match a", !this.reg.matches("a"));
        this.reg.setPattern("[0-9]*");
        RegexpMatcherTest.assertTrue("[0-9]* should match 123", this.reg.matches("123"));
        RegexpMatcherTest.assertTrue("[0-9]* should match 1", this.reg.matches("1"));
        RegexpMatcherTest.assertTrue("[0-9]* should match ''", this.reg.matches(""));
        RegexpMatcherTest.assertTrue("[0-9]* should match a", this.reg.matches("a"));
        this.reg.setPattern("([0-9]+)=\\1");
        RegexpMatcherTest.assertTrue("([0-9]+)=\\1 should match 1=1", this.reg.matches("1=1"));
        RegexpMatcherTest.assertTrue("([0-9]+)=\\1 shouldn't match 1=2", !this.reg.matches("1=2"));
    }

    public void testGroups() {
        this.reg.setPattern("aaaa");
        Vector v = this.reg.getGroups("xaaaa");
        RegexpMatcherTest.assertEquals("No parens -> no extra groups", 1, v.size());
        RegexpMatcherTest.assertEquals("Trivial match with no parens", "aaaa", (String)v.elementAt(0));
        this.reg.setPattern("(aaaa)");
        v = this.reg.getGroups("xaaaa");
        RegexpMatcherTest.assertEquals("Trivial match with single paren", 2, v.size());
        RegexpMatcherTest.assertEquals("Trivial match with single paren, full match", "aaaa", (String)v.elementAt(0));
        RegexpMatcherTest.assertEquals("Trivial match with single paren, matched paren", "aaaa", (String)v.elementAt(0));
        this.reg.setPattern("(a+)b(b+)");
        v = this.reg.getGroups("xaabb");
        RegexpMatcherTest.assertEquals(3, v.size());
        RegexpMatcherTest.assertEquals("aabb", (String)v.elementAt(0));
        RegexpMatcherTest.assertEquals("aa", (String)v.elementAt(1));
        RegexpMatcherTest.assertEquals("b", (String)v.elementAt(2));
    }

    public void testBugzillaReport14619() {
        this.reg.setPattern("^(.*)/src/((.*/)*)([a-zA-Z0-9_\\.]+)\\.java$");
        Vector v = this.reg.getGroups("de/tom/src/Google.java");
        RegexpMatcherTest.assertEquals(5, v.size());
        RegexpMatcherTest.assertEquals((Object)"de/tom", v.elementAt(1));
        RegexpMatcherTest.assertEquals((Object)"", v.elementAt(2));
        RegexpMatcherTest.assertEquals((Object)"", v.elementAt(3));
        RegexpMatcherTest.assertEquals((Object)"Google", v.elementAt(4));
    }

    public void testCaseInsensitiveMatch() {
        this.reg.setPattern("aaaa");
        RegexpMatcherTest.assertTrue("aaaa doesn't match AAaa", !this.reg.matches("AAaa"));
        RegexpMatcherTest.assertTrue("aaaa matches AAaa ignoring case", this.reg.matches("AAaa", 256));
    }

    public void testParagraphCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("paragraph character", !this.reg.matches("end of text\u2029"));
    }

    public void testLineSeparatorCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("line-separator character", !this.reg.matches("end of text\u2028"));
    }

    public void testNextLineCharacter() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("next-line character", !this.reg.matches("end of text\u0085"));
    }

    public void testStandaloneCR() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("standalone CR", !this.reg.matches("end of text\r"));
    }

    public void testWindowsLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("Windows line separator", !this.reg.matches("end of text\r\n"));
    }

    public void testWindowsLineSeparator2() throws IOException {
        this.reg.setPattern("end of text\r$");
        RegexpMatcherTest.assertTrue("Windows line separator", this.reg.matches("end of text\r\n"));
    }

    public void testUnixLineSeparator() throws IOException {
        this.reg.setPattern("end of text$");
        RegexpMatcherTest.assertTrue("Unix line separator", this.reg.matches("end of text\n"));
    }

    public void testMultiVersusSingleLine() throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("Line1").append(UNIX_LINE);
        buf.append("starttest Line2").append(UNIX_LINE);
        buf.append("Line3 endtest").append(UNIX_LINE);
        buf.append("Line4").append(UNIX_LINE);
        String text = buf.toString();
        this.doStartTest1(text);
        this.doStartTest2(text);
        this.doEndTest1(text);
        this.doEndTest2(text);
    }

    protected void doStartTest1(String text) {
        this.reg.setPattern("^starttest");
        RegexpMatcherTest.assertTrue("^starttest in default mode", !this.reg.matches(text));
        RegexpMatcherTest.assertTrue("^starttest in single line mode", !this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue("^starttest in multi line mode", this.reg.matches(text, 4096));
    }

    protected void doStartTest2(String text) {
        this.reg.setPattern("^Line1");
        RegexpMatcherTest.assertTrue("^Line1 in default mode", this.reg.matches(text));
        RegexpMatcherTest.assertTrue("^Line1 in single line mode", this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue("^Line1 in multi line mode", this.reg.matches(text, 4096));
    }

    protected void doEndTest1(String text) {
        this.reg.setPattern("endtest$");
        RegexpMatcherTest.assertTrue("endtest$ in default mode", !this.reg.matches(text));
        RegexpMatcherTest.assertTrue("endtest$ in single line mode", !this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue("endtest$ in multi line mode", this.reg.matches(text, 4096));
    }

    protected void doEndTest2(String text) {
        this.reg.setPattern("Line4$");
        RegexpMatcherTest.assertTrue("Line4$ in default mode", this.reg.matches(text));
        RegexpMatcherTest.assertTrue("Line4$ in single line mode", this.reg.matches(text, 65536));
        RegexpMatcherTest.assertTrue("Line4$ in multi line mode", this.reg.matches(text, 4096));
    }
}

