/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleSqlReadOnly;

public class OracleSql {
    static final int UNINITIALIZED = -1;
    static final String[] EMPTY_LIST = new String[0];
    DBConversion conversion;
    String parameterSql;
    String originalSql;
    String processedSql;
    String rowidSql;
    String actualSql;
    byte[] sqlBytes;
    byte sqlKind = (byte)-1;
    int parameterCount = -1;
    boolean currentProcessEscapes = true;
    boolean includeRowid = false;
    String[] parameterList = EMPTY_LIST;
    char[] currentParameter = null;
    boolean isV8Compatible = false;
    int bindParameterCount = -1;
    String[] bindParameterList = null;
    int cachedBindParameterCount = -1;
    String[] cachedBindParameterList = null;
    String cachedParameterSql;
    String cachedProcessedSql;
    String cachedRowidSql;
    String cachedActualSql;
    byte[] cachedSqlBytes;
    static final String param_prefix = "rowid";
    int param_suffix = 0;
    private static final int cMax = 127;
    private static final int[][] TRANSITION = OracleSqlReadOnly.TRANSITION;
    private static final int[][] ACTION = OracleSqlReadOnly.ACTION;
    private static final int NO_ACTION = 0;
    private static final int DML_ACTION = 1;
    private static final int PLSQL_ACTION = 2;
    private static final int CALL_ACTION = 3;
    private static final int SELECT_ACTION = 4;
    private static final int OTHER_ACTION = 5;
    private static final int QUESTION_ACTION = 6;
    private static final int PARAMETER_ACTION = 7;
    private static final int END_PARAMETER_ACTION = 8;
    int current_argument;
    int i;
    int length;
    char c;
    boolean first;
    boolean in_string;
    String odbc_sql;
    StringBuffer oracle_sql;
    StringBuffer token_buffer;
    boolean isLocate = false;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    OracleSql(DBConversion dBConversion) {
        this.conversion = dBConversion;
    }

    void initialize(String string) throws SQLException {
        if (string == null || string == "") {
            DatabaseError.throwSqlException(104);
        }
        this.originalSql = string;
        this.processedSql = null;
        this.rowidSql = null;
        this.actualSql = null;
        this.sqlBytes = null;
        this.sqlKind = (byte)-1;
        this.parameterCount = -1;
        this.includeRowid = false;
        this.parameterSql = this.originalSql;
        this.bindParameterCount = -1;
        this.bindParameterList = null;
        this.cachedBindParameterCount = -1;
        this.cachedBindParameterList = null;
        this.cachedParameterSql = null;
        this.cachedActualSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedSqlBytes = null;
    }

    String getOriginalSql() {
        return this.originalSql;
    }

    boolean setNamedParameters(int n, String[] stringArray) throws SQLException {
        boolean bl = false;
        if (n == 0) {
            this.bindParameterCount = -1;
            bl = this.bindParameterCount != this.cachedBindParameterCount;
        } else {
            this.bindParameterCount = n;
            this.bindParameterList = stringArray;
            boolean bl2 = bl = this.bindParameterCount != this.cachedBindParameterCount;
            if (!bl) {
                for (int i = 0; i < n; ++i) {
                    if (this.bindParameterList[i] == this.cachedBindParameterList[i]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                if (this.bindParameterCount != this.getParameterCount()) {
                    throw new SQLException("Incorrectly set or registered parameters.");
                }
                char[] cArray = this.originalSql.toCharArray();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] != '?') {
                        stringBuffer.append(cArray[i]);
                        continue;
                    }
                    stringBuffer.append(this.bindParameterList[n2++]);
                    stringBuffer.append("=>?");
                }
                if (n2 != this.bindParameterCount) {
                    throw new SQLException("Incorrectly set or registered parameters.");
                }
                this.parameterSql = new String(stringBuffer);
                this.actualSql = null;
                this.processedSql = null;
                this.rowidSql = null;
                this.sqlBytes = null;
            } else {
                this.parameterSql = this.cachedParameterSql;
                this.actualSql = this.cachedActualSql;
                this.processedSql = this.cachedProcessedSql;
                this.rowidSql = this.cachedRowidSql;
                this.sqlBytes = this.cachedSqlBytes;
            }
        }
        this.cachedBindParameterList = null;
        this.cachedParameterSql = null;
        this.cachedActualSql = null;
        this.cachedProcessedSql = null;
        this.cachedRowidSql = null;
        this.cachedSqlBytes = null;
        return bl;
    }

    void resetNamedParameters() {
        this.cachedBindParameterCount = this.bindParameterCount;
        if (this.bindParameterCount != -1) {
            if (this.cachedBindParameterList == null || this.cachedBindParameterList == this.bindParameterList || this.cachedBindParameterList.length < this.bindParameterCount) {
                this.cachedBindParameterList = new String[this.bindParameterCount];
            }
            System.arraycopy(this.bindParameterList, 0, this.cachedBindParameterList, 0, this.bindParameterCount);
            this.cachedParameterSql = this.parameterSql;
            this.cachedActualSql = this.actualSql;
            this.cachedProcessedSql = this.processedSql;
            this.cachedRowidSql = this.rowidSql;
            this.cachedSqlBytes = this.sqlBytes;
            this.bindParameterCount = -1;
            this.bindParameterList = null;
            this.parameterSql = this.originalSql;
            this.actualSql = null;
            this.processedSql = null;
            this.rowidSql = null;
            this.sqlBytes = null;
        }
    }

    String getSql(boolean bl) throws SQLException {
        if (bl != this.currentProcessEscapes) {
            this.processedSql = null;
            this.rowidSql = null;
            this.actualSql = null;
            this.sqlBytes = null;
        }
        this.currentProcessEscapes = bl;
        if (this.actualSql == null) {
            if (this.processedSql == null) {
                String string = this.processedSql = this.currentProcessEscapes ? this.parse(this.parameterSql) : this.parameterSql;
            }
            if (this.includeRowid) {
                if (this.rowidSql == null) {
                    this.rowidSql = this.addRowid(this.processedSql);
                }
                this.actualSql = this.rowidSql;
            } else {
                this.actualSql = this.processedSql;
            }
        }
        return this.actualSql;
    }

    byte[] getSqlBytes(boolean bl) throws SQLException {
        if (this.sqlBytes == null || bl != this.currentProcessEscapes) {
            this.sqlBytes = this.conversion.StringToCharBytes(this.getSql(bl));
        }
        return this.sqlBytes;
    }

    byte getSqlKind() throws SQLException {
        if (this.sqlKind == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.sqlKind;
    }

    int getParameterCount() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.parameterCount;
    }

    String[] getParameterList() throws SQLException {
        if (this.parameterCount == -1) {
            this.computeBasicInfo(this.parameterSql);
        }
        return this.parameterList;
    }

    void setIncludeRowid(boolean bl) {
        if (bl != this.includeRowid) {
            this.includeRowid = bl;
            this.actualSql = null;
            this.sqlBytes = null;
        }
    }

    public String toString() {
        return this.parameterSql == null ? "null" : this.parameterSql;
    }

    void computeBasicInfo(String string) throws SQLException {
        this.parameterCount = 0;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = n3 + 1;
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6 = n5 = i < n3 ? (int)string.charAt(i) : 32;
            if (n5 > 127) {
                n6 = Character.isLetterOrDigit((char)n5) ? 88 : 32;
            }
            switch (ACTION[n2][n6]) {
                case 0: {
                    break;
                }
                case 1: {
                    this.sqlKind = (byte)2;
                    break;
                }
                case 2: {
                    this.sqlKind = 1;
                    break;
                }
                case 3: {
                    this.sqlKind = (byte)4;
                    break;
                }
                case 4: {
                    this.sqlKind = 0;
                    break;
                }
                case 5: {
                    this.sqlKind = (byte)3;
                    break;
                }
                case 6: {
                    ++this.parameterCount;
                    break;
                }
                case 7: {
                    if (this.currentParameter == null) {
                        this.currentParameter = new char[32];
                    }
                    if (n >= this.currentParameter.length) {
                        DatabaseError.throwSqlException(134, new String(this.currentParameter));
                    }
                    this.currentParameter[n++] = n5;
                    break;
                }
                case 8: {
                    if (n <= 0) break;
                    if (this.parameterList == EMPTY_LIST) {
                        this.parameterList = new String[8];
                    } else if (this.parameterList.length <= this.parameterCount) {
                        String[] stringArray = new String[this.parameterList.length * 4];
                        System.arraycopy(this.parameterList, 0, stringArray, 0, this.parameterList.length);
                        this.parameterList = stringArray;
                    }
                    this.parameterList[this.parameterCount] = new String(this.currentParameter, 0, n).intern();
                    n = 0;
                    ++this.parameterCount;
                }
            }
            n2 = TRANSITION[n2][n6];
        }
    }

    private String addRowid(String string) throws SQLException {
        String string2 = string.toLowerCase();
        int n = string2.indexOf("select");
        if (n == -1) {
            DatabaseError.throwSqlException(88);
        }
        String string3 = "select rowid," + string.substring(n + "select".length());
        return string3;
    }

    String parse(String string) throws SQLException {
        this.current_argument = 1;
        this.i = 0;
        this.first = true;
        this.in_string = false;
        this.odbc_sql = string;
        this.length = this.odbc_sql.length();
        if (this.oracle_sql == null) {
            this.oracle_sql = new StringBuffer(this.length);
            this.token_buffer = new StringBuffer(32);
        } else {
            this.oracle_sql.ensureCapacity(this.length);
        }
        this.oracle_sql.delete(0, this.oracle_sql.length());
        this.skipSpace();
        this.handleODBC();
        if (this.i < this.length) {
            Integer n = new Integer(this.i);
            DatabaseError.check_error(33, n);
        }
        return this.oracle_sql.substring(0, this.oracle_sql.length());
    }

    void handleODBC() throws SQLException {
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        boolean bl = false;
        block5: while (this.i < this.length) {
            this.c = this.odbc_sql.charAt(this.i);
            if (this.in_string) {
                this.oracle_sql.append(this.c);
                if (this.c == '\'') {
                    this.in_string = false;
                }
                ++this.i;
                continue;
            }
            switch (this.c) {
                case '\'': {
                    if (this.isLocate) {
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                            stringBuffer2 = new StringBuffer();
                        }
                        stringBuffer.append(this.c);
                        ++this.i;
                        continue block5;
                    }
                    this.oracle_sql.append(this.c);
                    this.in_string = true;
                    ++this.i;
                    this.first = false;
                    continue block5;
                }
                case '{': {
                    this.token_buffer.delete(0, this.token_buffer.length());
                    ++this.i;
                    this.skipSpace();
                    while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
                        this.token_buffer.append(this.c);
                        ++this.i;
                    }
                    this.handleToken(this.token_buffer.substring(0, this.token_buffer.length()));
                    this.c = this.odbc_sql.charAt(this.i);
                    if (this.c != '}') {
                        String string = new String(this.i + ": Expecting \"}\" got \"" + this.c + "\"");
                        DatabaseError.check_error(33, string);
                    }
                    ++this.i;
                    continue block5;
                }
                case '}': {
                    return;
                }
            }
            if (this.c != ' ' && this.c != '(' && this.isLocate) {
                if (this.c == ')') {
                    if (stringBuffer2.substring(0, stringBuffer2.length()).trim().equals("?")) {
                        this.oracle_sql.append(this.nextArgument());
                    } else {
                        this.oracle_sql.append(stringBuffer2);
                    }
                    this.oracle_sql.append(", ");
                    if (stringBuffer.substring(0, stringBuffer.length()).trim().equals("?")) {
                        this.oracle_sql.append(this.nextArgument());
                    } else {
                        this.oracle_sql.append(stringBuffer);
                    }
                    this.appendChar(this.oracle_sql, this.c);
                    this.isLocate = false;
                }
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer2 = new StringBuffer();
                }
                if (this.c == ',') {
                    bl = true;
                    ++this.i;
                    this.first = false;
                    continue;
                }
                if (!bl) {
                    stringBuffer.append(this.c);
                } else {
                    stringBuffer2.append(this.c);
                }
            } else {
                this.appendChar(this.oracle_sql, this.c);
            }
            ++this.i;
            this.first = false;
        }
    }

    void handleToken(String string) throws SQLException {
        if (string.equalsIgnoreCase("?")) {
            this.handleFunction();
        } else if (string.equalsIgnoreCase("call")) {
            this.handleCall();
        } else if (string.equalsIgnoreCase("ts")) {
            this.handleTimestamp();
        } else if (string.equalsIgnoreCase("t")) {
            this.handleTime();
        } else if (string.equalsIgnoreCase("d")) {
            this.handleDate();
        } else if (string.equalsIgnoreCase("escape")) {
            this.handleEscape();
        } else if (string.equalsIgnoreCase("fn")) {
            this.handleScalarFunction();
        } else if (string.equalsIgnoreCase("oj")) {
            this.handleOuterJoin();
        } else {
            String string2 = new String(this.i + ": " + string);
            DatabaseError.check_error(34, string2);
        }
    }

    void handleFunction() throws SQLException {
        String string;
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.appendChar(this.oracle_sql, '?');
        this.skipSpace();
        if (this.c != '=') {
            string = new String(this.i + ". Expecting \"=\" got \"" + this.c + "\"");
            DatabaseError.check_error(33, string);
        }
        ++this.i;
        this.skipSpace();
        if (!this.odbc_sql.startsWith("call", this.i)) {
            string = new String(this.i + ". Expecting \"call\"");
            DatabaseError.check_error(33, string);
        }
        this.i += 4;
        this.oracle_sql.append(" := ");
        this.skipSpace();
        this.handleODBC();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleCall() throws SQLException {
        boolean bl = this.first;
        if (bl) {
            this.oracle_sql.append("BEGIN ");
        }
        this.skipSpace();
        this.handleODBC();
        this.skipSpace();
        if (bl) {
            this.oracle_sql.append("; END;");
        }
    }

    void handleTimestamp() throws SQLException {
        if (this.isV8Compatible) {
            this.oracle_sql.append("TO_DATE (");
            this.skipSpace();
            boolean bl = false;
            while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) != '}') {
                if (!bl) {
                    if (this.c == '.') {
                        bl = true;
                    } else {
                        this.oracle_sql.append(this.c);
                    }
                }
                ++this.i;
            }
            if (bl) {
                this.oracle_sql.append('\'');
            }
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS')");
        } else {
            this.oracle_sql.append("TO_TIMESTAMP (");
            this.skipSpace();
            this.handleODBC();
            this.oracle_sql.append(", 'YYYY-MM-DD HH24:MI:SS.FF')");
        }
    }

    void handleTime() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'HH24:MI:SS')");
    }

    void handleDate() throws SQLException {
        this.oracle_sql.append("TO_DATE (");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(", 'YYYY-MM-DD')");
    }

    void handleEscape() throws SQLException {
        this.oracle_sql.append("ESCAPE ");
        this.skipSpace();
        this.handleODBC();
    }

    void handleScalarFunction() throws SQLException {
        this.token_buffer.delete(0, this.token_buffer.length());
        ++this.i;
        this.skipSpace();
        while (this.i < this.length && (Character.isJavaLetterOrDigit(this.c = this.odbc_sql.charAt(this.i)) || this.c == '?')) {
            this.token_buffer.append(this.c);
            ++this.i;
        }
        String string = this.token_buffer.substring(0, this.token_buffer.length()).toUpperCase().intern();
        if (string == "ABS") {
            this.usingFunctionName(string);
        } else if (string == "ACOS") {
            this.usingFunctionName(string);
        } else if (string == "ASIN") {
            this.usingFunctionName(string);
        } else if (string == "ATAN") {
            this.usingFunctionName(string);
        } else if (string == "ATAN2") {
            this.usingFunctionName(string);
        } else if (string == "CEILING") {
            this.usingFunctionName("CEIL");
        } else if (string == "COS") {
            this.usingFunctionName(string);
        } else if (string == "COT") {
            DatabaseError.check_error(34, string);
        } else if (string == "DEGREES") {
            DatabaseError.check_error(34, string);
        } else if (string == "EXP") {
            this.usingFunctionName(string);
        } else if (string == "FLOOR") {
            this.usingFunctionName(string);
        } else if (string == "LOG") {
            this.usingFunctionName("LN");
        } else if (string == "LOG10") {
            this.replacingFunctionPrefix("LOG ( 10, ");
        } else if (string == "MOD") {
            this.usingFunctionName(string);
        } else if (string == "PI") {
            this.replacingFunctionPrefix("( 3.141592653589793238462643383279502884197169399375 ");
        } else if (string == "POWER") {
            this.usingFunctionName(string);
        } else if (string == "RADIANS") {
            DatabaseError.check_error(34, string);
        } else if (string == "RAND") {
            DatabaseError.check_error(34, string);
        } else if (string == "ROUND") {
            this.usingFunctionName(string);
        } else if (string == "SIGN") {
            this.usingFunctionName(string);
        } else if (string == "SIN") {
            this.usingFunctionName(string);
        } else if (string == "SQRT") {
            this.usingFunctionName(string);
        } else if (string == "TAN") {
            this.usingFunctionName(string);
        } else if (string == "TRUNCATE") {
            this.usingFunctionName("TRUNC");
        } else if (string == "ASCII") {
            this.usingFunctionName(string);
        } else if (string == "CHAR") {
            this.usingFunctionName("CHR");
        } else if (string == "CONCAT") {
            this.usingFunctionName(string);
        } else if (string == "DIFFERENCE") {
            DatabaseError.check_error(34, string);
        } else if (string == "INSERT") {
            DatabaseError.check_error(34, string);
        } else if (string == "LCASE") {
            this.usingFunctionName("LOWER");
        } else if (string == "LEFT") {
            DatabaseError.check_error(34, string);
        } else if (string == "LENGTH") {
            this.usingFunctionName(string);
        } else if (string == "LOCATE") {
            this.isLocate = true;
            this.usingFunctionName("INSTR");
        } else if (string == "LTRIM") {
            this.usingFunctionName(string);
        } else if (string == "REPEAT") {
            DatabaseError.check_error(34, string);
        } else if (string == "REPLACE") {
            this.usingFunctionName(string);
        } else if (string == "RIGHT") {
            DatabaseError.check_error(34, string);
        } else if (string == "RTRIM") {
            this.usingFunctionName(string);
        } else if (string == "SOUNDEX") {
            this.usingFunctionName(string);
        } else if (string == "SPACE") {
            DatabaseError.check_error(34, string);
        } else if (string == "SUBSTRING") {
            this.usingFunctionName("SUBSTR");
        } else if (string == "UCASE") {
            this.usingFunctionName("UPPER");
        } else if (string == "CURDATE") {
            this.replacingFunctionPrefix("(CURRENT_DATE");
        } else if (string == "CURTIME") {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string == "DAYNAME") {
            DatabaseError.check_error(34, string);
        } else if (string == "DAYOFMONTH") {
            this.replacingFunctionPrefix("EXTRACT ( DAY FROM ");
        } else if (string == "DAYOFWEEK") {
            DatabaseError.check_error(34, string);
        } else if (string == "DAYOFYEAR") {
            DatabaseError.check_error(34, string);
        } else if (string == "HOUR") {
            this.replacingFunctionPrefix("EXTRACT ( HOUR FROM ");
        } else if (string == "MINUTE") {
            this.replacingFunctionPrefix("EXTRACT ( MINUTE FROM ");
        } else if (string == "MONTH") {
            this.replacingFunctionPrefix("EXTRACT ( MONTH FROM ");
        } else if (string == "MONTHNAME") {
            DatabaseError.check_error(34, string);
        } else if (string == "NOW") {
            this.replacingFunctionPrefix("(CURRENT_TIMESTAMP");
        } else if (string == "QUARTER") {
            DatabaseError.check_error(34, string);
        } else if (string == "SECOND") {
            this.replacingFunctionPrefix("EXTRACT ( SECOND FROM ");
        } else if (string == "TIMESTAMPADD") {
            DatabaseError.check_error(34, string);
        } else if (string == "TIMESTAMPDIFF") {
            DatabaseError.check_error(34, string);
        } else if (string == "WEEK") {
            DatabaseError.check_error(34, string);
        } else if (string == "YEAR") {
            this.replacingFunctionPrefix("EXTRACT ( YEAR FROM ");
        } else if (string == "DATABASE") {
            DatabaseError.check_error(34, string);
        } else if (string == "IFNULL") {
            DatabaseError.check_error(34, string);
        } else if (string == "USER") {
            this.replacingFunctionPrefix("(USER");
        } else if (string == "CONVERT") {
            DatabaseError.check_error(34, string);
        } else {
            DatabaseError.check_error(34, string);
        }
    }

    void usingFunctionName(String string) throws SQLException {
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }

    void replacingFunctionPrefix(String string) throws SQLException {
        this.skipSpace();
        if (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == '(') {
            ++this.i;
        } else {
            DatabaseError.check_error(33);
        }
        this.oracle_sql.append(string);
        this.skipSpace();
        this.handleODBC();
    }

    void handleOuterJoin() throws SQLException {
        this.oracle_sql.append(" ( ");
        this.skipSpace();
        this.handleODBC();
        this.oracle_sql.append(" ) ");
    }

    String nextArgument() {
        String string = ":" + this.current_argument;
        ++this.current_argument;
        return string;
    }

    void appendChar(StringBuffer stringBuffer, char c) {
        if (c == '?') {
            stringBuffer.append(this.nextArgument());
        } else {
            stringBuffer.append(c);
        }
    }

    void skipSpace() {
        while (this.i < this.length && (this.c = this.odbc_sql.charAt(this.i)) == ' ') {
            ++this.i;
        }
    }

    String generateParameterName() {
        String string = param_prefix + this.param_suffix++;
        if (this.parameterCount > 0 && this.parameterList != null) {
            for (int i = 0; i < this.parameterList.length && this.parameterList[i].equals(string); ++i) {
            }
            string = param_prefix + this.param_suffix++;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            OracleSql oracleSql = new OracleSql(null);
            oracleSql.initialize(stringArray[0]);
            long l = System.currentTimeMillis();
            for (int i = 0; i < 1; ++i) {
                oracleSql.computeBasicInfo(stringArray[0]);
            }
            System.out.println("new: " + (System.currentTimeMillis() - l) + ", " + oracleSql.sqlKind + ", " + oracleSql.parameterCount);
            String[] stringArray2 = oracleSql.getParameterList();
            if (stringArray2 == EMPTY_LIST) {
                System.out.println("parameterList is empty");
            } else {
                for (int i = 0; i < stringArray2.length; ++i) {
                    System.out.println("parameterList[" + i + "] = " + stringArray2[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

