/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.UnicodeMapChar;

public class OraMapTable
implements Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static final String NAMEPREFIX = "/oracle/i18n/data/lx4";
    private static final String IDPREFIX = "0000";
    private static final HashMap OraMapTableCache = new HashMap();
    protected String VERSION;
    protected String Name;
    protected String Id;
    protected HashMap mapTable;
    protected Map attrTable;

    public static synchronized OraMapTable getInstance(int n) {
        String string = Integer.toHexString(n);
        OraMapTable oraMapTable = (OraMapTable)OraMapTableCache.get(string);
        if (oraMapTable != null) {
            return oraMapTable;
        }
        ConverterArchive converterArchive = new ConverterArchive();
        String string2 = NAMEPREFIX + IDPREFIX.substring(0, 4 - string.length()) + string + ".glb";
        oraMapTable = (OraMapTable)converterArchive.readObj(string2);
        if (oraMapTable != null) {
            OraMapTableCache.put(string, oraMapTable);
        }
        return oraMapTable;
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public String getName() {
        return this.Name;
    }

    public String getId() {
        return this.Id;
    }

    public String getStringAttribute(String string) {
        return (String)this.mapTable.get(string);
    }

    public String[] getStringArrayAttribute(String string) {
        return (String[])this.mapTable.get(string);
    }

    public HashMap getHashMapAttribute(String string) {
        return (HashMap)this.mapTable.get(string);
    }

    public UnicodeMapChar getUnicodeMap(String string) {
        return (UnicodeMapChar)this.mapTable.get(string);
    }

    public Map getElementAttributes(String string) {
        return (Map)this.attrTable.get(string);
    }
}

