/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTMemberSelector;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameFinder {
    private List<NameOccurrence> names = new ArrayList<NameOccurrence>();

    public NameFinder(ASTPrimaryExpression node) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)node.jjtGetChild(0);
        if (prefix.usesSuperModifier()) {
            this.add(new NameOccurrence(prefix, "super"));
        } else if (prefix.usesThisModifier()) {
            this.add(new NameOccurrence(prefix, "this"));
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            this.checkForNameChild((JavaNode)node.jjtGetChild(i));
        }
    }

    public List<NameOccurrence> getNames() {
        return this.names;
    }

    private void checkForNameChild(JavaNode node) {
        if (node.getImage() != null) {
            this.add(new NameOccurrence(node, node.getImage()));
        }
        if (node.jjtGetNumChildren() > 0 && node.jjtGetChild(0) instanceof ASTName) {
            ASTName grandchild = (ASTName)node.jjtGetChild(0);
            StringTokenizer st = new StringTokenizer(grandchild.getImage(), ".");
            while (st.hasMoreTokens()) {
                this.add(new NameOccurrence(grandchild, st.nextToken()));
            }
        }
        if (node instanceof ASTPrimarySuffix) {
            ASTPrimarySuffix suffix = (ASTPrimarySuffix)node;
            if (suffix.isArguments()) {
                NameOccurrence occurrence = this.names.get(this.names.size() - 1);
                occurrence.setIsMethodOrConstructorInvocation();
                ASTArguments args = (ASTArguments)((ASTPrimarySuffix)node).jjtGetChild(0);
                occurrence.setArgumentCount(args.getArgumentCount());
            } else if (suffix.jjtGetNumChildren() == 1 && suffix.jjtGetChild(0) instanceof ASTMemberSelector) {
                this.add(new NameOccurrence((JavaNode)suffix.jjtGetChild(0), suffix.jjtGetChild(0).getImage()));
            }
        }
    }

    private void add(NameOccurrence name) {
        this.names.add(name);
        if (this.names.size() > 1) {
            NameOccurrence qualifiedName = this.names.get(this.names.size() - 2);
            qualifiedName.setNameWhichThisQualifies(name);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (NameOccurrence occ : this.names) {
            result.append(occ);
            result.append(PMD.EOL);
        }
        return result.toString();
    }
}

