/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.strings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.CharacterProperty;
import net.sourceforge.pmd.lang.rule.properties.FileProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.rule.properties.StringProperty;
import net.sourceforge.pmd.util.IOUtil;
import net.sourceforge.pmd.util.StringUtil;

public class AvoidDuplicateLiteralsRule
extends AbstractJavaRule {
    public static final IntegerProperty THRESHOLD_DESCRIPTOR = new IntegerProperty("maxDuplicateLiterals", "Max duplicate literals", 1, 20, 4, 1.0f);
    public static final IntegerProperty MINIMUM_LENGTH_DESCRIPTOR = new IntegerProperty("minimumLength", "Minimum string length to check", 1, Integer.MAX_VALUE, 3, 1.5f);
    public static final BooleanProperty SKIP_ANNOTATIONS_DESCRIPTOR = new BooleanProperty("skipAnnotations", "Skip literals within annotations", false, 2.0f);
    public static final StringProperty EXCEPTION_LIST_DESCRIPTOR = new StringProperty("exceptionList", "Strings to ignore", null, 3.0f);
    public static final CharacterProperty SEPARATOR_DESCRIPTOR = new CharacterProperty("separator", "Ignore list separator", Character.valueOf(','), 4.0f);
    public static final FileProperty EXCEPTION_FILE_DESCRIPTOR = new FileProperty("exceptionfile", "File containing strings to skip (one string per line), only used if ignore list is not set", null, 5.0f);
    private Map<String, List<ASTLiteral>> literals = new HashMap<String, List<ASTLiteral>>();
    private Set<String> exceptions = new HashSet<String>();
    private int minLength;

    public AvoidDuplicateLiteralsRule() {
        this.definePropertyDescriptor(THRESHOLD_DESCRIPTOR);
        this.definePropertyDescriptor(MINIMUM_LENGTH_DESCRIPTOR);
        this.definePropertyDescriptor(SKIP_ANNOTATIONS_DESCRIPTOR);
        this.definePropertyDescriptor(EXCEPTION_LIST_DESCRIPTOR);
        this.definePropertyDescriptor(SEPARATOR_DESCRIPTOR);
        this.definePropertyDescriptor(EXCEPTION_FILE_DESCRIPTOR);
    }

    private LineNumberReader getLineReader() throws FileNotFoundException {
        return new LineNumberReader(new BufferedReader(new FileReader(this.getProperty(EXCEPTION_FILE_DESCRIPTOR))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visit(ASTCompilationUnit node, Object data) {
        this.literals.clear();
        if (this.getProperty(EXCEPTION_LIST_DESCRIPTOR) != null) {
            ExceptionParser p = new ExceptionParser(this.getProperty(SEPARATOR_DESCRIPTOR).charValue());
            this.exceptions = p.parse(this.getProperty(EXCEPTION_LIST_DESCRIPTOR));
        } else if (this.getProperty(EXCEPTION_FILE_DESCRIPTOR) != null) {
            this.exceptions = new HashSet<String>();
            LineNumberReader reader = null;
            try {
                String line;
                reader = this.getLineReader();
                while ((line = reader.readLine()) != null) {
                    this.exceptions.add(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                IOUtil.closeQuietly(reader);
            }
        }
        super.visit(node, data);
        this.processResults(data);
        this.minLength = 2 + this.getProperty(MINIMUM_LENGTH_DESCRIPTOR);
        return data;
    }

    private void processResults(Object data) {
        int threshold = this.getProperty(THRESHOLD_DESCRIPTOR);
        for (Map.Entry<String, List<ASTLiteral>> entry : this.literals.entrySet()) {
            List<ASTLiteral> occurrences = entry.getValue();
            if (occurrences.size() < threshold) continue;
            Object[] args = new Object[]{entry.getKey(), occurrences.size(), occurrences.get(0).getBeginLine()};
            this.addViolation(data, (Node)occurrences.get(0), args);
        }
    }

    public Object visit(ASTLiteral node, Object data) {
        if (!node.isStringLiteral()) {
            return data;
        }
        String image = node.getImage();
        if (image.length() < this.minLength) {
            return data;
        }
        if (this.exceptions.contains(image.substring(1, image.length() - 1))) {
            return data;
        }
        if (this.getProperty(SKIP_ANNOTATIONS_DESCRIPTOR).booleanValue() && node.getFirstParentOfType(ASTAnnotation.class) != null) {
            return data;
        }
        if (this.literals.containsKey(image)) {
            List<ASTLiteral> occurrences = this.literals.get(image);
            occurrences.add(node);
        } else {
            ArrayList<ASTLiteral> occurrences = new ArrayList<ASTLiteral>();
            occurrences.add(node);
            this.literals.put(image, occurrences);
        }
        return data;
    }

    private static String checkFile(File file) {
        if (!file.exists()) {
            return "File '" + file.getName() + "' does not exist";
        }
        if (!file.canRead()) {
            return "File '" + file.getName() + "' cannot be read";
        }
        if (file.length() == 0L) {
            return "File '" + file.getName() + "' is empty";
        }
        return null;
    }

    public String dysfunctionReason() {
        File file = this.getProperty(EXCEPTION_FILE_DESCRIPTOR);
        if (file != null) {
            String issue = AvoidDuplicateLiteralsRule.checkFile(file);
            if (issue != null) {
                return issue;
            }
            String ignores = this.getProperty(EXCEPTION_LIST_DESCRIPTOR);
            if (StringUtil.isNotEmpty(ignores)) {
                return "Cannot reference external file AND local values";
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExceptionParser {
        private static final char ESCAPE_CHAR = '\\';
        private char delimiter;

        public ExceptionParser(char delimiter) {
            this.delimiter = delimiter;
        }

        public Set<String> parse(String s) {
            HashSet<String> result = new HashSet<String>();
            StringBuilder currentToken = new StringBuilder();
            boolean inEscapeMode = false;
            for (int i = 0; i < s.length(); ++i) {
                if (inEscapeMode) {
                    inEscapeMode = false;
                    currentToken.append(s.charAt(i));
                    continue;
                }
                if (s.charAt(i) == '\\') {
                    inEscapeMode = true;
                    continue;
                }
                if (s.charAt(i) == this.delimiter) {
                    result.add(currentToken.toString());
                    currentToken = new StringBuilder();
                    continue;
                }
                currentToken.append(s.charAt(i));
            }
            if (currentToken.length() > 0) {
                result.add(currentToken.toString());
            }
            return result;
        }
    }
}

