/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class SourceCodeScraper
extends FilterReader {
    private PrintWriter writer;
    private boolean autoclose;

    public SourceCodeScraper(LineNumberReader reader, PrintWriter writer, boolean autoclose, String xsltHref) throws IOException {
        super(reader);
        this.writer = writer;
        this.autoclose = autoclose;
        this.writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (null != xsltHref) {
            this.writer.println(String.format("<?xml-stylesheet type=\"text/xsl\" href=\"%s\" ?>", xsltHref));
        }
        this.writer.println("<file>");
    }

    public SourceCodeScraper(Reader reader, Writer writer, boolean autoclose, String xsltHref) throws IOException {
        this(new LineNumberReader(reader), new PrintWriter(writer), autoclose, xsltHref);
    }

    public SourceCodeScraper(LineNumberReader reader, PrintWriter writer, boolean autoclose, File xsltFile) throws IOException {
        this(reader, writer, autoclose, null == xsltFile ? null : xsltFile.getCanonicalPath());
    }

    public SourceCodeScraper(Reader reader, Writer writer, boolean autoclose, File xsltFile) throws IOException {
        this(new LineNumberReader(reader), new PrintWriter(writer), autoclose, xsltFile);
    }

    public SourceCodeScraper(LineNumberReader reader, PrintWriter writer, File xsltFile) throws IOException {
        this(reader, writer, false, xsltFile);
    }

    public SourceCodeScraper(Reader reader, Writer writer, File xsltFile) throws IOException {
        this(new LineNumberReader(reader), new PrintWriter(writer), false, xsltFile);
    }

    public void close() throws IOException {
        super.close();
        this.writer.println("]]></line>\n</file>");
        if (this.autoclose) {
            this.writer.flush();
            this.writer.close();
        }
    }

    public int read() throws IOException {
        int c = super.read();
        if (-1 == c) {
            if (this.autoclose) {
                this.writer.println("]]></line>\n</file>");
                this.writer.close();
            }
        } else {
            if (10 == c) {
                this.writer.print("]]></line>");
            }
            this.writer.write(c);
            if (10 == c) {
                this.writer.print(String.format("<line number=\"%d\"><![CDATA[", ((LineNumberReader)this.in).getLineNumber()));
            }
        }
        return c;
    }

    public int read(char[] cbuf) throws IOException {
        int lineNumber = ((LineNumberReader)this.in).getLineNumber();
        int charactersRead = super.read(cbuf);
        if (-1 == charactersRead) {
            if (this.autoclose) {
                this.writer.println("]]></line>\n</file>");
                this.writer.flush();
                this.writer.close();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int offset = 0; offset < charactersRead; ++offset) {
                if ('\n' == cbuf[offset]) {
                    if (lineNumber > 0) {
                        stringBuilder.append("]]></line>");
                    }
                    stringBuilder.append(cbuf[offset]);
                    stringBuilder.append(String.format("<line number=\"%d\"><![CDATA[", ++lineNumber));
                    continue;
                }
                stringBuilder.append(cbuf[offset]);
            }
            this.writer.write(stringBuilder.toString());
        }
        return charactersRead;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int lineNumber = ((LineNumberReader)this.in).getLineNumber();
        int charactersRead = super.read(cbuf, off, len);
        if (-1 == charactersRead) {
            if (this.autoclose) {
                this.writer.println("]]></line>\n</file>");
                this.writer.flush();
                this.writer.close();
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int offset = 0; offset < charactersRead; ++offset) {
                if ('\n' == cbuf[offset]) {
                    if (lineNumber > 0) {
                        stringBuilder.append("]]></line>");
                    }
                    stringBuilder.append(cbuf[offset]);
                    stringBuilder.append(String.format("<line number=\"%d\"><![CDATA[", ++lineNumber));
                    continue;
                }
                stringBuilder.append(cbuf[offset]);
            }
            this.writer.write(stringBuilder.toString());
        }
        return charactersRead;
    }

    public String readLine() throws IOException {
        String line = ((LineNumberReader)this.in).readLine();
        if (null == line) {
            if (this.autoclose) {
                this.writer.println("]]></line>\n</file>");
                this.writer.close();
            }
        } else {
            this.writer.println(String.format("<line number=\"%d\"><![CDATA[%s]]>", ((LineNumberReader)this.in).getLineNumber(), line));
        }
        return line;
    }
}

