/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public final class CustomSSLSocketFactory
extends SocketFactory {
    private static SSLSocketFactory ossl = null;

    public CustomSSLSocketFactory() {
        if (ossl == null) {
            ossl = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
    }

    public static SocketFactory getDefault() {
        return new CustomSSLSocketFactory();
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n, inetAddress, n2);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n, inetAddress2, n2);
        return this.init(sSLSocket);
    }

    private SSLSocket init(SSLSocket sSLSocket) throws IOException {
        sSLSocket.setUseClientMode(true);
        sSLSocket.setEnabledCipherSuites(ossl.getSupportedCipherSuites());
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

