/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.properties;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Map;
import net.sourceforge.pmd.PropertyDescriptorFactory;
import net.sourceforge.pmd.lang.rule.properties.AbstractPackagedProperty;
import net.sourceforge.pmd.lang.rule.properties.factories.BasicPropertyDescriptorFactory;
import net.sourceforge.pmd.util.ClassUtil;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodProperty
extends AbstractPackagedProperty<Method> {
    public static final char CLASS_METHOD_DELIMITER = '#';
    public static final char METHOD_ARG_DELIMITER = ',';
    public static final char[] METHOD_GROUP_DELIMITERS = new char[]{'(', ')'};
    private static final String ARRAY_FLAG = "[]";
    private static final Map<Class<?>, String> TYPE_SHORTCUTS = ClassUtil.getClassShortNames();
    public static final PropertyDescriptorFactory FACTORY = new BasicPropertyDescriptorFactory<MethodProperty>(Method.class, packagedFieldTypesByKey){

        public MethodProperty createWith(Map<String, String> valuesById) {
            return new MethodProperty(this.nameIn(valuesById), this.descriptionIn(valuesById), this.defaultValueIn(valuesById), 1.legalPackageNamesIn(valuesById), 0.0f);
        }
    };

    private static String shortestNameFor(Class<?> cls) {
        String compactName = TYPE_SHORTCUTS.get(cls);
        return compactName == null ? cls.getName() : compactName;
    }

    public static String asStringFor(Method method) {
        StringBuilder sb = new StringBuilder();
        MethodProperty.asStringOn(method, sb);
        return sb.toString();
    }

    @Override
    protected String defaultAsString() {
        return MethodProperty.asStringFor((Method)this.defaultValue());
    }

    private static void serializedTypeIdOn(Class<?> type, StringBuilder sb) {
        Class<?> arrayType = type.getComponentType();
        if (arrayType == null) {
            sb.append(MethodProperty.shortestNameFor(type));
            return;
        }
        sb.append(MethodProperty.shortestNameFor(arrayType)).append(ARRAY_FLAG);
    }

    public static void asStringOn(Method method, StringBuilder sb) {
        Class<?> clazz = method.getDeclaringClass();
        sb.append(MethodProperty.shortestNameFor(clazz));
        sb.append('#');
        sb.append(method.getName());
        sb.append(METHOD_GROUP_DELIMITERS[0]);
        Class<?>[] argTypes = method.getParameterTypes();
        if (argTypes.length == 0) {
            sb.append(METHOD_GROUP_DELIMITERS[1]);
            return;
        }
        MethodProperty.serializedTypeIdOn(argTypes[0], sb);
        for (int i = 1; i < argTypes.length; ++i) {
            sb.append(',');
            MethodProperty.serializedTypeIdOn(argTypes[i], sb);
        }
        sb.append(METHOD_GROUP_DELIMITERS[1]);
    }

    private static Class<?> typeFor(String typeName) {
        Class<?> type = null;
        if (typeName.endsWith(ARRAY_FLAG)) {
            String arrayTypeName = typeName.substring(0, typeName.length() - ARRAY_FLAG.length());
            type = MethodProperty.typeFor(arrayTypeName);
            return Array.newInstance(type, 0).getClass();
        }
        type = ClassUtil.getTypeFor(typeName);
        if (type != null) {
            return type;
        }
        try {
            return Class.forName(typeName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Method methodFrom(String methodNameAndArgTypes, char classMethodDelimiter, char methodArgDelimiter) {
        int delimPos0 = methodNameAndArgTypes.indexOf(classMethodDelimiter);
        if (delimPos0 < 0) {
            return null;
        }
        String className = methodNameAndArgTypes.substring(0, delimPos0);
        Class<?> type = ClassUtil.getTypeFor(className);
        if (type == null) {
            return null;
        }
        int delimPos1 = methodNameAndArgTypes.indexOf(METHOD_GROUP_DELIMITERS[0]);
        if (delimPos1 < 0) {
            String methodName = methodNameAndArgTypes.substring(delimPos0 + 1);
            return ClassUtil.methodFor(type, methodName, ClassUtil.EMPTY_CLASS_ARRAY);
        }
        String methodName = methodNameAndArgTypes.substring(delimPos0 + 1, delimPos1);
        if (StringUtil.isEmpty(methodName)) {
            return null;
        }
        int delimPos2 = methodNameAndArgTypes.indexOf(METHOD_GROUP_DELIMITERS[1]);
        if (delimPos2 < 0) {
            return null;
        }
        String argTypesStr = methodNameAndArgTypes.substring(delimPos1 + 1, delimPos2);
        if (StringUtil.isEmpty(argTypesStr)) {
            return ClassUtil.methodFor(type, methodName, ClassUtil.EMPTY_CLASS_ARRAY);
        }
        String[] argTypeNames = StringUtil.substringsOf(argTypesStr, methodArgDelimiter);
        Class[] argTypes = new Class[argTypeNames.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = MethodProperty.typeFor(argTypeNames[i]);
        }
        return ClassUtil.methodFor(type, methodName, argTypes);
    }

    public static Method methodFrom(String methodStr) {
        return MethodProperty.methodFrom(methodStr, '#', ',');
    }

    public MethodProperty(String theName, String theDescription, Method theDefault, String[] legalPackageNames, float theUIOrder) {
        super(theName, theDescription, theDefault, legalPackageNames, theUIOrder);
    }

    public MethodProperty(String theName, String theDescription, String defaultMethodStr, String[] legalPackageNames, float theUIOrder) {
        super(theName, theDescription, MethodProperty.methodFrom(defaultMethodStr), legalPackageNames, theUIOrder);
    }

    public MethodProperty(String theName, String theDescription, String defaultMethodStr, Map<String, String> otherParams, float theUIOrder) {
        this(theName, theDescription, MethodProperty.methodFrom(defaultMethodStr), MethodProperty.packageNamesIn(otherParams), theUIOrder);
    }

    @Override
    protected String asString(Object value) {
        return value == null ? "" : MethodProperty.asStringFor((Method)value);
    }

    @Override
    protected String packageNameOf(Object item) {
        Method method = (Method)item;
        return method.getDeclaringClass().getName() + '.' + method.getName();
    }

    @Override
    protected String itemTypeName() {
        return "method";
    }

    @Override
    public Class<Method> type() {
        return Method.class;
    }

    @Override
    public Method valueFrom(String valueString) throws IllegalArgumentException {
        return MethodProperty.methodFrom(valueString);
    }
}

