/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentToNonFinalStaticRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map<VariableNameDeclaration, List<NameOccurrence>> vars = node.getScope().getVariableDeclarations();
        for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : vars.entrySet()) {
            VariableNameDeclaration decl = entry.getKey();
            if (!decl.getAccessNodeParent().isStatic() || decl.getAccessNodeParent().isFinal() || !this.initializedInConstructor(entry.getValue())) continue;
            this.addViolation(data, (Node)decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private boolean initializedInConstructor(List<NameOccurrence> usages) {
        boolean initInConstructor = false;
        for (NameOccurrence occ : usages) {
            JavaNode node;
            Node constructor;
            if (!occ.isOnLeftHandSide() || (constructor = (Node)(node = occ.getLocation()).getFirstParentOfType(ASTConstructorDeclaration.class)) == null) continue;
            initInConstructor = true;
        }
        return initInConstructor;
    }
}

