/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.database;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.xml.transform.URIResolver;
import net.sourceforge.pldoc.PLDoc;
import net.sourceforge.pldoc.Settings;
import net.sourceforge.pldoc.XMLWriter;

public class PLDocParser {
    private Settings settings = new Settings();

    public PLDocParser() {
        this.settings = new Settings();
    }

    public PLDocParser(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void parse(String schemaName, String objectName, String objectType, Clob objectCode, Clob parsedCode) throws Exception {
        PLDoc pldoc = new PLDoc(this.settings);
        XMLWriter xmlWriter = new XMLWriter(parsedCode.setAsciiStream(0L));
        xmlWriter.startDocument();
        Throwable throwable = pldoc.processPackage(new BufferedReader(objectCode.getCharacterStream()), xmlWriter, objectName, schemaName, "PUBLIC");
        xmlWriter.endDocument();
        if (null != throwable) {
            throw new Exception("Could not parse code for " + objectType + ": " + schemaName + "." + objectName, throwable);
        }
    }

    public static URIResolver getResourceResolver() {
        return PLDoc.getResourceResolver();
    }

    public static InputStream getResourceStream(String path) throws IOException {
        return PLDoc.getResourceStream(path);
    }

    public static void setResource(String path, Clob resourceClob) throws IOException, SQLException {
        Writer output = resourceClob.setCharacterStream(1L);
        PLDocParser.copy(PLDoc.getResourceStream(path), output);
    }

    public static Clob getResource(String path, Clob resourceClob) throws IOException, SQLException {
        PLDocParser.setResource(path, resourceClob);
        return resourceClob;
    }

    public static void main(String[] args) throws Exception {
        String dbURL = "jdbc:oracle:thin:@192.168.100.22:1521:orcl";
        String dbUser = "SYSTEM";
        String dbPassword = "oracle";
        Connection conn = null;
        String schemaName = "PLDOC";
        String objectName = "TIMESTAMP_TEST";
        String objectType = "PACKAGE_SPEC";
        Clob objectCode = null;
        Clob parsedCode = null;
        String generateOutputXML = "BEGIN ? := new XMLType('<dummy></dummy>');  END;";
        String generateOutputCLOB = "BEGIN DBMS_LOB.createTemporary(?,TRUE) ; END;";
        String generateInputCLOB = "BEGIN :1 := 'create or replace\npackage       timestamp_test is\n\nTYPE VARYING_ARRAY IS VARYING ARRAY(10) OF INTEGER;\nTYPE REF_CURSOR IS REF CURSOR;\n\nprocedure some_procedure(\ntime_var timestamp with time zone,\n  long_raw_var long raw,\n  varying_array_var VARYING_ARRAY,\ndouble_prec_var DOUBLE PRECISION,\n  int_day_2_second_var INTERVAL DAY TO SECOND,\n  int_y_2_m_var INTERVAL YEAR TO MONTH,\n  time_local_var TIMESTAMP WITH LOCAL TIME ZONE,\n  ref_cursor_var REF_CURSOR\n);\n\nend;' ; END;";
        String inputCLOB = "create or replace\npackage       timestamp_test is\n\nTYPE VARYING_ARRAY IS VARYING ARRAY(10) OF INTEGER;\nTYPE REF_CURSOR IS REF CURSOR;\n\nprocedure some_procedure(\ntime_var timestamp with time zone,\n  long_raw_var long raw,\n  varying_array_var VARYING_ARRAY,\ndouble_prec_var DOUBLE PRECISION,\n  int_day_2_second_var INTERVAL DAY TO SECOND,\n  int_y_2_m_var INTERVAL YEAR TO MONTH,\n  time_local_var TIMESTAMP WITH LOCAL TIME ZONE,\n  ref_cursor_var REF_CURSOR\n);\n\nend;";
        long startTime = System.currentTimeMillis();
        System.out.println("");
        System.out.println("TEST");
        Settings settings = new Settings();
        settings.processCommandString(args);
        PLDocParser parser = new PLDocParser(settings);
        Class.forName(settings.getDriverName());
        conn = DriverManager.getConnection(settings.getDbUrl(), settings.getDbUser(), settings.getDbPassword());
        objectCode = conn.createClob();
        int added = objectCode.setString(1L, inputCLOB);
        System.out.println("Added (" + added + " chracters to the Input ClOB seconds).");
        parsedCode = conn.createClob();
        try {
            parser.parse(schemaName, objectName, objectType, objectCode, parsedCode);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        long finishTime = System.currentTimeMillis();
        System.out.println("Done (" + (double)(finishTime - startTime) / 1000.0 + " seconds).");
        System.out.println("INPUTCLOB :");
        int copied = PLDocParser.copy(objectCode.getCharacterStream(), (OutputStream)System.out);
        System.out.println("\n");
        System.out.println("Copied " + copied + " characters");
        System.out.println("PARSEDCLOB ");
        copied = PLDocParser.copy(parsedCode.getCharacterStream(), (OutputStream)System.out);
        System.out.println("\n");
        System.out.println("Copied " + copied + " characters");
        objectCode.free();
        parsedCode.free();
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[100];
        int totalWritten = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            totalWritten += n;
        }
        output.flush();
        return totalWritten;
    }

    public static int copy(Reader input, OutputStream output) throws IOException {
        char[] buffer = new char[100];
        int totalWritten = 0;
        int n = 0;
        OutputStreamWriter out = new OutputStreamWriter(output);
        while (-1 != (n = input.read(buffer))) {
            out.write(buffer, 0, n);
            totalWritten += n;
        }
        out.flush();
        return totalWritten;
    }

    public static int copy(InputStream input, Writer output) throws IOException {
        char[] buffer = new char[100];
        int totalWritten = 0;
        int n = 0;
        InputStreamReader in = new InputStreamReader(input);
        while (-1 != (n = in.read(buffer))) {
            output.write(buffer, 0, n);
            totalWritten += n;
        }
        output.flush();
        return totalWritten;
    }

    public static int copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[100];
        int totalWritten = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            totalWritten += n;
        }
        output.flush();
        return totalWritten;
    }

    public static Object getDBObject(Connection connection, int returnType, String sqlStatement) throws SQLException {
        CallableStatement adHocStatement = null;
        adHocStatement = connection.prepareCall(sqlStatement);
        adHocStatement.registerOutParameter(1, returnType);
        adHocStatement.executeUpdate();
        Object result = adHocStatement.getObject(1);
        return result;
    }
}

