/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.cpd.mojo;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sourceforge.pldoc.cpd.ant.PLDocCPDTask;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public class CPD
extends AbstractMojo
implements MavenReport {
    private String applicationTitle;
    private String destDir;
    protected File outputDirectory;
    private File reportOutputDirectory;
    private File sourceDirectory;
    private String includes;
    private String inputEncoding = System.getProperty("file.encoding");
    private String namesCase = "default";
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private String inputTypes;
    private String inputObjects;
    private boolean showSkippedPackages;
    private String driverName;
    private String getMetadataStatement;
    private Integer getMetadataStatementReturnType;
    private boolean ignoreComments;
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;
    private String language;
    private String format;
    private Integer minimumTokens;
    private MavenProject project;
    private String name;
    private String description;

    public void execute() throws MojoExecutionException {
        try {
            Sink sink = null;
            Locale locale = Locale.getDefault();
            this.generate(sink, locale);
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", ex);
        }
        catch (RuntimeException ex) {
            throw new MojoExecutionException("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", ex);
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.outputDirectory = this.getReportOutputDirectory();
        this.getLog().debug("outputDirectory=" + this.outputDirectory);
        this.getLog().debug("destDir=" + this.destDir);
        this.getLog().debug("reportOutputDirectory=" + this.reportOutputDirectory);
        this.getLog().debug("sourceDirectory=" + this.sourceDirectory);
        this.getLog().debug("includes=" + this.includes);
        this.getLog().debug("inputEncoding=" + this.inputEncoding);
        this.getLog().debug("namesCase=" + this.namesCase);
        this.getLog().debug("dbUrl=" + this.dbUrl);
        this.getLog().debug("dbUser=" + this.dbUser);
        this.getLog().debug("dbPassword=" + (null == this.dbPassword ? "undefined" : "defined"));
        this.getLog().debug("inputObjects=" + this.inputObjects);
        this.getLog().debug("inputTypes=" + this.inputTypes);
        this.getLog().debug("showSkippedPackages=" + this.showSkippedPackages);
        this.getLog().debug("ignoreComments=" + this.ignoreComments);
        this.getLog().debug("ignoreIdentifiers=" + this.ignoreIdentifiers);
        this.getLog().debug("ignoreLiterals=" + this.ignoreLiterals);
        this.getLog().debug("language=" + this.language);
        this.getLog().debug("format=" + this.format);
        this.getLog().debug("minimumTokens=" + this.minimumTokens);
        this.getLog().debug("driverName=" + this.driverName);
        this.getLog().debug("getMetadataStatement=" + this.getMetadataStatement);
        this.getLog().debug("getMetadataStatementReturnType=" + this.getMetadataStatementReturnType);
        try {
            if (!this.outputDirectory.exists()) {
                this.getLog().info("Creating directory " + this.outputDirectory.toString());
                this.outputDirectory.mkdirs();
            }
            PLDocCPDTask task = new PLDocCPDTask();
            task.init();
            task.setDestdir(this.outputDirectory);
            task.setDbUrl(this.dbUrl);
            task.setDbUser(this.dbUser);
            task.setDbPassword(this.dbPassword);
            task.setInputObjects(this.inputObjects);
            task.setInputTypes(this.inputTypes);
            task.setInputEncoding(this.inputEncoding);
            task.setShowSkippedPackages(this.showSkippedPackages);
            task.setIgnoreComments(this.ignoreComments);
            task.setIgnoreIdentifiers(this.ignoreIdentifiers);
            task.setIgnoreLiterals(this.ignoreLiterals);
            task.setLanguage(this.language);
            task.setFormat(this.format);
            task.setMinimumTokens(this.minimumTokens);
            if (null != this.driverName) {
                task.setDriverName(this.driverName);
            }
            if (null != this.getMetadataStatement) {
                task.setGetMetadataStatement(this.getMetadataStatement);
            }
            if (null != this.getMetadataStatementReturnType) {
                task.setReturnType(this.getMetadataStatementReturnType);
            }
            if (null != this.sourceDirectory && null != this.includes) {
                FileSet fset = new FileSet();
                fset.setDir(this.sourceDirectory);
                fset.setIncludes(this.includes);
                task.addFileset(fset);
            }
            Project proj = new Project();
            proj.setBaseDir(this.outputDirectory);
            proj.setName(this.applicationTitle);
            task.setProject(proj);
            task.execute();
        }
        catch (BuildException ex) {
            throw new MavenReportException("Failed generating pldoc report", ex);
        }
        catch (RuntimeException ex) {
            throw new MavenReportException("Failed generating pldoc report", ex);
        }
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty(this.name)) {
            return this.getBundle(locale).getString("report.pldoc.name");
        }
        return this.name;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty(this.description)) {
            return this.getBundle(locale).getString("report.pldoc.description");
        }
        return this.description;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
        this.getLog().debug("setDestDir: param destDir=" + destDir);
        this.getLog().debug("setDestDir: outputDirectory=" + this.outputDirectory);
        this.getLog().debug("setDestDir: destDir=" + this.destDir);
        this.getLog().debug("setDestDir: reportOutputDirectory=" + this.reportOutputDirectory);
        this.updateReportOutputDirectory(this.reportOutputDirectory, destDir);
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.getLog().debug("setReportOutPutDirectory: param reportOutputDirectory=" + reportOutputDirectory);
        this.getLog().debug("setReportOutPutDirectory: outputDirectory=" + this.outputDirectory);
        this.getLog().debug("setReportOutPutDirectory: destDir=" + this.destDir);
        this.getLog().debug("setReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory);
        this.updateReportOutputDirectory(reportOutputDirectory, this.destDir);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory, String destDir) {
        this.reportOutputDirectory = reportOutputDirectory != null && destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(destDir) ? new File(reportOutputDirectory, destDir) : reportOutputDirectory;
        this.getLog().debug("updateReportOutPutDirectory: reportOutputDirectory=" + this.reportOutputDirectory);
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        return true;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("pldoc-report", locale, this.getClass().getClassLoader());
    }
}

