/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.cpd.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.sourceforge.pldoc.cpd.CPD;
import net.sourceforge.pldoc.cpd.Settings;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class PLDocCPDTask
extends Task {
    private Path classpath;
    private Path auxClasspath;
    private AntClassLoader antClassLoader;
    private Settings settings;
    private boolean m_verbose = false;
    private File m_destdir = null;
    private String m_doctitle = null;
    private File m_outputFile = null;
    private ArrayList m_filesets = new ArrayList();
    private File m_stylesheet = null;
    private File m_sourcestylesheet = null;
    private char m_namesCase = (char)68;
    private String m_inEnc = null;
    private boolean m_exitOnError = false;
    private String m_dbUrl = null;
    private String m_dbUser = null;
    private String m_dbPassword = null;
    private String m_inputTypes = null;
    private String m_inputObjects = null;
    private String m_language = "plsql";
    private String m_format = "text";
    private boolean m_ignoreComments = false;
    private boolean m_ignoreIdentifiers = false;
    private boolean m_ignoreLiterals = false;
    private Integer m_minimumTokens = 50;
    private boolean m_showSkippedPackages = false;
    private boolean m_saveSourceCode = false;
    private String m_driverName = null;
    private String m_getMetadataStatement = null;
    private Integer m_getMetadataStatementReturnType = null;

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setAuxClasspath(Path auxClasspath) {
        this.auxClasspath = auxClasspath;
    }

    public Path getAuxClasspath() {
        return this.auxClasspath;
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createAuxClasspath().setRefid(r);
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setDestdir(File dir) {
        this.m_destdir = dir;
    }

    public void setDoctitle(String doctitle) {
        this.m_doctitle = doctitle;
    }

    public void setOutputFile(File file) {
        this.m_outputFile = file;
    }

    public void addFileset(FileSet fset) {
        this.m_filesets.add(fset);
    }

    public void setStylesheet(File file) {
        this.m_stylesheet = file;
    }

    public void setSourceStylesheet(File file) {
        this.m_sourcestylesheet = file;
    }

    public void setInputEncoding(String enc) {
        this.m_inEnc = enc;
    }

    public void setExitOnError(boolean exitOnError) {
        this.m_exitOnError = exitOnError;
    }

    public void setDbUrl(String dbUrl) {
        this.m_dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.m_dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.m_dbPassword = dbPassword;
    }

    public void setInputObjects(String inputObjects) {
        this.m_inputObjects = inputObjects;
    }

    public void setInputTypes(String inputTypes) {
        this.m_inputTypes = inputTypes;
    }

    public void setShowSkippedPackages(boolean showSkippedPackages) {
        this.m_showSkippedPackages = showSkippedPackages;
    }

    public void setSaveSourceCode(boolean saveSourceCode) {
        this.m_saveSourceCode = saveSourceCode;
    }

    public void setLanguage(String language) {
        this.m_language = language;
    }

    public void setFormat(String format) {
        this.m_format = format;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.m_ignoreComments = ignoreComments;
    }

    public void setIgnoreIdentifiers(boolean ignoreIdentifiers) {
        this.m_ignoreIdentifiers = ignoreIdentifiers;
    }

    public void setIgnoreLiterals(boolean ignoreLiterals) {
        this.m_ignoreLiterals = ignoreLiterals;
    }

    public void setMinimumTokens(Integer minimumTokens) {
        this.m_minimumTokens = minimumTokens;
    }

    public void setDriverName(String driverName) {
        this.m_driverName = driverName;
    }

    public void setGetMetadataStatement(String getMetadataStatement) {
        this.m_getMetadataStatement = getMetadataStatement;
    }

    public void setReturnType(Integer getMetadataStatementReturnType) {
        this.m_getMetadataStatementReturnType = getMetadataStatementReturnType;
    }

    public void execute() throws BuildException {
        if (this.m_destdir == null) {
            throw new BuildException("Property \"destdir\" (destination directory) MUST be specified");
        }
        if (this.m_doctitle == null) {
            this.m_doctitle = "PL/SQL";
        }
        if (this.m_inEnc == null) {
            this.m_inEnc = System.getProperty("file.encoding");
        }
        try {
            this.settings = new Settings();
            this.settings.setOutputDirectory(this.m_destdir);
            this.settings.setInputEncoding(this.m_inEnc);
            this.settings.setExitOnError(this.m_exitOnError);
            this.settings.setDbUrl(this.m_dbUrl);
            this.settings.setDbUser(this.m_dbUser);
            this.settings.setDbPassword(this.m_dbPassword);
            this.settings.setInputTypes(null == this.m_inputTypes ? new ArrayList() : Arrays.asList(this.m_inputTypes.split(",")));
            this.settings.setInputObjects(null == this.m_inputObjects ? new ArrayList() : Arrays.asList(this.m_inputObjects.split(",")));
            this.settings.setShowSkippedPackages(this.m_showSkippedPackages);
            this.settings.setSaveSourceCode(this.m_saveSourceCode);
            this.settings.setLanguage(this.m_language);
            this.settings.setFormat(this.m_format);
            this.settings.setIgnoreComments(this.m_ignoreComments);
            this.settings.setIgnoreIdentifiers(this.m_ignoreIdentifiers);
            this.settings.setIgnoreLiterals(this.m_ignoreLiterals);
            this.settings.setMinimumTileSize(this.m_minimumTokens);
            this.settings.setLanguage(this.m_language);
            this.settings.setFormat(this.m_format);
            this.settings.setOutputFile(this.m_outputFile);
            this.settings.setStylesheet(this.m_stylesheet);
            this.settings.setSourceStylesheet(this.m_sourcestylesheet);
            if (null != this.m_driverName) {
                this.settings.setDriverName(this.m_driverName);
            }
            if (null != this.m_getMetadataStatement) {
                this.settings.setGetMetadataStatement(this.m_getMetadataStatement);
            }
            if (null != this.m_getMetadataStatementReturnType) {
                this.settings.setReturnType(this.m_getMetadataStatementReturnType);
            }
            ArrayList<String> inputPaths = new ArrayList<String>();
            for (int fsetI = 0; fsetI < this.m_filesets.size(); ++fsetI) {
                FileSet fset = (FileSet)this.m_filesets.get(fsetI);
                DirectoryScanner dirScan = fset.getDirectoryScanner(this.getProject());
                File srcDir = fset.getDir(this.getProject());
                String[] srcFiles = dirScan.getIncludedFiles();
                for (int fileI = 0; fileI < srcFiles.length; ++fileI) {
                    File inputFile = new File(srcDir, srcFiles[fileI]);
                    inputPaths.add(inputFile.getCanonicalPath());
                }
            }
            this.settings.setInputFiles(inputPaths);
            inputPaths = null;
            Collection inputFiles = this.settings.getInputFiles();
            Collection inputTypes = this.settings.getInputTypes();
            Collection inputObjects = this.settings.getInputObjects();
            if (inputFiles.isEmpty() && inputObjects.isEmpty() || !inputFiles.isEmpty() && !inputObjects.isEmpty()) {
                throw new BuildException("You must specify input file name(s) or object name(s)!");
            }
            if (!(inputObjects.isEmpty() || this.settings.getDbUrl() != null && this.settings.getDbUser() != null && this.settings.getDbPassword() != null)) {
                throw new BuildException("Database url, db schema and db password are mandatory when object name(s) are supplied!");
            }
            CPD cpd = new CPD(this.settings);
            try {
                cpd.run();
                cpd.go();
                if (cpd.getMatches().hasNext()) {
                    File outputFile = this.settings.getOutputFile();
                    PrintStream outputStream = System.out;
                    if (null != outputFile) {
                        System.err.println("Outputting CPD to " + outputFile.getAbsolutePath());
                        outputStream = new PrintStream(new FileOutputStream(outputFile));
                    }
                    outputStream.println(this.settings.renderer().render(cpd.getMatches()));
                    File stylesheet = this.settings.getStylesheet();
                    if (null != outputFile && "xml".equalsIgnoreCase(this.settings.getFormatString())) {
                        System.err.println("Generating CPD HTML from " + outputFile.getAbsolutePath());
                        this.settings.generateHtml(outputFile);
                    }
                }
            }
            catch (Exception e) {
                throw new BuildException(e);
            }
        }
        catch (IOException ioEx) {
            throw new BuildException(ioEx);
        }
        catch (Exception otherEx) {
            throw new BuildException(otherEx);
        }
        this.m_verbose = false;
        this.m_destdir = null;
        this.m_stylesheet = null;
        this.m_inEnc = null;
        this.m_dbUrl = null;
        this.m_dbUser = null;
        this.m_dbPassword = null;
        this.m_inputTypes = null;
        this.m_inputObjects = null;
        this.m_showSkippedPackages = false;
        this.m_saveSourceCode = false;
        this.m_ignoreComments = false;
        this.m_ignoreIdentifiers = false;
        this.m_ignoreLiterals = false;
        this.m_language = "plsql";
        this.m_format = "text";
        this.m_minimumTokens = 50;
        this.m_outputFile = null;
        this.m_stylesheet = null;
        this.m_sourcestylesheet = null;
    }

    private BufferedReader getInputReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.m_inEnc));
    }

    private void setupClassLoader() {
        if (this.classpath == null) {
            this.log("Using the normal ClassLoader", 3);
        } else {
            this.log("Using the AntClassLoader", 3);
            this.antClassLoader = new AntClassLoader(this.getProject(), this.classpath);
        }
    }
}

