/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import net.sourceforge.pldoc.ResourceLoader;
import net.sourceforge.pldoc.SubstitutionReader;

public class Utils {
    public static void CopyFile(File inputFile, File outputFile, String resourceName) throws FileNotFoundException, IOException {
        try {
            Utils.CopyStreamToFile(null != inputFile && inputFile.exists() ? new FileInputStream(inputFile) : new ResourceLoader().getResourceStream(resourceName), outputFile);
        }
        catch (IOException e) {
            throw new IOException(String.format("Problem copying File \"%s\" with fallback resource \"%s\" to \"%s\"", inputFile, resourceName, outputFile), e);
        }
    }

    public static void CopyFile(File inputFile, File outputFile) throws FileNotFoundException, IOException {
        int c;
        FileReader in = new FileReader(inputFile);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void CopyStreamToFile(InputStream inputStream, File outputFile) throws FileNotFoundException, IOException {
        int c;
        InputStreamReader in = new InputStreamReader(inputStream);
        FileWriter out = new FileWriter(outputFile);
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        in.close();
        out.close();
    }

    public static void CopyReaderToFile(Reader reader, File outputFile) throws FileNotFoundException, IOException {
        int c;
        FileWriter out = new FileWriter(outputFile);
        while ((c = reader.read()) != -1) {
            out.write(c);
        }
        reader.close();
        out.close();
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        byte[] inputBuffer = new byte[1024];
        StringBuffer stringBuffer = new StringBuffer(1024);
        while (inputStream.available() > 0) {
            int bytesRead = inputStream.read(inputBuffer);
            stringBuffer.append(new String(inputBuffer, 0, bytesRead));
        }
        return stringBuffer.toString();
    }

    public static void copyStaticSourceDirectoryFiles(File outputDirectory, String relativePath) throws Exception {
        try {
            Properties replacementProperties = new Properties();
            replacementProperties.put("sourcestylesheet.css", relativePath + "sourcestylesheet.css");
            Utils.CopyReaderToFile(new BufferedReader(new SubstitutionReader(new BufferedReader(new InputStreamReader(new ResourceLoader().getResourceStream("sourcecode.xsl"))), replacementProperties)), new File(outputDirectory.getPath() + File.separator + "sourcecode.xsl"));
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found. ");
            e.printStackTrace();
            throw e;
        }
    }

    public static void copyStaticRootDirectoryFiles(File outputDirectory, File stylesheet, File sourceStylesheet) throws Exception {
        Utils.CopyFile(stylesheet, new File(outputDirectory, "stylesheet.css"), "defaultstylesheet.css");
        Utils.CopyFile(stylesheet, new File(outputDirectory, "sourcestylesheet.css"), "defaultstylesheet.css");
    }
}

