/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CommentParser {
    public static final char PARAM_CHAR = '@';
    private ArrayList inputLines;
    private String mainSentence;
    private String text;
    private Hashtable tags;
    private String packageComment;

    public CommentParser(String input) {
        this.inputLines = this.breakIntoLines(input);
        this.removeCommentChars();
        this.removeBlankLines();
        this.text = this.extractText();
        this.mainSentence = this.extractMainSentence();
        this.tags = this.extractTags();
        this.packageComment = this.extractPackageComment();
    }

    private ArrayList breakIntoLines(String s) {
        ArrayList<String> lines = new ArrayList<String>();
        int newlinepos = 0;
        int prevpos = 0;
        while ((newlinepos = s.indexOf("\n", prevpos)) != -1) {
            if (newlinepos == prevpos) {
                lines.add("");
            } else if (s.charAt(newlinepos - 1) == '\r') {
                lines.add(s.substring(prevpos, newlinepos - 1));
            } else {
                lines.add(s.substring(prevpos, newlinepos));
            }
            prevpos = newlinepos + 1;
        }
        lines.add(s.substring(prevpos));
        return lines;
    }

    private void removeCommentChars() {
        boolean insideCode = false;
        for (int i = 0; i < this.inputLines.size(); ++i) {
            String line = ((String)this.inputLines.get(i)).trim();
            if (line == null) continue;
            if (!insideCode) {
                if ((line = line.trim()).startsWith("--")) {
                    line = line.substring(2).trim();
                } else if (line.startsWith("/**")) {
                    line = line.substring(3);
                } else if (line.startsWith("/*")) {
                    line = line.substring(2);
                }
                if (line.endsWith("*/")) {
                    line = line.substring(0, line.length() - 2);
                }
            }
            if (line.trim().startsWith("*")) {
                line = line.substring(line.indexOf(42) + 1);
            }
            if (line.indexOf("<pre>") != -1) {
                insideCode = true;
            }
            if (line.indexOf("</pre>") != -1) {
                insideCode = false;
            }
            this.inputLines.set(i, line);
        }
    }

    private void removeBlankLines() {
        boolean insideCode = false;
        for (int i = 0; i < this.inputLines.size(); ++i) {
            String line = (String)this.inputLines.get(i);
            if (!(insideCode || line != null && line.trim().length() != 0)) {
                this.inputLines.remove(i);
            }
            if (line.indexOf("<pre>") != -1) {
                insideCode = true;
            }
            if (line.indexOf("</pre>") == -1) continue;
            insideCode = false;
        }
    }

    private String extractText() {
        String line;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.inputLines.size() && (line = (String)this.inputLines.get(i)).trim().indexOf(64) != 0; ++i) {
            buf.append(line).append('\n');
            this.inputLines.remove(i);
            --i;
        }
        return buf.toString();
    }

    private String extractMainSentence() {
        String s = this.text;
        int pos = s.indexOf(46);
        while (pos != -1 && pos != s.length() - 1) {
            if (pos != s.length() - 1 && Character.isWhitespace(s.charAt(pos + 1))) {
                s = s.substring(0, pos + 1);
                break;
            }
            pos = s.indexOf(46, pos + 1);
        }
        return s;
    }

    private Hashtable extractTags() {
        String line;
        int i;
        Hashtable<String, ArrayList> htOuter = new Hashtable<String, ArrayList>();
        for (i = 0; i < this.inputLines.size(); ++i) {
            line = (String)this.inputLines.get(i);
            if (line.trim().indexOf(64) == 0 || i <= 0) continue;
            String previousLine = (String)this.inputLines.get(i - 1);
            this.inputLines.set(i - 1, previousLine + "\n" + line);
            this.inputLines.remove(i);
            --i;
        }
        for (i = 0; i < this.inputLines.size(); ++i) {
            line = (String)this.inputLines.get(i);
            if (line.trim().indexOf(64) != 0) continue;
            String tag = null;
            StringTokenizer st = new StringTokenizer(line);
            if (st.hasMoreTokens()) {
                tag = st.nextToken();
            }
            if (tag == null) continue;
            int restStart = line.indexOf(tag) + tag.length() + 1;
            String tagValue = restStart < line.length() ? line.substring(restStart).trim() : "";
            ArrayList values = htOuter.containsKey(tag) ? (ArrayList)htOuter.get(tag) : new ArrayList();
            values.add(tagValue);
            htOuter.put(tag, values);
        }
        return htOuter;
    }

    private String extractPackageComment() {
        String packageComment = null;
        if (this.tags != null && this.tags.containsKey("@headcom")) {
            packageComment = this.text;
            this.text = null;
            this.mainSentence = null;
        }
        return packageComment;
    }

    public String getPackageComment() {
        return this.packageComment;
    }

    public String getMainSentence() {
        return this.mainSentence;
    }

    public String getText() {
        return this.text;
    }

    public Hashtable getTags() {
        return this.tags;
    }

    public String toString() {
        return this.inputLines.toString();
    }

    public static void main(String[] args) {
        String[] tests = new String[]{"--  xyz\n--  abcdef\n--qwerty", "/* abcde\ngde\nqwerty opi\n*/", "/**\n  *  abcdef\n  *  qwerty.\n  * @param x xyz\n  * @param y werty\n  * @return error code\n*/", "/**@headcom\n* Gets defaults of an advice type (for given sector).\n* @param p_sector           business sector\n* @param p_dir              direction (IN/OUT)\n* @param p_type             advice type code\n* @param def_medium         default medium\n* @param def_medium_option  default medium option\n* @param def_party          default party\n* @param party_fixed        party is fixed (TRUE/FALSE)\n* @param r_result           return code, 0=ok\n* @param r_message          return message\n* %throws e_InvalidOrder Raised when the value of p_order is invalid.\n* %author Anybody\n* %see org.utils\n* %version 1.0\n*/"};
        CommentParser commentParser = null;
        String mainSentence = null;
        String text = null;
        String packageComment = null;
        Hashtable tags = null;
        long start = System.currentTimeMillis();
        for (int i = 0; i < tests.length; ++i) {
            for (int c = 0; c < 10000; ++c) {
                commentParser = new CommentParser(tests[i]);
                mainSentence = commentParser.getMainSentence();
                text = commentParser.getText();
                packageComment = commentParser.getPackageComment();
                tags = commentParser.getTags();
                commentParser = null;
            }
            System.out.println(commentParser);
            System.out.println(mainSentence);
            System.out.println(text);
            System.out.println(packageComment);
            System.out.println(tags);
        }
        long finish = System.currentTimeMillis();
        System.out.println("Time: " + (double)(finish - start) / 1000.0);
    }
}

