/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.cpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.pldoc.cpd.ResourceLoader;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.PLSQLLanguage;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;

public class Settings {
    private static final String GET_METADATA_STATEMENT_DEFAULT = "BEGIN\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA. SESSION_TRANSFORM,'SQLTERMINATOR',true );\n  :1 := DBMS_METADATA.GET_DDL(\n       :2 ,\n       :3 ,\n       :4 ,\n       :5 ,\n       :6 ,\n       :7 )  \n;\nEND;";
    private static final String DRIVER_NAME_DEFAULT = "oracle.jdbc.OracleDriver";
    public static final String CPD_RENDER_FORMAT_DEFAULT = "text";
    public static final String CPD_LANGUAGE_DEFAULT = "plsql";
    public static final int CPD_MINIMUM_TOKENS_DEFAULT = 50;
    private String applicationName = "MyApplication";
    private File outputDirectory = new File("." + File.separator);
    private File outputFile = null;
    private File stylesheetFile = null;
    private File sourcestylesheetFile = null;
    private Collection inputFiles = new ArrayList();
    private Properties defines = null;
    private String inputEncoding = System.getProperty("file.encoding");
    private boolean exitOnError = false;
    private boolean verbose = false;
    private String driverName = "oracle.jdbc.OracleDriver";
    private String getMetadataStatement = "BEGIN\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'SEGMENT_ATTRIBUTES', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM, 'CONSTRAINTS', FALSE);\n  DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA. SESSION_TRANSFORM,'SQLTERMINATOR',true );\n  :1 := DBMS_METADATA.GET_DDL(\n       :2 ,\n       :3 ,\n       :4 ,\n       :5 ,\n       :6 ,\n       :7 )  \n;\nEND;";
    private int returnType = 2005;
    private String dbUrl = null;
    private String dbUser = null;
    private String dbPassword = null;
    private Collection inputTypes = new ArrayList();
    private Collection inputObjects = new ArrayList();
    private boolean showSkippedPackages = false;
    private boolean savesourcecode = false;
    private String formatString = "text";
    private String languageString = "plsql";
    private int minimumTileSize = 50;
    private boolean skipDuplicates = false;
    private boolean ignoreComments = false;
    private boolean ignoreIdentifiers = false;
    private boolean ignoreLiterals = false;
    private Renderer renderer;
    private Language language;
    private static final String usage = "Arguments: [options] inputfile(s)\n-verbose                  Verbose - report each object processed \n-language <language>      Language expected in the source code [default: plsql ]\n-format <format>          Output format [default: text ]\n-ignorecomments           Ignore comments in code\n-ignoreidentifiers        Ignore identifiers (variable names etc.) in code\n-ignoreliterals           Ignore literals (constant values, strings etc.) in code\n-minimumTokens            Minimum number of sequential tokens before declaring a match [default: 50 ]\n-skipduplicates           Ignore duplicated files\n-savesourcecode           Save read source code to file system\n-inputencoding <enc>      Encoding used in the input files [default: operation system default encoding]\n-outputfile <name>        output file name [default: standard output ] \n-stylesheetfile <name>    stylesheet name (when <format> is xml) \n-sourcestylesheetfile <name>    stylesheet name (when <format> is xml) \n-exitonerror              Force program to exit when some input file cannot be processed\n                          [by default, the file is skipped and processing continues]\n-driver <JDBC class>      Name of JDBC driver class, for example oracle.jdbc.OracleDriver, com.edb.Driver, or org.postgresql.Driver [default: oracle.jdbc.OracleDriver].\n-getmetadata <String>     SQL 92 CallableStatement Statement that retrieves the object source (EnterpriseDB does not support Oracle BEGIN .. END statements) [default: Oracle DBMS_METADATA anonymous block ].\n                          \tStatement structure is (\"call\" and function are case sensitive} \"{ ? = call GET_SOURCE( ? ,  ? ,  ? ,  ? , ? , ? ) }\"  where GET_SOURCE(...) mimics \n                          \t\"{ <RESULT_SET> =  call DBMS_METADATA.GET_DDL( <object_type> ,  <object_name> ,  <schema_name> ,  'COMPATIBLE' , 'ORACLE' , 'DDL' ) }\" \n-returntype <java.sql.Types.?>  number corresponding to java.sql.Types.CLOB (2005) or java.sql.Types.VARCHAR (12) [default: java.sql.Types.CLOB].\n-url <database url>       Database URL, for example jdbc:oracle:thin:@HOST:PORT:SID, jdbc:oracle:thin:@HOST:PORT/SERVICE, jdbc:edb://HOST:PORT/DATABASE,\n                          or jdbc:postgresql://HOST:PORT/DATABASE [default: none].\n                          Required when generating from the Oracle dictionary.\n-user <db schema>         Schema name.\n                          Required when generating from the Oracle dictionary. The user name is\n                          case sensitive since Oracle stores user/schema names like \"My schema\" (name wit \n                          double quotes) as 'My schema' in the dictionary. Ordinary schema names\n                          like scott are stored as 'SCOTT' (upper case).\n-password <db password>   Password of the logon user.\n                          Required when generating from the Oracle dictionary.\n-types <object type(s)>   Comma separated list of object type(s) to generate documentation for.\n                          Defaults to all procedural types (PACKAGES, TYPES, FUNCTIONS PROCEDURES).\n-sql <object name(s)>     Comma separated list of object name(s) to generate documentation for.\n                          Required when generating from the Oracle dictionary.\n                          An object name is case sensitive (the same rules as described for schema\n                          names apply).\n                          An object name may be prepended by a schema name and may have SQL\n                          wildcards.\n                          When the object belongs to a different schema than the logon user (as specified by\n                          the -user parameter), the logon user must have been granted the SELECT_CATALOG_ROLE role or the SELECT ANY DICTIONARY system privilege.\n-showSkippedPackages      Show the skipped packages in the summary of the documentation (generator.html).\n";

    public void processCommandString(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println(usage);
            System.exit(0);
        }
        ArrayList<String> argumentList = new ArrayList<String>();
        StringBuffer arguments = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                arguments.append(' ');
            }
            arguments.append(args[i]);
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(arguments.toString()));
        st.resetSyntax();
        st.whitespaceChars(9, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
        st.quoteChar(39);
        while (st.nextToken() != -1) {
            switch (st.ttype) {
                case -3: 
                case 34: 
                case 39: {
                    argumentList.add(st.sval);
                }
            }
        }
        Iterator it = argumentList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equalsIgnoreCase("-ignorecomments")) {
                this.ignoreComments = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-ignoreidentifiers")) {
                this.ignoreIdentifiers = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-ignoreliterals")) {
                this.ignoreLiterals = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-skipduplicates")) {
                this.skipDuplicates = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-language")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.languageString = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-format")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.formatString = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-minimumtokens")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.minimumTileSize = Integer.parseInt((String)it.next());
                continue;
            }
            if (arg.equalsIgnoreCase("-inputencoding")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.inputEncoding = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-exitonerror")) {
                this.exitOnError = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-returntype")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.returnType = Integer.parseInt((String)it.next());
                continue;
            }
            if (arg.equalsIgnoreCase("-driver")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.driverName = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-getmetadata")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.getMetadataStatement = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-url")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbUrl = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-user")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbUser = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-password")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.dbPassword = (String)it.next();
                continue;
            }
            if (arg.equalsIgnoreCase("-sql")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                String inputObjectsList = (String)it.next();
                this.inputObjects = Arrays.asList(inputObjectsList.split(","));
                continue;
            }
            if (arg.equalsIgnoreCase("-types")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                String inputTypesList = (String)it.next();
                this.inputTypes = Arrays.asList(inputTypesList.split(","));
                continue;
            }
            if (arg.equalsIgnoreCase("-showskippedpackages")) {
                this.showSkippedPackages = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-savesourcecode")) {
                this.savesourcecode = true;
                continue;
            }
            if (arg.equalsIgnoreCase("-stylesheetfile")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.stylesheetFile = new File((String)it.next());
                if (this.stylesheetFile.exists()) continue;
                this.processInvalidUsage("The specified stylesheet file " + this.stylesheetFile + " does not exist !");
                continue;
            }
            if (arg.equalsIgnoreCase("-sourcestylesheetfile")) {
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                this.sourcestylesheetFile = new File((String)it.next());
                if (this.sourcestylesheetFile.exists()) continue;
                this.processInvalidUsage("The specified sourcestylesheet file " + this.sourcestylesheetFile + " does not exist !");
                continue;
            }
            if (arg.equalsIgnoreCase("-outputfile")) {
                String outputFileName;
                if (!it.hasNext()) {
                    this.processInvalidUsage("Option " + arg + " requires a value !");
                }
                if (null == (outputFileName = (String)it.next()) || outputFileName.equals("") || outputFileName.equals("-")) continue;
                File thisDirectory = new File(".");
                this.outputFile = new File(outputFileName);
                File fileOutputDirectory = this.outputFile.getParentFile();
                if (null == fileOutputDirectory || fileOutputDirectory.getCanonicalPath().equals(thisDirectory.getCanonicalPath())) {
                    this.outputFile = new File(fileOutputDirectory, outputFileName);
                    continue;
                }
                this.outputDirectory = fileOutputDirectory;
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("WARN - unknown parameter \"" + arg + "\"");
                this.processInvalidUsage("Unknown option " + arg);
                continue;
            }
            this.inputFiles.add(arg);
        }
        if (this.inputFiles.isEmpty() && this.inputObjects.isEmpty() || !this.inputFiles.isEmpty() && !this.inputObjects.isEmpty()) {
            this.processInvalidUsage("Either input file name(s) or object name(s) must be given!");
        }
        if (!(this.inputObjects.isEmpty() || this.dbUrl != null && this.dbUser != null && this.dbPassword != null)) {
            this.processInvalidUsage("Database url, db schema and db password are mandatory when object name(s) are supplied!");
        }
        this.language = new LanguageFactory().createLanguage(this.languageString);
        this.renderer = Settings.getRendererFromString(this.formatString, this.inputEncoding);
        System.setProperty("ignore_comments", this.ignoreComments ? "true" : "false");
        System.setProperty("ignore_identifiers", this.ignoreIdentifiers ? "true" : "false");
        System.setProperty("ignore_literals", this.ignoreLiterals ? "true" : "false");
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setInputFiles(Collection inputFiles) {
        this.inputFiles = inputFiles;
    }

    public void setDefines(Properties defines) {
        this.defines = defines;
    }

    public void setInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setExitOnError(boolean exitOnError) {
        this.exitOnError = exitOnError;
    }

    public void setReturnType(int returnType) {
        this.returnType = returnType;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public void setGetMetadataStatement(String getMetadataStatement) {
        this.getMetadataStatement = getMetadataStatement;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void setInputObjects(Collection inputObjects) {
        this.inputObjects = inputObjects;
    }

    public void setInputTypes(Collection inputTypes) {
        this.inputTypes = inputTypes;
    }

    public void setShowSkippedPackages(boolean showSkippedPackages) {
        this.showSkippedPackages = showSkippedPackages;
    }

    public void setSaveSourceCode(boolean savesourcecode) {
        this.savesourcecode = savesourcecode;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Collection getInputFiles() {
        return this.inputFiles;
    }

    public Properties getDefines() {
        return this.defines;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isExitOnError() {
        return this.exitOnError;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getGetMetadataStatement() {
        return this.getMetadataStatement;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public Collection getInputObjects() {
        return this.inputObjects;
    }

    public Collection getInputTypes() {
        return this.inputTypes;
    }

    public boolean isShowSkippedPackages() {
        return this.showSkippedPackages;
    }

    public boolean isSaveSourceCode() {
        return this.savesourcecode;
    }

    public SourceCode sourceCodeFor(File file) {
        return new SourceCode((SourceCode.CodeLoader)new SourceCode.FileCodeLoader(file, this.getInputEncoding()));
    }

    public Language language() {
        return this.language;
    }

    public int minimumTileSize() {
        return this.minimumTileSize;
    }

    public boolean skipDuplicates() {
        return this.skipDuplicates;
    }

    public void skipDuplicates(boolean flag) {
        this.skipDuplicates = flag;
    }

    public boolean ignoreComments() {
        return this.ignoreComments;
    }

    public void setLanguage(String languageString) {
        this.languageString = languageString;
        this.language = languageString.equalsIgnoreCase(CPD_LANGUAGE_DEFAULT) ? new PLSQLLanguage() : new LanguageFactory().createLanguage(this.languageString);
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setFormat(String formatString) {
        this.formatString = formatString;
        this.renderer = Settings.getRendererFromString(this.formatString, this.inputEncoding);
    }

    public void setFormat(Renderer renderer) {
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setIgnoreComments(boolean flag) {
        this.ignoreComments = flag;
        System.setProperty("ignore_comments", this.ignoreComments ? "true" : "false");
    }

    public boolean ignoreIdentifiers() {
        return this.ignoreIdentifiers;
    }

    public void setIgnoreIdentifiers(boolean flag) {
        this.ignoreIdentifiers = flag;
        System.setProperty("ignore_identifiers", this.ignoreIdentifiers ? "true" : "false");
    }

    public boolean ignoreLiterals() {
        return this.ignoreLiterals;
    }

    public void setIgnoreLiterals(boolean flag) {
        this.ignoreLiterals = flag;
        System.setProperty("ignore_literals", this.ignoreLiterals ? "true" : "false");
    }

    public int getMinimumTileSize() {
        return this.minimumTileSize;
    }

    public void setMinimumTileSize(Integer minimumTileSize) {
        this.minimumTileSize = minimumTileSize;
    }

    public FilenameFilter filenameFilter() {
        return this.language.getFileFilter();
    }

    public Tokenizer tokenizer() {
        return this.language.getTokenizer();
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public static Renderer getRendererFromString(String name, String sourceEncoding) {
        if (name.equalsIgnoreCase(CPD_RENDER_FORMAT_DEFAULT) || name.equals("")) {
            return new SimpleRenderer();
        }
        if ("xml".equals(name)) {
            if (null == sourceEncoding || "".equals(sourceEncoding)) {
                return new XMLRenderer();
            }
            return new XMLRenderer(sourceEncoding);
        }
        if ("csv".equals(name)) {
            return new CSVRenderer();
        }
        if ("vs".equals(name)) {
            return new VSRenderer();
        }
        try {
            return (Renderer)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            System.out.println("Can't find class '" + name + "', defaulting to SimpleRenderer.");
            return new SimpleRenderer();
        }
    }

    public void setOutputFile(String outputFileName) {
        this.outputFile = new File(this.outputDirectory + outputFileName);
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setStylesheet(String stylesheetName) {
        this.stylesheetFile = new File(stylesheetName);
    }

    public void setStylesheet(File stylesheetFile) {
        this.stylesheetFile = stylesheetFile;
    }

    public File getStylesheet() {
        return this.stylesheetFile;
    }

    public void setSourceStylesheet(String sourcestylesheetName) {
        this.sourcestylesheetFile = new File(sourcestylesheetName);
    }

    public void setSourceStylesheet(File sourcestylesheetFile) {
        this.sourcestylesheetFile = sourcestylesheetFile;
    }

    public File getSourceStylesheet() {
        return this.sourcestylesheetFile;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String getLanguageString() {
        return this.languageString;
    }

    public void generateHtml(File outputFile) throws Exception {
        String outputFileName = outputFile.getAbsolutePath();
        String fileExtension = ".XML";
        String outputFileStem = outputFileName.toUpperCase().endsWith(".XML") ? outputFileName.substring(0, outputFileName.length() - ".XML".length()) : outputFileName;
        String htmlFileName = outputFileStem + ".html";
        String xsltFilePath = "xslt/cpdhtml.xsl";
        TransformerFactory tFactory = TransformerFactory.newInstance();
        System.err.println("Generating HTML ...");
        System.err.println("... using xslt/cpdhtml.xsl");
        InputStream inputStream = new ResourceLoader().getResourceStream("xslt/cpdhtml.xsl");
        if (null == inputStream) {
            System.err.println("Could not locate xslt/cpdhtml.xsl");
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(new InputStreamReader(inputStream, this.inputEncoding)));
        System.err.println("Generating CPD HTML from " + outputFileName + " to " + htmlFileName);
        transformer.setParameter("targetFolder", this.getOutputDirectory().getAbsolutePath() + File.separator);
        transformer.transform(new StreamSource(new InputStreamReader((InputStream)new FileInputStream(outputFile), this.inputEncoding)), new StreamResult(new FileOutputStream(htmlFileName)));
    }

    private void processInvalidUsage(String message) {
        System.out.println("Error: " + message);
        System.out.println(usage);
        System.exit(0);
    }
}

