/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import junit.framework.TestCase;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.Reference;

public abstract class AbstractFileSetTest
extends TestCase {
    private Project project;

    public AbstractFileSetTest(String name) {
        super(name);
    }

    public void setUp() {
        this.project = new Project();
        this.project.setBasedir(".");
    }

    protected abstract AbstractFileSet getInstance();

    protected final Project getProject() {
        return this.project;
    }

    public final void testEmptyElementIfIsReference() {
        AbstractFileSet f = this.getInstance();
        f.setIncludes("**/*.java");
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            AbstractFileSetTest.fail("Can add reference to " + f.getDataTypeName() + " with elements from setIncludes");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        f = this.getInstance();
        f.createPatternSet();
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            AbstractFileSetTest.fail("Can add reference to " + f.getDataTypeName() + " with nested patternset element.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
        f = this.getInstance();
        f.createInclude();
        try {
            f.setRefid(new Reference(this.getProject(), "dummyref"));
            AbstractFileSetTest.fail("Can add reference to " + f.getDataTypeName() + " with nested include element.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        f = this.getInstance();
        f.setRefid(new Reference(this.getProject(), "dummyref"));
        try {
            f.setIncludes("**/*.java");
            AbstractFileSetTest.fail("Can set includes in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        try {
            f.setIncludesfile(new File("/a"));
            AbstractFileSetTest.fail("Can set includesfile in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        try {
            f.setExcludes("**/*.java");
            AbstractFileSetTest.fail("Can set excludes in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        try {
            f.setExcludesfile(new File("/a"));
            AbstractFileSetTest.fail("Can set excludesfile in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        try {
            f.setDir(this.project.resolveFile("."));
            AbstractFileSetTest.fail("Can set dir in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify more than one attribute when using refid", be.getMessage());
        }
        try {
            f.createInclude();
            AbstractFileSetTest.fail("Can add nested include in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
        try {
            f.createExclude();
            AbstractFileSetTest.fail("Can add nested exclude in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
        try {
            f.createIncludesFile();
            AbstractFileSetTest.fail("Can add nested includesfile in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
        try {
            f.createExcludesFile();
            AbstractFileSetTest.fail("Can add nested excludesfile in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
        try {
            f.createPatternSet();
            AbstractFileSetTest.fail("Can add nested patternset in " + f.getDataTypeName() + " that is a reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("You must not specify nested elements when using refid", be.getMessage());
        }
    }

    public void testCircularReferenceCheck() {
        AbstractFileSet f = this.getInstance();
        this.project.addReference("dummy", f);
        f.setRefid(new Reference(this.getProject(), "dummy"));
        try {
            f.getDir(this.project);
            AbstractFileSetTest.fail("Can make " + f.getDataTypeName() + " a Reference to itself.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("This data type contains a circular reference.", be.getMessage());
        }
        try {
            f.getDirectoryScanner(this.project);
            AbstractFileSetTest.fail("Can make " + f.getDataTypeName() + " a Reference to itself.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("This data type contains a circular reference.", be.getMessage());
        }
        AbstractFileSet f1 = this.getInstance();
        this.project.addReference("dummy1", f1);
        f1.setRefid(new Reference(this.getProject(), "dummy2"));
        AbstractFileSet f2 = this.getInstance();
        this.project.addReference("dummy2", f2);
        f2.setRefid(new Reference(this.getProject(), "dummy3"));
        AbstractFileSet f3 = this.getInstance();
        this.project.addReference("dummy3", f3);
        f3.setRefid(new Reference(this.getProject(), "dummy1"));
        try {
            f1.getDir(this.project);
            AbstractFileSetTest.fail("Can make circular reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("This data type contains a circular reference.", be.getMessage());
        }
        try {
            f1.getDirectoryScanner(this.project);
            AbstractFileSetTest.fail("Can make circular reference.");
        }
        catch (BuildException be) {
            AbstractFileSetTest.assertEquals("This data type contains a circular reference.", be.getMessage());
        }
        f1 = this.getInstance();
        this.project.addReference("dummy1", f1);
        f1.setRefid(new Reference(this.getProject(), "dummy2"));
        f2 = this.getInstance();
        this.project.addReference("dummy2", f2);
        f2.setRefid(new Reference(this.getProject(), "dummy3"));
        f3 = this.getInstance();
        this.project.addReference("dummy3", f3);
        f3.setDir(this.project.resolveFile("."));
        File dir = f1.getDir(this.project);
        AbstractFileSetTest.assertEquals("Dir is basedir", dir, this.project.getBaseDir());
    }
}

