/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;

public class CHAR
extends Datum {
    public static final CharacterSet DEFAULT_CHARSET = CharacterSet.make(-1);
    private CharacterSet charSet;
    private int oracleId;
    private static final byte[] empty = new byte[0];
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected CHAR() {
    }

    public CHAR(byte[] byArray, CharacterSet characterSet) {
        this.setValue(byArray, characterSet);
    }

    public CHAR(byte[] byArray, int n, int n2, CharacterSet characterSet) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setValue(byArray2, characterSet);
    }

    public CHAR(String string, CharacterSet characterSet) throws SQLException {
        if (characterSet == null) {
            characterSet = DEFAULT_CHARSET;
        }
        this.setValue(characterSet.convert(string), characterSet);
    }

    public CHAR(Object object, CharacterSet characterSet) throws SQLException {
        this(object.toString(), characterSet);
    }

    public CharacterSet getCharacterSet() {
        if (this.charSet == null) {
            if (this.oracleId == 0) {
                this.oracleId = -1;
            }
            this.charSet = DEFAULT_CHARSET != null && (this.oracleId == -1 || this.oracleId == DEFAULT_CHARSET.getOracleId()) ? DEFAULT_CHARSET : CharacterSet.make(this.oracleId);
        }
        return this.charSet;
    }

    public int oracleId() {
        return this.oracleId;
    }

    public String getString() throws SQLException {
        String string = this.getCharacterSet().toString(this.shareBytes(), 0, (int)this.getLength());
        return string;
    }

    public String getStringWithReplacement() {
        byte[] byArray = this.shareBytes();
        String string = this.getCharacterSet().toStringWithReplacement(byArray, 0, byArray.length);
        return string;
    }

    public String toString() {
        return this.getStringWithReplacement();
    }

    public boolean equals(Object object) {
        return object instanceof CHAR && this.getCharacterSet().equals(((CHAR)object).getCharacterSet()) && super.equals(object);
    }

    void setValue(byte[] byArray, CharacterSet characterSet) {
        this.charSet = characterSet == null ? DEFAULT_CHARSET : characterSet;
        this.oracleId = this.charSet.getOracleId();
        this.setShareBytes(byArray == null ? empty : byArray);
    }

    public Object toJdbc() throws SQLException {
        return this.stringValue();
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.lang.String") == 0 || string.compareTo("java.lang.Long") == 0 || string.compareTo("java.math.BigDecimal") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.sql.Date") == 0 || string.compareTo("java.sql.Time") == 0 || string.compareTo("java.sql.Timestamp") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public String stringValue() {
        return this.toString();
    }

    public boolean booleanValue() throws SQLException {
        boolean bl = false;
        String string = this.stringValue();
        bl = string == null ? false : string.length() != 1 || string.charAt(0) != '0';
        return bl;
    }

    public int intValue() throws SQLException {
        long l = this.longValue();
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            DatabaseError.throwSqlException(26);
        }
        int n = (int)l;
        return n;
    }

    public long longValue() throws SQLException {
        long l = 0L;
        try {
            l = Long.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(59);
        }
        return l;
    }

    public float floatValue() throws SQLException {
        float f = 0.0f;
        try {
            f = Float.valueOf(this.stringValue()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(59);
        }
        return f;
    }

    public double doubleValue() throws SQLException {
        double d = 0.0;
        try {
            d = Double.valueOf(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.throwSqlException(59);
        }
        return d;
    }

    public byte byteValue() throws SQLException {
        long l = this.longValue();
        if (l > 127L || l < -128L) {
            DatabaseError.throwSqlException(26);
        }
        byte by = (byte)l;
        return by;
    }

    public Date dateValue() throws SQLException {
        Date date = Date.valueOf(this.stringValue());
        return date;
    }

    public Time timeValue() throws SQLException {
        Time time = Time.valueOf(this.stringValue());
        return time;
    }

    public Timestamp timestampValue() throws SQLException {
        Timestamp timestamp = Timestamp.valueOf(this.stringValue());
        return timestamp;
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(this.stringValue());
        }
        catch (NumberFormatException numberFormatException) {
            DatabaseError.check_error(12, "bigDecimalValue");
        }
        return bigDecimal;
    }

    public Reader characterStreamValue() throws SQLException {
        StringReader stringReader = new StringReader(this.getString());
        return stringReader;
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    public Object makeJdbcArray(int n) {
        return new String[n];
    }
}

