/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3186448715463064573L;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String string, OracleConnection oracleConnection) {
        super(string, oracleConnection);
    }

    public OracleTypeREF(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) {
        super(oracleTypeADT, n, oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        REF rEF = null;
        if (object != null) {
            if (object instanceof REF) {
                rEF = (REF)object;
            } else {
                DatabaseError.check_error(59, object);
            }
        }
        return rEF;
    }

    public int getTypeCode() {
        return 2006;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        switch (n) {
            case 1: {
                if (unpickleContext.is_null(this.null_offset)) {
                    return null;
                }
                unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
                if (n2 == 9) {
                    unpickleContext.skip_bytes(4);
                    return null;
                }
                unpickleContext.markAndSkip();
                byte[] byArray = unpickleContext.read_ptrBytes();
                unpickleContext.reset();
                return this.toObject(byArray, n2, null);
            }
            case 2: {
                if ((unpickleContext.read_byte() & 1) == 1) {
                    unpickleContext.skip_ptrBytes();
                    return null;
                }
            }
            case 3: {
                if (n2 == 9) {
                    unpickleContext.skip_ptrBytes();
                    return null;
                }
                return this.toObject(unpickleContext.read_ptrBytes(), n2, null);
            }
        }
        DatabaseError.throwSqlException(1, "format=" + n);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n == 1 || n == 2) {
            StructDescriptor structDescriptor = this.createStructDescriptor();
            return new REF(structDescriptor, (Connection)this.m_conn, byArray);
        }
        if (n == 3) {
            return byArray;
        }
        DatabaseError.check_error(59, byArray);
        return null;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            if (!this.m_hasName && this.getFullName(false) == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.m_conn);
                this.m_descriptor = new StructDescriptor(oracleTypeADT, (Connection)this.m_conn);
            } else {
                this.m_descriptor = StructDescriptor.createDescriptor(this.m_fullName, this.m_conn);
            }
        }
        return (StructDescriptor)this.m_descriptor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

