/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBINARY_DOUBLE;
import oracle.jdbc.oracore.OracleTypeBINARY_FLOAT;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeINTERVAL;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPTZ;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.TDSPatch;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeADT
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3031304012507165702L;
    static final int S_TOP = 1;
    static final int S_EMBEDDED = 2;
    static final int S_UPT_ADT = 4;
    static final int S_JAVA_OBJECT = 16;
    static final int S_FINAL_TYPE = 32;
    static final int S_SUB_TYPE = 64;
    static final int S_ATTR_TDS = 128;
    static final int S_HAS_METADATA = 256;
    static final int S_TDS_PARSED = 512;
    private int m_status = 1;
    int m_tds_version = -1;
    static final int KOPT_V80 = 1;
    static final int KOPT_V81 = 2;
    static final int KOPT_VNFT = 3;
    static final int KOPT_VERSION = 3;
    boolean endOfAdt = false;
    int m_type_version = -1;
    byte[] m_LDS = null;
    long[] m_ldsOffsetArray = null;
    long m_fixedDataSize = -1L;
    int m_alignmentReq = -1;
    transient byte[] m_TDS = null;
    OracleType[] m_attrTypes = null;
    String[] m_attrNames;
    String[] m_attrTypeNames;
    public long tdo_c_state = 0L;
    byte[] m_toid = null;
    byte[] fdo;
    int char_set_if;
    int char_set_form;
    boolean big_endian;
    int flattened_attr_num;
    transient StreamInfo m_tdsContext;
    transient int m_opcode;
    transient int idx = 1;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 2;
    static final int OTHER_USER_OBJECT = 3;
    static final int OTHER_USER_SYNONYM = 4;
    static final int PUBLIC_SYNONYM = 5;
    static final int BREAK = 6;
    static final String[] sqlString = new String[]{"SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT /*+ RULE */ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+RULE*/ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT /*+ RULE */ ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE /*+RULE*/  the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT /*+ RULE */TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_STAMP = 21;
    static final int KOPM_OTS_TZSTAMP = 23;
    static final int KOPM_OTS_INTERVAL = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPM_OTS_BINARY_INTEGE = 32;
    static final int KOPM_OTS_IMPTZSTAMP = 33;
    static final int KOPM_OTS_BFLOAT = 37;
    static final int KOPM_OTS_BDOUBLE = 45;
    static final int KOTTCOPQ = 58;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OP_SUBTYPE_MARKER = 43;
    static final int KOPT_OP_EMBADT_INFO = 44;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;
    static final int REGULAR_PATCH = 0;
    static final int SIMPLE_PATCH = 1;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040705";

    protected OracleTypeADT() {
    }

    public OracleTypeADT(byte[] byArray, int n, int n2, short s, String string) throws SQLException {
        this(string, (Connection)null);
        this.m_toid = byArray;
        this.m_type_version = n;
        this.char_set_if = n2;
        this.char_set_form = s;
    }

    public OracleTypeADT(String string) throws SQLException {
        super(string, null);
    }

    public OracleTypeADT(String string, Connection connection) throws SQLException {
        super(string, (OracleConnection)connection);
    }

    public OracleTypeADT(String string, Connection connection, byte[] byArray) throws SQLException {
        this(string, connection);
        this.fdo = byArray;
        this.initEndianess(byArray);
    }

    public OracleTypeADT(OracleTypeADT oracleTypeADT, int n, Connection connection) throws SQLException {
        super(oracleTypeADT, n, (OracleConnection)connection);
    }

    public OracleTypeADT(OracleTypeADT oracleTypeADT, int n, Connection connection, byte[] byArray) throws SQLException {
        this(oracleTypeADT, n, connection);
        this.fdo = byArray;
        this.initEndianess(byArray);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof STRUCT) {
                return (STRUCT)object;
            }
            if (object instanceof SQLData || object instanceof ObjectData) {
                return STRUCT.toSTRUCT(object, oracleConnection);
            }
            if (object instanceof Object[]) {
                StructDescriptor structDescriptor = this.createStructDescriptor();
                STRUCT sTRUCT = this.createObjSTRUCT(structDescriptor, (Object[])object);
                return sTRUCT;
            }
            DatabaseError.check_error(59, object);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = (int)(n == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    datumArray[i] = this.toDatum(objectArray[(int)l + i - 1], oracleConnection);
                }
            } else {
                DatabaseError.check_error(59, object);
            }
        }
        return datumArray;
    }

    public int getTypeCode() throws SQLException {
        if ((this.getStatus() & 0x10) != 0) {
            return 2008;
        }
        return 2002;
    }

    public OracleType[] getAttrTypes() throws SQLException {
        if (this.m_attrTypes == null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (!oracleType.isObjectType()) {
            return false;
        }
        StructDescriptor structDescriptor = (StructDescriptor)oracleType.getTypeDescriptor();
        return this.m_descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        if (structDescriptor == null) {
            return false;
        }
        return this.m_descriptor.isInHierarchyOf(structDescriptor.getName());
    }

    public boolean isObjectType() {
        return true;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.m_descriptor;
    }

    public synchronized void init(OracleConnection oracleConnection) throws SQLException {
        this.m_status = 1;
        this.m_conn = oracleConnection;
        this.initMetadata(oracleConnection);
        if (this.m_TDS != null) {
            this.parseTDS(this.m_TDS, 0L);
            this.m_TDS = null;
            this.m_tdsContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMetadata(OracleConnection oracleConnection) throws SQLException {
        if ((this.m_status & 0x100) != 0) {
            return;
        }
        if (!this.m_hasName) {
            this.getFullName();
        }
        Object var2_2 = null;
        OracleConnection oracleConnection2 = oracleConnection;
        synchronized (oracleConnection2) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if ((this.m_status & 0x100) == 0) {
                    Statement statement = null;
                    try {
                        if (this.tdo_c_state == 0L) {
                            this.m_conn.getOracleTypeADT(this);
                        }
                        String string = null;
                        this.fdo = this.m_conn.getFDO(false);
                        boolean bl = this.fdo == null;
                        string = !bl ? "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;" : "begin :1 := dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7);       :8 := dbms_pickler.get_format(:9); end;";
                        boolean bl2 = false;
                        statement = this.m_conn.prepareCall(string);
                        statement.registerOutParameter(1, 2);
                        statement.registerOutParameter(4, -4);
                        statement.registerOutParameter(5, 4);
                        statement.registerOutParameter(6, -4);
                        statement.registerOutParameter(7, -4);
                        if (bl) {
                            statement.registerOutParameter(8, 2);
                            statement.registerOutParameter(9, -4);
                        }
                        statement.setString(2, this.m_schemaName);
                        statement.setString(3, this.m_typeName);
                        statement.execute();
                        int n = statement.getInt(1);
                        if (n != 0) {
                            if (n != 24331) {
                                DatabaseError.throwSqlException(74, this.m_fullName);
                            }
                            if (n == 24331) {
                                bl2 = true;
                                statement.registerOutParameter(6, 2004);
                                statement.execute();
                                n = statement.getInt(1);
                                if (n != 0) {
                                    DatabaseError.throwSqlException(74, this.m_fullName);
                                }
                            }
                        }
                        if (bl && statement.getInt(8) != 0) {
                            DatabaseError.throwSqlException(1, "dbms_pickler.get_format()");
                        }
                        this.m_toid = statement.getBytes(4);
                        this.m_type_version = NUMBER.toInt(statement.getBytes(5));
                        if (!bl2) {
                            this.m_TDS = statement.getBytes(6);
                        } else {
                            try {
                                Blob blob = ((OracleCallableStatement)statement).getBlob(6);
                                InputStream inputStream = blob.getBinaryStream();
                                this.m_TDS = new byte[(int)blob.length()];
                                inputStream.read(this.m_TDS);
                                inputStream.close();
                                ((BLOB)blob).freeTemporary();
                            }
                            catch (IOException iOException) {
                                DatabaseError.throwSqlException(iOException);
                            }
                        }
                        if (bl) {
                            this.fdo = statement.getBytes(9);
                            this.m_conn.setFDO(this.fdo);
                        }
                        this.big_endian = this.m_conn.getBigEndian();
                        this.flattened_attr_num = Util.getUnsignedByte(this.m_TDS[8]) * 256 + Util.getUnsignedByte(this.m_TDS[9]);
                        this.m_LDS = statement.getBytes(7);
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                this.setStatusBits(256);
            }
        }
    }

    private void initEndianess(byte[] byArray) {
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        int n = nArray[6 + nArray[5] + nArray[6] + 5];
        int n2 = n & 0x10;
        if (n2 < 0) {
            n2 += 256;
        }
        this.big_endian = n2 > 0;
    }

    void parseLDS(InputStream inputStream) throws SQLException {
        long l = Util.read_long(inputStream);
        this.m_fixedDataSize = Util.read_long(inputStream);
        this.m_ldsOffsetArray = new long[this.flattened_attr_num];
        for (int i = 0; i < this.flattened_attr_num; ++i) {
            this.m_ldsOffsetArray[i] = Util.read_long(inputStream);
        }
    }

    public void generateLDS() throws SQLException {
        Vector vector = this.generateLDSrec();
        this.m_ldsOffsetArray = new long[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Integer n = (Integer)vector.elementAt(i);
            this.m_ldsOffsetArray[i] = n.longValue();
        }
    }

    private Vector generateLDSrec() throws SQLException {
        int n = 0;
        int n2 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = this.getNumAttrs();
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            Vector vector2 = null;
            OracleType oracleType = this.getAttrTypeAt(i);
            if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
                vector2 = ((OracleTypeADT)oracleType).generateLDSrec();
                n5 = ((OracleTypeADT)oracleType).getAlignmentReq();
                n4 = (int)((OracleTypeADT)oracleType).getFixedDataSize();
            } else {
                n4 = oracleType.getSizeLDS(this.fdo);
                n5 = oracleType.getAlignLDS(this.fdo);
            }
            if ((n & n5) > 0) {
                n = Util.LDSRound(n, n5);
            }
            if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
                for (int j = 0; j < vector2.size(); ++j) {
                    Integer n6 = (Integer)vector2.elementAt(j);
                    Integer n7 = new Integer(n6 + n);
                    vector.addElement(n7);
                }
            } else {
                vector.addElement(new Integer(n));
            }
            n += n4;
            if (n5 <= n2) continue;
            n2 = n5;
        }
        if ((n & n2) > 0) {
            n = Util.LDSRound(n, n2);
        }
        this.m_alignmentReq = n2;
        this.m_fixedDataSize = n;
        return vector;
    }

    void parseTDS(byte[] byArray, long l) throws SQLException {
        if (this.m_attrTypes != null) {
            return;
        }
        this.m_tdsContext = new StreamInfo(byArray, l);
        long l2 = this.m_tdsContext.readLong() + this.m_tdsContext.offset();
        this.m_tdsContext.checkNextByte((byte)38);
        this.m_tds_version = this.m_tdsContext.readByte();
        this.m_tdsContext.skipBytes(2);
        this.flattened_attr_num = this.m_tdsContext.readShort();
        if ((this.m_tdsContext.readByte() & 0xFF) == 255) {
            this.setStatusBits(128);
        }
        long l3 = this.m_tdsContext.offset();
        this.m_tdsContext.checkNextByte((byte)41);
        if (this.m_tdsContext.readShort() != 0) {
            DatabaseError.check_error(47, "parseTDS");
        }
        long l4 = this.m_tdsContext.readLong();
        this.parseTDSrec(this.m_tdsContext);
        if (this.m_tds_version >= 3) {
            this.m_tdsContext.skip_to(l3 + l4 + 2L);
            this.m_tdsContext.skipBytes(2 * this.flattened_attr_num);
            byte by = this.m_tdsContext.readByte();
            if (this.m_tdsContext.isJavaObject(this.m_tds_version, by)) {
                this.setStatusBits(16);
            }
            if (this.m_tdsContext.isFinalType(this.m_tds_version, by)) {
                this.setStatusBits(32);
            }
            if (this.m_tdsContext.readByte() != 1) {
                this.setStatusBits(64);
            }
        } else {
            this.setStatusBits(32);
        }
        this.m_tdsContext.skip_to(l2);
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        Vector<OracleType> vector = new Vector<OracleType>(5);
        OracleType oracleType = null;
        this.null_offset = streamInfo.null_offset++;
        this.lds_offset = streamInfo.lds_offset;
        this.idx = 1;
        while ((oracleType = this.getNextTypeObject(streamInfo)) != null) {
            vector.addElement(oracleType);
        }
        if (this.m_opcode == 42) {
            this.endOfAdt = true;
            this.applyTDSpatches(streamInfo);
        }
        this.m_attrTypes = new OracleType[vector.size()];
        vector.copyInto(this.m_attrTypes);
    }

    private void applyTDSpatches(StreamInfo streamInfo) throws SQLException {
        TDSPatch tDSPatch = streamInfo.getNextPatch();
        while (tDSPatch != null) {
            streamInfo.moveToPatchPos(tDSPatch);
            int n = tDSPatch.getType();
            if (n == 0) {
                streamInfo.readByte();
                byte by = tDSPatch.getUptTypeCode();
                switch (by) {
                    case -6: {
                        streamInfo.readLong();
                    }
                    case -5: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeADT(oracleNamedType.getFullName(), this.m_conn, this.fdo) : new OracleTypeADT(oracleNamedType.getParent(), oracleNamedType.getOrder(), this.m_conn, this.fdo);
                        oracleTypeADT.setUptADT();
                        oracleTypeADT.parseTDS(streamInfo.tds(), streamInfo.absolute_offset());
                        streamInfo.skipBytes((int)oracleTypeADT.m_tdsContext.offset());
                        tDSPatch.apply(oracleTypeADT.cleanup());
                        break;
                    }
                    case 58: {
                        OracleNamedType oracleNamedType = tDSPatch.getOwner();
                        OracleTypeADT oracleTypeADT = null;
                        oracleTypeADT = oracleNamedType.hasName() ? new OracleTypeOPAQUE(oracleNamedType.getFullName(), this.m_conn) : new OracleTypeOPAQUE(oracleNamedType.getParent(), oracleNamedType.getOrder(), this.m_conn);
                        ((OracleTypeOPAQUE)oracleTypeADT).parseTDSrec(streamInfo);
                        tDSPatch.apply(oracleTypeADT);
                        break;
                    }
                    default: {
                        DatabaseError.throwSqlException(1);
                        break;
                    }
                }
            } else if (n == 1) {
                OracleType oracleType = this.getNextTypeObject(streamInfo);
                tDSPatch.apply(oracleType, this.m_opcode);
            } else {
                DatabaseError.check_error(47, "parseTDS");
            }
            tDSPatch = streamInfo.getNextPatch();
        }
    }

    public synchronized OracleNamedType cleanup() {
        if (this.m_attrTypes.length == 1 && this.m_attrTypes[0] instanceof OracleTypeCOLLECTION) {
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.m_attrTypes[0];
            oracleTypeCOLLECTION.copy_properties(this);
            return oracleTypeCOLLECTION;
        }
        if (this.m_attrTypes.length == 1 && (this.m_status & 0x80) != 0 && this.m_attrTypes[0] instanceof OracleTypeUPT && ((OracleTypeUPT)this.m_attrTypes[0]).m_realType instanceof OracleTypeOPAQUE) {
            OracleTypeOPAQUE oracleTypeOPAQUE = (OracleTypeOPAQUE)((OracleTypeUPT)this.m_attrTypes[0]).m_realType;
            oracleTypeOPAQUE.copy_properties(this);
            return oracleTypeOPAQUE;
        }
        return this;
    }

    void copy_properties(OracleTypeADT oracleTypeADT) {
        this.m_fullName = oracleTypeADT.m_fullName;
        this.m_schemaName = oracleTypeADT.m_schemaName;
        this.m_typeName = oracleTypeADT.m_typeName;
        this.m_hasName = oracleTypeADT.m_hasName;
        this.m_parent = oracleTypeADT.m_parent;
        this.m_idx = oracleTypeADT.m_idx;
        this.m_conn = oracleTypeADT.m_conn;
        this.m_LDS = oracleTypeADT.m_LDS;
        this.m_TDS = oracleTypeADT.m_TDS;
        this.m_toid = oracleTypeADT.m_toid;
        this.fdo = oracleTypeADT.fdo;
        this.m_tds_version = oracleTypeADT.m_tds_version;
        this.m_type_version = oracleTypeADT.m_type_version;
        this.tdo_c_state = oracleTypeADT.tdo_c_state;
        this.null_offset = oracleTypeADT.null_offset;
        this.big_endian = oracleTypeADT.big_endian;
        this.endOfAdt = oracleTypeADT.endOfAdt;
    }

    OracleType getNextTypeObject(StreamInfo streamInfo) throws SQLException {
        while (true) {
            this.m_opcode = streamInfo.readByte();
            if (this.m_opcode == 43) continue;
            if (this.m_opcode != 44) break;
            byte by = streamInfo.readByte();
            if (!streamInfo.isJavaObject(3, by)) continue;
            this.setStatusBits(16);
        }
        switch (this.m_opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE oracleTypeDATE = new OracleTypeDATE();
                oracleTypeDATE.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeDATE;
            }
            case 7: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.m_conn, 12);
                oracleTypeCHAR.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 1: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.m_conn, 1);
                oracleTypeCHAR.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCHAR;
            }
            case 39: {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this, this.idx, this.m_conn, this.fdo);
                oracleTypeADT.setEmbeddedADT();
                oracleTypeADT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeADT;
            }
            case 6: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(2);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 3: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(3);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 4: {
                OracleTypeNUMBER oracleTypeNUMBER = new OracleTypeNUMBER(8);
                oracleTypeNUMBER.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeNUMBER;
            }
            case 5: {
                OracleTypeFLOAT oracleTypeFLOAT = new OracleTypeFLOAT();
                oracleTypeFLOAT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeFLOAT;
            }
            case 37: {
                OracleTypeBINARY_FLOAT oracleTypeBINARY_FLOAT = new OracleTypeBINARY_FLOAT();
                oracleTypeBINARY_FLOAT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBINARY_FLOAT;
            }
            case 45: {
                OracleTypeBINARY_DOUBLE oracleTypeBINARY_DOUBLE = new OracleTypeBINARY_DOUBLE();
                oracleTypeBINARY_DOUBLE.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBINARY_DOUBLE;
            }
            case 8: {
                OracleTypeSINT32 oracleTypeSINT32 = new OracleTypeSINT32();
                oracleTypeSINT32.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeSINT32;
            }
            case 9: {
                OracleTypeREF oracleTypeREF = new OracleTypeREF(this, this.idx, this.m_conn);
                oracleTypeREF.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeREF;
            }
            case 31: {
                OracleTypeBFILE oracleTypeBFILE = new OracleTypeBFILE(this.m_conn);
                oracleTypeBFILE.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBFILE;
            }
            case 19: {
                OracleTypeRAW oracleTypeRAW = new OracleTypeRAW();
                oracleTypeRAW.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeRAW;
            }
            case 29: {
                OracleTypeCLOB oracleTypeCLOB = new OracleTypeCLOB(this.m_conn);
                oracleTypeCLOB.parseTDSrec(streamInfo);
                if (this.m_typeName != null && !this.endOfAdt) {
                    this.m_conn.getForm(this, oracleTypeCLOB, this.idx);
                }
                ++this.idx;
                return oracleTypeCLOB;
            }
            case 30: {
                OracleTypeBLOB oracleTypeBLOB = new OracleTypeBLOB(this.m_conn);
                oracleTypeBLOB.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeBLOB;
            }
            case 21: {
                OracleTypeTIMESTAMP oracleTypeTIMESTAMP = new OracleTypeTIMESTAMP(this.m_conn);
                oracleTypeTIMESTAMP.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeTIMESTAMP;
            }
            case 23: {
                OracleTypeTIMESTAMPTZ oracleTypeTIMESTAMPTZ = new OracleTypeTIMESTAMPTZ(this.m_conn);
                oracleTypeTIMESTAMPTZ.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeTIMESTAMPTZ;
            }
            case 33: {
                OracleTypeTIMESTAMPLTZ oracleTypeTIMESTAMPLTZ = new OracleTypeTIMESTAMPLTZ(this.m_conn);
                oracleTypeTIMESTAMPLTZ.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeTIMESTAMPLTZ;
            }
            case 24: {
                OracleTypeINTERVAL oracleTypeINTERVAL = new OracleTypeINTERVAL(this.m_conn);
                oracleTypeINTERVAL.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeINTERVAL;
            }
            case 28: {
                OracleTypeCOLLECTION oracleTypeCOLLECTION = new OracleTypeCOLLECTION(this, this.idx, this.m_conn);
                oracleTypeCOLLECTION.big_endian = this.big_endian;
                oracleTypeCOLLECTION.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeCOLLECTION;
            }
            case 27: {
                OracleTypeUPT oracleTypeUPT = new OracleTypeUPT(this, this.idx, this.m_conn);
                oracleTypeUPT.big_endian = this.big_endian;
                oracleTypeUPT.parseTDSrec(streamInfo);
                ++this.idx;
                return oracleTypeUPT;
            }
        }
        Object var2_25 = null;
        DatabaseError.check_error(48, "get_next_type: " + this.m_opcode);
        return null;
    }

    public synchronized byte[] linearize(Datum datum) throws SQLException {
        return this.pickle81(datum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this._unlinearize(byArray, l, datum, n, map);
        } else {
            OracleConnection oracleConnection2 = oracleConnection;
            synchronized (oracleConnection2) {
                datum2 = this._unlinearize(byArray, l, datum, n, map);
            }
        }
        return datum2;
    }

    public synchronized Datum _unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if ((byArray[0] & 0x80) > 0) {
            PickleContext pickleContext = new PickleContext(byArray, l);
            return this.unpickle81(pickleContext, (STRUCT)datum, 1, n, map);
        }
        UnpickleContext unpickleContext = new UnpickleContext(byArray, (int)l, null, null, this.big_endian);
        return this.unpickle80(unpickleContext, (STRUCT)datum, 1, n, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected STRUCT unpickle80(UnpickleContext unpickleContext, STRUCT sTRUCT, int n, int n2, Map map) throws SQLException {
        long l;
        STRUCT sTRUCT2 = sTRUCT;
        if (n == 3) {
            if (sTRUCT2 == null) {
                StructDescriptor structDescriptor = this.createStructDescriptor();
                sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
            }
            sTRUCT2.setImage(unpickleContext.image(), unpickleContext.absolute_offset(), 0L);
        }
        if ((l = unpickleContext.read_long()) == 0L) {
            return null;
        }
        if (n == 9) {
            unpickleContext.skip_bytes((int)l);
            return sTRUCT2;
        }
        if (n == 3) {
            sTRUCT2.setImageLength(l + 4L);
            unpickleContext.skip_bytes((int)l);
            return sTRUCT2;
        }
        unpickleContext.skip_bytes(1);
        byte by = unpickleContext.read_byte();
        boolean[] blArray = this.unpickle_nulls(unpickleContext);
        long l2 = unpickleContext.read_long();
        long l3 = (long)unpickleContext.offset() + l2;
        try {
            if (!blArray[0]) {
                UnpickleContext unpickleContext2 = new UnpickleContext(unpickleContext.image(), unpickleContext.absolute_offset(), blArray, this.getLdsOffsetArray(), this.big_endian);
                STRUCT sTRUCT3 = this.unpickle80rec(unpickleContext2, sTRUCT2, n2, map);
                return sTRUCT3;
            }
        }
        finally {
            unpickleContext.skip_to(l3);
        }
        return sTRUCT2;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        STRUCT sTRUCT = this.unpickle80rec(unpickleContext, null, 1, map);
        return this.toObject(sTRUCT, n2, map);
    }

    private STRUCT unpickle80rec(UnpickleContext unpickleContext, STRUCT sTRUCT, int n, Map map) throws SQLException {
        Object[] objectArray;
        if (unpickleContext.is_null(this.null_offset)) {
            return null;
        }
        unpickleContext.skip_to(unpickleContext.m_ldsOffsets[this.lds_offset]);
        int n2 = this.getNumAttrs();
        STRUCT sTRUCT2 = sTRUCT;
        if (sTRUCT2 == null) {
            objectArray = this.createStructDescriptor();
            sTRUCT2 = this.createByteSTRUCT((StructDescriptor)objectArray, null);
        }
        switch (n) {
            case 1: {
                objectArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = (Datum)this.getAttrTypeAt(i).unpickle80rec(unpickleContext, 1, n, map);
                }
                sTRUCT2.setDatumArray((Datum[])objectArray);
                break;
            }
            case 2: {
                objectArray = new Object[n2];
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = this.getAttrTypeAt(i).unpickle80rec(unpickleContext, 1, n, map);
                }
                sTRUCT2.setObjArray(objectArray);
                break;
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        return sTRUCT2;
    }

    private boolean[] unpickle_nulls(UnpickleContext unpickleContext) throws SQLException {
        unpickleContext.skip_bytes(4);
        byte[] byArray = unpickleContext.read_lengthBytes();
        boolean[] blArray = new boolean[(byArray.length - 2) * 4];
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (i % 4 == 0) {
                n = byArray[2 + i / 4];
            }
            blArray[i] = (n & 3) != 0;
            n = (byte)(n >> 2);
        }
        return blArray;
    }

    protected STRUCT unpickle81(PickleContext pickleContext, STRUCT sTRUCT, int n, int n2, Map map) throws SQLException {
        STRUCT sTRUCT2 = sTRUCT;
        long l = pickleContext.offset();
        byte by = pickleContext.readByte_pctx();
        if (!PickleContext.is81format_pctx(by)) {
            DatabaseError.throwSqlException(1, "Image is not in 8.1 format");
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            DatabaseError.throwSqlException(1, "Image is a collection image, expecting ADT");
        }
        if (!pickleContext.readAndCheckVersion_pctx()) {
            DatabaseError.throwSqlException(1, "Image version is not recognized");
        }
        block0 : switch (n) {
            case 9: {
                pickleContext.skip_bytes(pickleContext.readLength_pctx(true) - 2);
                break;
            }
            case 3: {
                long l2 = pickleContext.readLength_pctx();
                sTRUCT2 = this.unpickle81_prefix(pickleContext, sTRUCT2, by);
                if (sTRUCT2 == null) {
                    StructDescriptor structDescriptor = this.createStructDescriptor();
                    sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
                }
                sTRUCT2.setImage(pickleContext.image(), l, 0L);
                sTRUCT2.setImageLength(l2);
                pickleContext.skip_to(l + l2);
                break;
            }
            default: {
                OracleType[] oracleTypeArray;
                pickleContext.skipLength_pctx();
                sTRUCT2 = this.unpickle81_prefix(pickleContext, sTRUCT2, by);
                if (sTRUCT2 == null) {
                    oracleTypeArray = this.createStructDescriptor();
                    sTRUCT2 = this.createByteSTRUCT((StructDescriptor)oracleTypeArray, null);
                }
                oracleTypeArray = sTRUCT2.getDescriptor().getOracleTypeADT().getAttrTypes();
                switch (n2) {
                    case 1: {
                        Datum[] datumArray = new Datum[oracleTypeArray.length];
                        for (int i = 0; i < oracleTypeArray.length; ++i) {
                            datumArray[i] = (Datum)oracleTypeArray[i].unpickle81rec(pickleContext, n2, map);
                        }
                        sTRUCT2.setDatumArray(datumArray);
                        break block0;
                    }
                    case 2: {
                        Object[] objectArray = new Object[oracleTypeArray.length];
                        for (int i = 0; i < oracleTypeArray.length; ++i) {
                            objectArray[i] = oracleTypeArray[i].unpickle81rec(pickleContext, n2, map);
                        }
                        sTRUCT2.setObjArray(objectArray);
                        break block0;
                    }
                }
                DatabaseError.throwSqlException(1);
            }
        }
        return sTRUCT2;
    }

    protected STRUCT unpickle81_prefix(PickleContext pickleContext, STRUCT sTRUCT, byte by) throws SQLException {
        STRUCT sTRUCT2 = sTRUCT;
        if (PickleContext.hasPrefix_pctx(by)) {
            boolean bl;
            long l = pickleContext.readLength_pctx() + pickleContext.absolute_offset();
            byte by2 = pickleContext.readByte_pctx();
            byte by3 = (byte)(by2 & 0xC);
            boolean bl2 = by3 == 0;
            boolean bl3 = by3 == 4;
            boolean bl4 = by3 == 8;
            boolean bl5 = by3 == 12;
            boolean bl6 = bl = (by2 & 0x10) != 0;
            if (bl3) {
                byte[] byArray = pickleContext.readBytes_pctx(16);
                String string = OracleTypeADT.toid2typename(this.m_conn, byArray);
                StructDescriptor structDescriptor = (StructDescriptor)TypeDescriptor.getTypeDescriptor(string, this.m_conn);
                if (sTRUCT2 == null) {
                    sTRUCT2 = this.createByteSTRUCT(structDescriptor, null);
                } else {
                    sTRUCT2.setDescriptor(structDescriptor);
                }
            }
            this.m_type_version = bl ? pickleContext.readLength_pctx() : 1;
            if (bl4 | bl5) {
                DatabaseError.throwSqlException(23);
            }
            pickleContext.skip_to(l);
        }
        return sTRUCT2;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        byte by = pickleContext.readByte_pctx();
        byte by2 = 0;
        if (PickleContext.isAtomicNull_pctx(by)) {
            return null;
        }
        if (PickleContext.isImmEmbNull_pctx(by)) {
            by2 = pickleContext.readByte_pctx();
        }
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, by2);
        return this.toObject(sTRUCT, n, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n, Map map) throws SQLException {
        STRUCT sTRUCT = this.unpickle81datum(pickleContext, by, (byte)0);
        return this.toObject(sTRUCT, n, map);
    }

    private STRUCT unpickle81datum(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        int n = this.getNumAttrs();
        StructDescriptor structDescriptor = this.createStructDescriptor();
        STRUCT sTRUCT = this.createByteSTRUCT(structDescriptor, null);
        OracleType oracleType = this.getAttrTypeAt(0);
        Object object = null;
        object = PickleContext.isImmEmbNull_pctx(by) && by2 == 1 ? null : (PickleContext.isImmEmbNull_pctx(by) ? ((OracleTypeADT)oracleType).unpickle81datum(pickleContext, by, (byte)(by2 - 1)) : (PickleContext.isElementNull_pctx(by) ? null : oracleType.unpickle81rec(pickleContext, by, 1, null)));
        Datum[] datumArray = new Datum[n];
        datumArray[0] = (Datum)object;
        for (int i = 1; i < n; ++i) {
            oracleType = this.getAttrTypeAt(i);
            datumArray[i] = (Datum)oracleType.unpickle81rec(pickleContext, 1, null);
        }
        sTRUCT.setDatumArray(datumArray);
        return sTRUCT;
    }

    public byte[] pickle81(Datum datum) throws SQLException {
        PickleContext pickleContext = new PickleContext();
        pickleContext.initStream_pctx();
        this.pickle81(pickleContext, datum);
        byte[] byArray = pickleContext.stream2bytes_pctx();
        datum.setShareBytes(byArray);
        return byArray;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = pickleContext.offset() + 2;
        int n2 = 0;
        n2 += pickleContext.writeImageHeader_pctx(this.shouldHavePrefix());
        n2 += this.pickle81_prefix(pickleContext);
        pickleContext.patchImageLen_pctx(n, n2 += this.pickle81rec(pickleContext, datum, 0));
        return n2;
    }

    private boolean has_type_version() {
        return this.m_type_version > 1;
    }

    private boolean needs_toid() {
        return (this.m_status & 0x40) != 0 || (this.m_status & 0x20) == 0 || this.has_type_version();
    }

    private boolean shouldHavePrefix() {
        return this.has_type_version() || this.needs_toid();
    }

    protected int pickle81_prefix(PickleContext pickleContext) throws SQLException {
        if (this.shouldHavePrefix()) {
            int n = 0;
            int n2 = 1;
            int n3 = 1;
            if (this.needs_toid()) {
                n3 += this.getTOID().length;
                n2 |= 4;
            }
            if (this.has_type_version()) {
                n2 |= 0x10;
                n3 = this.m_type_version > PickleContext.KOPI20_LN_MAXV ? (n3 += 5) : ++n3;
            }
            n = pickleContext.writeLength_pctx(n3);
            n += pickleContext.write_data_pctx((byte)n2);
            if (this.needs_toid()) {
                n += pickleContext.write_data_pctx(this.m_toid);
            }
            if (this.has_type_version()) {
                n += pickleContext.writeLength_pctx(this.m_type_version);
            }
            return n;
        }
        return 0;
    }

    private int pickle81rec(PickleContext pickleContext, Datum datum, int n) throws SQLException {
        int n2 = 0;
        Datum[] datumArray = ((STRUCT)datum).getOracleAttributes();
        int n3 = datumArray.length;
        int n4 = 0;
        OracleType oracleType = this.getAttrTypeAt(0);
        if (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT)) {
            n4 = 1;
            n2 = datumArray[0] == null ? (n > 0 ? (n2 += pickleContext.writeIEmbNull_pctx((byte)n)) : (n2 += pickleContext.writeAtomicNull_pctx())) : (n2 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[0], n + 1));
        }
        while (n4 < n3) {
            oracleType = this.getAttrTypeAt(n4);
            n2 = datumArray[n4] == null ? (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n2 += pickleContext.writeAtomicNull_pctx()) : (n2 += pickleContext.writeEltNull_pctx())) : (oracleType instanceof OracleTypeADT && !(oracleType instanceof OracleTypeCOLLECTION) && !(oracleType instanceof OracleTypeUPT) ? (n2 += ((OracleTypeADT)oracleType).pickle81rec(pickleContext, datumArray[n4], 1)) : (n2 += oracleType.pickle81(pickleContext, datumArray[n4])));
            ++n4;
        }
        return n2;
    }

    private Object toObject(STRUCT sTRUCT, int n, Map map) throws SQLException {
        switch (n) {
            case 1: {
                return sTRUCT;
            }
            case 2: {
                if (sTRUCT == null) break;
                return sTRUCT.toJdbc(map);
            }
            default: {
                DatabaseError.throwSqlException(1);
            }
        }
        return null;
    }

    public String getAttributeType(int n) throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        if (this.m_attrNames == null) {
            this.initADTAttrNames();
        }
        if (n < 1 || n > this.m_attrTypeNames.length) {
            DatabaseError.check_error(1, "Invalid index");
        }
        return this.m_attrTypeNames[n - 1];
    }

    public String getAttributeType(int n, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n);
        }
        if (n < 1 || this.m_attrTypeNames != null && n > this.m_attrTypeNames.length) {
            DatabaseError.check_error(1, "Invalid index");
        }
        if (this.m_attrTypeNames != null) {
            return this.m_attrTypeNames[n - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeName(int n) throws SQLException {
        if (this.m_attrNames == null) {
            this.initADTAttrNames();
        }
        OracleTypeADT oracleTypeADT = this;
        synchronized (oracleTypeADT) {
            if (n < 1 || n > this.m_attrNames.length) {
                DatabaseError.check_error(1, "Invalid index");
            }
        }
        return this.m_attrNames[n - 1];
    }

    public String getAttributeName(int n, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeName(n);
        }
        if (n < 1 || this.m_attrNames != null && n > this.m_attrNames.length) {
            DatabaseError.check_error(1, "Invalid index");
        }
        if (this.m_attrNames != null) {
            return this.m_attrNames[n - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNames() throws SQLException {
        CallableStatement callableStatement = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String[] stringArray = new String[this.m_attrTypes.length];
        String[] stringArray2 = new String[this.m_attrTypes.length];
        int n = 0;
        int n2 = 0;
        OracleConnection oracleConnection = this.m_conn;
        synchronized (oracleConnection) {
            OracleTypeADT oracleTypeADT = this;
            synchronized (oracleTypeADT) {
                if (this.m_attrNames == null) {
                    int n3 = n = this.m_schemaName.equalsIgnoreCase(this.m_conn.getUserName()) ? 0 : 3;
                    while (n != 6) {
                        block29: {
                            Object var11_10;
                            switch (n) {
                                case 0: {
                                    preparedStatement = this.m_conn.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.m_typeName);
                                    resultSet = preparedStatement.executeQuery();
                                    n = 1;
                                    break;
                                }
                                case 1: {
                                    preparedStatement = this.m_conn.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.m_typeName);
                                    preparedStatement.setString(2, this.m_typeName);
                                    resultSet = preparedStatement.executeQuery();
                                    n = 2;
                                    break;
                                }
                                case 2: {
                                    preparedStatement = this.m_conn.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.m_typeName);
                                    preparedStatement.setString(2, this.m_typeName);
                                    resultSet = preparedStatement.executeQuery();
                                    n = 5;
                                    break;
                                }
                                case 3: {
                                    preparedStatement = this.m_conn.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.m_schemaName);
                                    preparedStatement.setString(2, this.m_typeName);
                                    resultSet = preparedStatement.executeQuery();
                                    n = 4;
                                    break;
                                }
                                case 4: {
                                    preparedStatement = this.m_conn.prepareStatement(sqlString[n]);
                                    preparedStatement.setString(1, this.m_typeName);
                                    preparedStatement.setString(2, this.m_typeName);
                                    resultSet = preparedStatement.executeQuery();
                                    n = 5;
                                    break;
                                }
                                case 5: {
                                    callableStatement = this.m_conn.prepareCall(sqlString[n]);
                                    callableStatement.setString(1, this.m_typeName);
                                    callableStatement.registerOutParameter(2, -10);
                                    callableStatement.execute();
                                    resultSet = ((OracleCallableStatement)callableStatement).getCursor(2);
                                    n = 6;
                                }
                            }
                            try {
                                if (preparedStatement != null) {
                                    preparedStatement.setFetchSize(this.idx);
                                }
                                for (n2 = 0; n2 < this.m_attrTypes.length && resultSet.next(); ++n2) {
                                    if (resultSet.getInt(1) != n2 + 1) {
                                        DatabaseError.throwSqlException(1, "inconsistent ADT attribute");
                                    }
                                    stringArray[n2] = resultSet.getString(2);
                                    stringArray2[n2] = resultSet.getString(4) + "." + resultSet.getString(3);
                                }
                                if (n2 != 0) {
                                    this.m_attrTypeNames = stringArray2;
                                    this.m_attrNames = stringArray;
                                    n = 6;
                                } else {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                    if (preparedStatement != null) {
                                        preparedStatement.close();
                                    }
                                }
                                var11_10 = null;
                                if (resultSet == null) break block29;
                            }
                            catch (Throwable throwable) {
                                var11_10 = null;
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                if (preparedStatement != null) {
                                    preparedStatement.close();
                                }
                                if (callableStatement != null) {
                                    callableStatement.close();
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (callableStatement == null) continue;
                        callableStatement.close();
                        {
                        }
                    }
                }
            }
        }
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            if (!this.m_hasName && this.getFullName(false) == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.m_conn);
                this.m_descriptor = new StructDescriptor(oracleTypeADT, (Connection)this.m_conn);
            } else {
                this.m_descriptor = StructDescriptor.createDescriptor(this.m_fullName, this.m_conn);
            }
        }
        return (StructDescriptor)this.m_descriptor;
    }

    STRUCT createObjSTRUCT(StructDescriptor structDescriptor, Object[] objectArray) throws SQLException {
        if ((this.m_status & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, (Connection)this.m_conn, objectArray);
        }
        return new STRUCT(structDescriptor, (Connection)this.m_conn, objectArray);
    }

    STRUCT createByteSTRUCT(StructDescriptor structDescriptor, byte[] byArray) throws SQLException {
        if ((this.m_status & 0x10) != 0) {
            return new JAVA_STRUCT(structDescriptor, byArray, this.m_conn);
        }
        return new STRUCT(structDescriptor, byArray, this.m_conn);
    }

    public static String getSubtypeName(Connection connection, byte[] byArray, long l) throws SQLException {
        byte by;
        PickleContext pickleContext;
        block6: {
            block5: {
                pickleContext = new PickleContext(byArray, l);
                by = pickleContext.readByte_pctx();
                if (!PickleContext.is81format_pctx(by)) break block5;
                if (PickleContext.isCollectionImage_pctx(by)) break block5;
                if (PickleContext.hasPrefix_pctx(by)) break block6;
            }
            return null;
        }
        if (!pickleContext.readAndCheckVersion_pctx()) {
            DatabaseError.throwSqlException(1, "Image version is not recognized");
        }
        pickleContext.skipLength_pctx();
        pickleContext.skipLength_pctx();
        by = pickleContext.readByte_pctx();
        if ((by & 4) != 0) {
            byte[] byArray2 = pickleContext.readBytes_pctx(16);
            return OracleTypeADT.toid2typename(connection, byArray2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toid2typename(Connection connection, byte[] byArray) throws SQLException {
        String string = (String)((OracleConnection)connection).getDescriptor(byArray);
        if (string == null) {
            PreparedStatement preparedStatement;
            block8: {
                preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = connection.prepareStatement("select owner, type_name from all_types where type_oid = :1");
                    preparedStatement.setBytes(1, byArray);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string = resultSet.getString(1) + "." + resultSet.getString(2);
                        ((OracleConnection)connection).putDescriptor(byArray, (Object)string);
                    } else {
                        DatabaseError.throwSqlException(1, "Invalid type oid");
                    }
                    Object var6_5 = null;
                    if (resultSet == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return string;
    }

    public void printDebug() {
    }

    private String debugText() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("OracleTypeADT = " + this);
        printWriter.println("m_fullName = " + this.m_fullName);
        printWriter.println("OracleType[] : ");
        if (this.m_attrTypes != null) {
            for (int i = 0; i < this.m_attrTypes.length; ++i) {
                printWriter.println("[" + i + "] = " + this.m_attrTypes[i]);
            }
        } else {
            printWriter.println("null");
        }
        printWriter.println("LDS : ");
        if (this.m_LDS != null) {
            this.printUnsignedByteArray(this.m_LDS, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("TDS : ");
        if (this.m_TDS != null) {
            this.printUnsignedByteArray(this.m_TDS, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("toid : ");
        if (this.m_toid != null) {
            this.printUnsignedByteArray(this.m_toid, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("fdo : ");
        if (this.fdo != null) {
            this.printUnsignedByteArray(this.fdo, printWriter);
        } else {
            printWriter.println("null");
        }
        printWriter.println("tds version : " + this.m_tds_version);
        printWriter.println("type version : " + this.m_type_version);
        printWriter.println("type version : " + this.m_type_version);
        printWriter.println("big_endian : " + (this.big_endian ? "true" : "false"));
        printWriter.println("opcode : " + this.m_opcode);
        printWriter.println("tdo_c_state : " + this.tdo_c_state);
        return stringWriter.toString();
    }

    public byte[] getTOID() {
        try {
            if (this.m_toid == null) {
                this.initMetadata(this.m_conn);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.m_toid;
    }

    public int getImageFormatVersion() {
        return PickleContext.KOPI20_VERSION;
    }

    public int getTypeVersion() {
        try {
            if (this.m_type_version == -1) {
                this.initMetadata(this.m_conn);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.m_type_version;
    }

    public int getCharSet() {
        return this.char_set_if;
    }

    public int getCharSetForm() {
        return this.char_set_form;
    }

    public synchronized long getTDO_C_STATE() {
        try {
            if (this.tdo_c_state == 0L) {
                this.m_conn.getOracleTypeADT(this);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.tdo_c_state;
    }

    public void setTDO_C_STATE(long l) {
        this.tdo_c_state = l;
    }

    public long getFIXED_DATA_SIZE() {
        try {
            return this.getFixedDataSize();
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public long[] getLDS_OFFSET_ARRAY() {
        try {
            return this.getLdsOffsetArray();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public synchronized long[] getLdsOffsetArray() throws SQLException {
        if (this.m_ldsOffsetArray == null && this.m_conn != null) {
            if ((this.m_status & 1) != 0) {
                if (this.m_LDS == null) {
                    this.init(this.m_conn);
                }
                this.parseLDS(new ByteArrayInputStream(this.m_LDS));
            } else if (this.isEmbeddedADT() || this.isUptADT()) {
                this.generateLDS();
            } else {
                DatabaseError.throwSqlException(1);
            }
        }
        return this.m_ldsOffsetArray;
    }

    public long getFixedDataSize() throws SQLException {
        return this.m_fixedDataSize;
    }

    public int getAlignmentReq() throws SQLException {
        return this.m_alignmentReq;
    }

    public int getNumAttrs() throws SQLException {
        if (this.m_attrTypes == null && this.m_conn != null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes.length;
    }

    public OracleType getAttrTypeAt(int n) throws SQLException {
        if (this.m_attrTypes == null && this.m_conn != null) {
            this.init(this.m_conn);
        }
        return this.m_attrTypes[n];
    }

    public boolean isEmbeddedADT() throws SQLException {
        return (this.m_status & 2) != 0;
    }

    public boolean isUptADT() throws SQLException {
        return (this.m_status & 4) != 0;
    }

    public boolean isTopADT() throws SQLException {
        return (this.m_status & 1) != 0;
    }

    public void setStatus(int n) throws SQLException {
        this.m_status = n;
    }

    void setEmbeddedADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 2);
    }

    void setUptADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 4);
    }

    public boolean isSubType() throws SQLException {
        return (this.m_status & 0x40) != 0;
    }

    public boolean isFinalType() throws SQLException {
        return (this.m_status & 0x20) != 0;
    }

    public boolean isJavaObject() throws SQLException {
        return (this.m_status & 0x10) != 0;
    }

    public int getStatus() throws SQLException {
        if ((this.m_status & 1) != 0 && (this.m_status & 0x100) == 0) {
            this.init(this.m_conn);
        }
        return this.m_status;
    }

    public static OracleTypeADT shallow_clone(OracleTypeADT oracleTypeADT) throws SQLException {
        OracleTypeADT oracleTypeADT2 = new OracleTypeADT();
        OracleTypeADT.shallow_copy(oracleTypeADT, oracleTypeADT2);
        return oracleTypeADT2;
    }

    public static void shallow_copy(OracleTypeADT oracleTypeADT, OracleTypeADT oracleTypeADT2) throws SQLException {
        oracleTypeADT2.m_conn = oracleTypeADT.m_conn;
        oracleTypeADT2.m_hasName = oracleTypeADT.m_hasName;
        oracleTypeADT2.m_fullName = oracleTypeADT.m_fullName;
        oracleTypeADT2.m_schemaName = oracleTypeADT.m_schemaName;
        oracleTypeADT2.m_typeName = oracleTypeADT.m_typeName;
        oracleTypeADT2.m_parent = oracleTypeADT.m_parent;
        oracleTypeADT2.m_idx = oracleTypeADT.m_idx;
        oracleTypeADT2.m_descriptor = oracleTypeADT.m_descriptor;
        oracleTypeADT2.m_status = oracleTypeADT.m_status;
        oracleTypeADT2.null_offset = oracleTypeADT.null_offset;
        oracleTypeADT2.lds_offset = oracleTypeADT.lds_offset;
        oracleTypeADT2.size_for_lds = oracleTypeADT.size_for_lds;
        oracleTypeADT2.align_for_lds = oracleTypeADT.align_for_lds;
        oracleTypeADT2.m_typeCode = oracleTypeADT.m_typeCode;
        oracleTypeADT2.m_dbtypeCode = oracleTypeADT.m_dbtypeCode;
        oracleTypeADT2.m_tds_version = oracleTypeADT.m_tds_version;
        oracleTypeADT2.m_type_version = oracleTypeADT.m_type_version;
        oracleTypeADT2.m_LDS = oracleTypeADT.m_LDS;
        oracleTypeADT2.m_ldsOffsetArray = oracleTypeADT.m_ldsOffsetArray;
        oracleTypeADT2.m_fixedDataSize = oracleTypeADT.m_fixedDataSize;
        oracleTypeADT2.m_alignmentReq = oracleTypeADT.m_alignmentReq;
        oracleTypeADT2.m_TDS = oracleTypeADT.m_TDS;
        oracleTypeADT2.m_attrTypes = oracleTypeADT.m_attrTypes;
        oracleTypeADT2.tdo_c_state = oracleTypeADT.tdo_c_state;
        oracleTypeADT2.m_toid = oracleTypeADT.m_toid;
        oracleTypeADT2.fdo = oracleTypeADT.fdo;
        oracleTypeADT2.char_set_if = oracleTypeADT.char_set_if;
        oracleTypeADT2.char_set_form = oracleTypeADT.char_set_form;
        oracleTypeADT2.big_endian = oracleTypeADT.big_endian;
        oracleTypeADT2.flattened_attr_num = oracleTypeADT.flattened_attr_num;
        oracleTypeADT2.m_tdsContext = oracleTypeADT.m_tdsContext;
        oracleTypeADT2.m_status = oracleTypeADT.m_status;
        oracleTypeADT2.m_attrNames = oracleTypeADT.m_attrNames;
        oracleTypeADT2.m_attrTypeNames = oracleTypeADT.m_attrTypeNames;
        oracleTypeADT2.m_opcode = oracleTypeADT.m_opcode;
        oracleTypeADT2.idx = oracleTypeADT.idx;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.m_status);
        objectOutputStream.writeInt(this.m_tds_version);
        objectOutputStream.writeInt(this.m_type_version);
        objectOutputStream.writeObject(this.m_LDS);
        objectOutputStream.writeObject(this.m_ldsOffsetArray);
        objectOutputStream.writeLong(this.m_fixedDataSize);
        objectOutputStream.writeInt(this.m_alignmentReq);
        objectOutputStream.writeObject(this.m_attrTypes);
        objectOutputStream.writeObject(this.m_attrNames);
        objectOutputStream.writeObject(this.m_attrTypeNames);
        objectOutputStream.writeLong(this.tdo_c_state);
        objectOutputStream.writeObject(this.m_toid);
        objectOutputStream.writeObject(this.fdo);
        objectOutputStream.writeInt(this.char_set_if);
        objectOutputStream.writeInt(this.char_set_form);
        objectOutputStream.writeBoolean(this.big_endian);
        objectOutputStream.writeInt(this.flattened_attr_num);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_status = objectInputStream.readInt();
        this.m_tds_version = objectInputStream.readInt();
        this.m_type_version = objectInputStream.readInt();
        this.m_LDS = (byte[])objectInputStream.readObject();
        this.m_ldsOffsetArray = (long[])objectInputStream.readObject();
        this.m_fixedDataSize = objectInputStream.readLong();
        this.m_alignmentReq = objectInputStream.readInt();
        this.m_attrTypes = (OracleType[])objectInputStream.readObject();
        this.m_attrNames = (String[])objectInputStream.readObject();
        this.m_attrTypeNames = (String[])objectInputStream.readObject();
        this.tdo_c_state = objectInputStream.readLong();
        this.m_toid = (byte[])objectInputStream.readObject();
        this.fdo = (byte[])objectInputStream.readObject();
        this.char_set_if = objectInputStream.readInt();
        this.char_set_form = objectInputStream.readInt();
        this.big_endian = objectInputStream.readBoolean();
        this.flattened_attr_num = objectInputStream.readInt();
    }

    public synchronized void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.m_conn = oracleConnection;
        for (int i = 0; i < this.m_attrTypes.length; ++i) {
            this.m_attrTypes[i].setConnection(oracleConnection);
        }
    }

    private synchronized void setStatusBits(int n) {
        this.m_status |= n;
    }

    private synchronized void maskAndSetStatusBits(int n, int n2) {
        this.m_status &= n;
        this.m_status |= n2;
    }

    private void printUnsignedByteArray(byte[] byArray, PrintWriter printWriter) {
        int n;
        int n2 = byArray.length;
        int[] nArray = Util.toJavaUnsignedBytes(byArray);
        for (n = 0; n < n2; ++n) {
            printWriter.print("0x" + Integer.toHexString(nArray[n]) + " ");
        }
        printWriter.println();
        for (n = 0; n < n2; ++n) {
            printWriter.print(nArray[n] + " ");
        }
        printWriter.println();
    }
}

