/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.rules;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class CloneMethodMustImplementCloneable
extends AbstractJavaRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTImplementsList impl = node.getFirstChildOfType(ASTImplementsList.class);
        if (impl != null && impl.jjtGetParent().equals(node)) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)impl.jjtGetChild(ix);
                if (type.getType() == null) {
                    if (!"Cloneable".equals(type.getImage())) continue;
                    return data;
                }
                if (type.getType().equals(Cloneable.class)) {
                    return data;
                }
                List<Class<?>> implementors = Arrays.asList(type.getType().getInterfaces());
                if (!implementors.contains(Cloneable.class)) continue;
                return data;
            }
        }
        if (node.jjtGetNumChildren() != 0 && node.jjtGetChild(0) instanceof ASTExtendsList) {
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)node.jjtGetChild(0).jjtGetChild(0);
            Class<?> clazz = type.getType();
            if (clazz != null && clazz.equals(Cloneable.class)) {
                return data;
            }
            while (clazz != null && !Object.class.equals(clazz)) {
                if (Arrays.asList(clazz.getInterfaces()).contains(Cloneable.class)) {
                    return data;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        List<ASTBlockStatement> blocks;
        ASTClassOrInterfaceDeclaration classOrInterface = node.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class);
        if (classOrInterface != null && (node.isFinal() || classOrInterface.isFinal()) && node.findDescendantsOfType(ASTBlock.class).size() == 1 && (blocks = node.findDescendantsOfType(ASTBlockStatement.class)).size() == 1) {
            ASTBlockStatement block = blocks.get(0);
            ASTClassOrInterfaceType type = block.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (type != null && type.getType() != null && type.getNthParent(9).equals(node) && type.getType().equals(CloneNotSupportedException.class)) {
                return data;
            }
            if (type != null && type.getType() == null && "CloneNotSupportedException".equals(type.getImage())) {
                return data;
            }
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!"clone".equals(node.getImage())) {
            return data;
        }
        int countParams = ((ASTFormalParameters)node.jjtGetChild(0)).jjtGetNumChildren();
        if (countParams != 0) {
            return data;
        }
        this.addViolation(data, node);
        return data;
    }
}

