/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionalIteratorRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        String exprName;
        if (this.hasNameAsChild(node.jjtGetChild(0)) && (exprName = this.getName(node.jjtGetChild(0))).indexOf(".hasNext") != -1 && node.jjtGetNumChildren() > 1) {
            Node loopBody = node.jjtGetChild(1);
            ArrayList<String> names = new ArrayList<String>();
            this.collectNames(this.getVariableName(exprName), names, loopBody);
            int nextCount = 0;
            for (String name : names) {
                if (name.indexOf(".next") == -1) continue;
                ++nextCount;
            }
            if (nextCount > 1) {
                this.addViolation(data, node);
            }
        }
        return null;
    }

    private String getVariableName(String exprName) {
        return exprName.substring(0, exprName.indexOf(46));
    }

    private void collectNames(String target, List<String> names, Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node child = node.jjtGetChild(i);
            if (child.jjtGetNumChildren() > 0) {
                this.collectNames(target, names, child);
                continue;
            }
            if (!(child instanceof ASTName) || !PositionalIteratorRule.isQualifiedName(child) || !target.equals(this.getVariableName(child.getImage()))) continue;
            names.add(child.getImage());
        }
    }

    private boolean hasNameAsChild(Node node) {
        if (node.jjtGetNumChildren() > 0) {
            if (node.jjtGetChild(0) instanceof ASTName) {
                return true;
            }
            return this.hasNameAsChild(node.jjtGetChild(0));
        }
        return false;
    }

    private String getName(Node node) {
        if (node.jjtGetNumChildren() > 0) {
            if (node.jjtGetChild(0) instanceof ASTName) {
                return ((ASTName)node.jjtGetChild(0)).getImage();
            }
            return this.getName(node.jjtGetChild(0));
        }
        throw new IllegalArgumentException("Check with hasNameAsChild() first!");
    }
}

