/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.javadoc;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocTag {
    public final String label;
    public final String description;
    private static final Map<String, JavadocTag> tagsById = new HashMap<String, JavadocTag>();
    public static final JavadocTag AUTHOR = new JavadocTag("author", "Authors of the source code, in chronological order");
    public static final JavadocTag SINCE = new JavadocTag("since", "Version of the source code that this item was introduced, can be a number or a date");
    public static final JavadocTag VERSION = new JavadocTag("version", "Current version number of the source code");
    public static final JavadocTag DEPRECATED = new JavadocTag("deprecated", "Indicates that an item is a member of the deprecated API");
    public static final JavadocTag PARAM = new JavadocTag("param", " ");
    public static final JavadocTag THROWS = new JavadocTag("throws", " ");
    public static final JavadocTag RETURN = new JavadocTag("returns", " ");
    public static final JavadocTag SEE = new JavadocTag("see", " ");

    private JavadocTag(String theLabel, String theDescription) {
        this.label = theLabel;
        this.description = theDescription;
        if (tagsById.containsKey(theLabel)) {
            throw new IllegalArgumentException("pre-existing tag!");
        }
        tagsById.put(theLabel, this);
    }

    public static JavadocTag tagFor(String id) {
        return tagsById.get(id);
    }

    public static Set<String> allTagIds() {
        return tagsById.keySet();
    }
}

