/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.dfa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.StartOrEndDataFlowNode;
import net.sourceforge.pmd.lang.dfa.VariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableAccessVisitor
extends JavaParserVisitorAdapter {
    public void compute(ASTMethodDeclaration node) {
        if (node.jjtGetParent() instanceof ASTClassOrInterfaceBodyDeclaration) {
            this.computeNow(node);
        }
    }

    public void compute(ASTConstructorDeclaration node) {
        this.computeNow(node);
    }

    private void computeNow(Node node) {
        DataFlowNode inode = node.getDataFlowNode();
        List<VariableAccess> undefinitions = this.markUsages(inode);
        DataFlowNode firstINode = inode.getFlow().get(0);
        firstINode.setVariableAccess(undefinitions);
        DataFlowNode lastINode = inode.getFlow().get(inode.getFlow().size() - 1);
        lastINode.setVariableAccess(undefinitions);
    }

    private List<VariableAccess> markUsages(DataFlowNode inode) {
        ArrayList<VariableAccess> undefinitions = new ArrayList<VariableAccess>();
        Set<Map<VariableNameDeclaration, List<NameOccurrence>>> variableDeclarations = this.collectDeclarations(inode);
        for (Map<VariableNameDeclaration, List<NameOccurrence>> declarations : variableDeclarations) {
            for (Map.Entry<VariableNameDeclaration, List<NameOccurrence>> entry : declarations.entrySet()) {
                VariableNameDeclaration vnd = entry.getKey();
                if (vnd.getAccessNodeParent() instanceof ASTFormalParameter) continue;
                if (((Node)((Object)vnd.getAccessNodeParent())).getFirstDescendantOfType(ASTVariableInitializer.class) != null) {
                    this.addVariableAccess(vnd.getNode(), new VariableAccess(0, vnd.getImage()), inode.getFlow());
                }
                undefinitions.add(new VariableAccess(2, vnd.getImage()));
                for (NameOccurrence occurrence : entry.getValue()) {
                    this.addAccess(occurrence, inode);
                }
            }
        }
        return undefinitions;
    }

    private Set<Map<VariableNameDeclaration, List<NameOccurrence>>> collectDeclarations(DataFlowNode inode) {
        HashSet<Map<VariableNameDeclaration, List<NameOccurrence>>> decls = new HashSet<Map<VariableNameDeclaration, List<NameOccurrence>>>();
        for (int i = 0; i < inode.getFlow().size(); ++i) {
            Map<VariableNameDeclaration, List<NameOccurrence>> varDecls;
            DataFlowNode n = inode.getFlow().get(i);
            if (n instanceof StartOrEndDataFlowNode || decls.contains(varDecls = ((JavaNode)n.getNode()).getScope().getVariableDeclarations())) continue;
            decls.add(varDecls);
        }
        return decls;
    }

    private void addAccess(NameOccurrence occurrence, DataFlowNode inode) {
        if (occurrence.isOnLeftHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(0, occurrence.getImage()), inode.getFlow());
        } else if (occurrence.isOnRightHandSide() || !occurrence.isOnLeftHandSide() && !occurrence.isOnRightHandSide()) {
            this.addVariableAccess(occurrence.getLocation(), new VariableAccess(1, occurrence.getImage()), inode.getFlow());
        }
    }

    private void addVariableAccess(Node node, VariableAccess va, List<DataFlowNode> flow) {
        for (int i = flow.size() - 1; i > 0; --i) {
            DataFlowNode inode = flow.get(i);
            if (inode.getNode() == null) continue;
            List<?> children = inode.getNode().findDescendantsOfType(node.getClass());
            for (Node n : children) {
                if (!node.equals(n)) continue;
                ArrayList<VariableAccess> v = new ArrayList<VariableAccess>();
                v.add(va);
                inode.setVariableAccess(v);
                return;
            }
        }
    }
}

