/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.ast.AbstractNode;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserTreeConstants;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.symboltable.Scope;

public abstract class AbstractJavaNode
extends AbstractNode
implements JavaNode {
    protected JavaParser parser;
    private Scope scope;
    private Comment comment;

    public AbstractJavaNode(int id) {
        super(id);
    }

    public AbstractJavaNode(JavaParser parser, int id) {
        super(id);
        this.parser = parser;
    }

    public void jjtOpen() {
        if (this.beginLine == -1 && this.parser.token.next != null) {
            this.beginLine = this.parser.token.next.beginLine;
            this.beginColumn = this.parser.token.next.beginColumn;
        }
    }

    public void jjtClose() {
        if (this.beginLine == -1 && (this.children == null || this.children.length == 0)) {
            this.beginColumn = this.parser.token.beginColumn;
        }
        if (this.beginLine == -1) {
            this.beginLine = this.parser.token.beginLine;
        }
        this.endLine = this.parser.token.endLine;
        this.endColumn = this.parser.token.endColumn;
    }

    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(JavaParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ((JavaNode)this.children[i]).jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public Scope getScope() {
        if (this.scope == null) {
            return ((JavaNode)this.parent).getScope();
        }
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void comment(Comment theComment) {
        this.comment = theComment;
    }

    public Comment comment() {
        return this.comment;
    }

    public String toString() {
        return JavaParserTreeConstants.jjtNodeName[this.id];
    }
}

