/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ecmascript.ast;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ecmascript.EcmascriptParserOptions;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptNode;
import net.sourceforge.pmd.lang.ecmascript.ast.EcmascriptTreeBuilder;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ErrorCollector;
import org.mozilla.javascript.ast.ParseProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcmascriptParser {
    protected final EcmascriptParserOptions parserOptions;

    public EcmascriptParser(EcmascriptParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected AstRoot parseEcmascript(String sourceCode, List<ParseProblem> parseProblems) throws ParseException {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.setRecordingComments(this.parserOptions.isRecordingComments());
        compilerEnvirons.setRecordingLocalJsDocComments(this.parserOptions.isRecordingLocalJsDocComments());
        compilerEnvirons.setLanguageVersion(this.parserOptions.getRhinoLanguageVersion().getVersion());
        compilerEnvirons.setIdeMode(true);
        compilerEnvirons.setWarnTrailingComma(true);
        ErrorCollector errorCollector = new ErrorCollector();
        Parser parser = new Parser(compilerEnvirons, errorCollector);
        String sourceURI = "unknown";
        boolean beginLineno = true;
        AstRoot astRoot = parser.parse(sourceCode, "unknown", 1);
        parseProblems.addAll(errorCollector.getErrors());
        return astRoot;
    }

    public EcmascriptNode<AstRoot> parse(Reader reader) {
        try {
            ArrayList<ParseProblem> parseProblems = new ArrayList<ParseProblem>();
            String sourceCode = IOUtils.toString(reader);
            AstRoot astRoot = this.parseEcmascript(sourceCode, parseProblems);
            EcmascriptTreeBuilder treeBuilder = new EcmascriptTreeBuilder(sourceCode, parseProblems);
            return treeBuilder.build(astRoot);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }
}

