/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sourceforge.pmd.lang.DataFlowHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.dfa.DataFlowNode;
import net.sourceforge.pmd.lang.dfa.StackObject;
import net.sourceforge.pmd.lang.dfa.StartOrEndDataFlowNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure {
    private final DataFlowHandler dataFlowHandler;
    private List<DataFlowNode> dataFlow = new ArrayList<DataFlowNode>();
    private Stack<StackObject> braceStack = new Stack();
    private Stack<StackObject> continueBreakReturnStack = new Stack();

    public Structure(DataFlowHandler dataFlowHandler) {
        this.dataFlowHandler = dataFlowHandler;
    }

    public DataFlowNode createNewNode(Node node) {
        return this.dataFlowHandler.createDataFlowNode(this.dataFlow, node);
    }

    public DataFlowNode createStartNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, true);
    }

    public DataFlowNode createEndNode(int line) {
        return new StartOrEndDataFlowNode(this.dataFlow, line, false);
    }

    public DataFlowNode getLast() {
        return this.dataFlow.get(this.dataFlow.size() - 1);
    }

    public DataFlowNode getFirst() {
        return this.dataFlow.get(0);
    }

    public void pushOnStack(int type, DataFlowNode node) {
        StackObject obj = new StackObject(type, node);
        if (type == 50 || type == 51 || type == 52 || type == 70) {
            this.continueBreakReturnStack.push(obj);
        } else {
            this.braceStack.push(obj);
        }
        node.setType(type);
    }

    public List<StackObject> getBraceStack() {
        return this.braceStack;
    }

    public List<StackObject> getContinueBreakReturnStack() {
        return this.continueBreakReturnStack;
    }
}

