/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.java.ast.Token;

public class JavaTokenizer
implements Tokenizer {
    public static final String IGNORE_LITERALS = "ignore_literals";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    public static final String IGNORE_ANNOTATIONS = "ignore_annotations";
    public static final String CPD_START = "\"CPD-START\"";
    public static final String CPD_END = "\"CPD-END\"";
    private boolean ignoreAnnotations;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;
    List<Discarder> discarders = new ArrayList<Discarder>();

    public void setProperties(Properties properties) {
        this.ignoreAnnotations = Boolean.parseBoolean(properties.getProperty(IGNORE_ANNOTATIONS, "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty(IGNORE_LITERALS, "false"));
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder stringBuilder = sourceCode.getCodeBuffer();
        LanguageVersionHandler languageVersionHandler = LanguageVersion.JAVA_14.getLanguageVersionHandler();
        String fileName = sourceCode.getFileName();
        TokenManager tokenMgr = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).getTokenManager(fileName, new StringReader(stringBuilder.toString()));
        Token currentToken = (Token)tokenMgr.getNextToken();
        this.initDiscarders();
        while (currentToken.image.length() > 0) {
            for (Discarder discarder : this.discarders) {
                discarder.add(currentToken);
            }
            if (this.inDiscardingState()) {
                currentToken = (Token)tokenMgr.getNextToken();
                continue;
            }
            if (currentToken.kind != 82) {
                this.processToken(tokenEntries, fileName, currentToken);
            }
            currentToken = (Token)tokenMgr.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
    }

    private void processToken(Tokens tokenEntries, String fileName, Token currentToken) {
        String image = currentToken.image;
        if (this.ignoreLiterals && (currentToken.kind == 72 || currentToken.kind == 71 || currentToken.kind == 64 || currentToken.kind == 68)) {
            image = String.valueOf(currentToken.kind);
        }
        if (this.ignoreIdentifiers && currentToken.kind == 73) {
            image = String.valueOf(currentToken.kind);
        }
        tokenEntries.add(new TokenEntry(image, fileName, currentToken.beginLine));
    }

    private void initDiscarders() {
        if (this.ignoreAnnotations) {
            this.discarders.add(new AnnotationStateDiscarder());
        }
        this.discarders.add(new SuppressCPDDiscarder());
        this.discarders.add(new KeyWordToSemiColonStateDiscarder(35));
        this.discarders.add(new KeyWordToSemiColonStateDiscarder(43));
    }

    private boolean inDiscardingState() {
        boolean discarding = false;
        for (Discarder discarder : this.discarders) {
            if (!discarder.isDiscarding()) continue;
            discarding = true;
        }
        return discarding;
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    public static class SuppressCPDDiscarder
    implements Discarder {
        AnnotationStateDiscarder asm = new AnnotationStateDiscarder();
        Boolean discarding = false;

        public void add(Token token) {
            this.asm.add(token);
            if (this.asm.isDiscarding()) {
                if (JavaTokenizer.CPD_START.equals(token.image)) {
                    this.discarding = true;
                }
                if (JavaTokenizer.CPD_END.equals(token.image) && this.discarding.booleanValue()) {
                    this.discarding = false;
                }
            }
        }

        public boolean isDiscarding() {
            return this.discarding;
        }
    }

    public static class KeyWordToSemiColonStateDiscarder
    implements Discarder {
        private final int keyword;
        Stack<Token> tokenStack = new Stack();

        public KeyWordToSemiColonStateDiscarder(int keyword) {
            this.keyword = keyword;
        }

        public void add(Token token) {
            if (token.kind == this.keyword) {
                this.tokenStack.add(token);
            }
            if (token.kind == 82 && this.isDiscarding()) {
                this.tokenStack.clear();
            }
        }

        public boolean isDiscarding() {
            return !this.tokenStack.isEmpty();
        }
    }

    public static class AnnotationStateDiscarder
    implements Discarder {
        Stack<Token> tokenStack = new Stack();

        public void add(Token token) {
            if (this.isDiscarding() && this.tokenStack.size() == 2 && token.kind != 76) {
                this.tokenStack.clear();
            }
            if (token.kind == 85 && !this.isDiscarding()) {
                this.tokenStack.push(token);
                return;
            }
            if (token.kind == 77 && this.isDiscarding()) {
                Token popped = null;
                do {
                    popped = this.tokenStack.pop();
                } while (popped.kind != 76);
                return;
            }
            if (this.isDiscarding()) {
                this.tokenStack.push(token);
            }
        }

        public boolean isDiscarding() {
            return !this.tokenStack.isEmpty();
        }
    }

    public static interface Discarder {
        public void add(Token var1);

        public boolean isDiscarding();
    }
}

