/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.RendererFactory;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Parameter;

public class Formatter {
    private File toFile;
    private String type;
    private boolean toConsole;
    private boolean showSuppressed;
    private final List<Parameter> parameters = new ArrayList<Parameter>();
    private Writer writer;
    private Renderer renderer;

    public void setShowSuppressed(boolean value) {
        this.showSuppressed = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setToConsole(boolean toConsole) {
        this.toConsole = toConsole;
    }

    public void addConfiguredParam(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void start(String baseDir) {
        try {
            if (this.toConsole) {
                this.writer = new BufferedWriter(new OutputStreamWriter(System.out));
            }
            if (this.toFile != null) {
                this.writer = this.getToFileWriter(baseDir);
            }
            this.renderer = this.createRenderer();
            this.renderer.setWriter(this.writer);
            this.renderer.start();
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), ioe);
        }
    }

    public void end(Report errorReport) {
        try {
            this.renderer.renderFileReport(errorReport);
            this.renderer.end();
            if (this.toConsole) {
                this.writer.flush();
            } else {
                this.writer.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), ioe);
        }
    }

    public boolean isNoOutputSupplied() {
        return this.toFile == null && !this.toConsole;
    }

    public String toString() {
        return "file = " + this.toFile + "; renderer = " + this.type;
    }

    private static String[] validRendererCodes() {
        return RendererFactory.REPORT_FORMAT_TO_RENDERER.keySet().toArray(new String[RendererFactory.REPORT_FORMAT_TO_RENDERER.size()]);
    }

    private static String unknownRendererMessage(String userSpecifiedType) {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Formatter type must be one of: '");
        String[] typeCodes = Formatter.validRendererCodes();
        sb.append(typeCodes[0]);
        for (int i = 1; i < typeCodes.length; ++i) {
            sb.append("', '").append(typeCodes[i]);
        }
        sb.append("', or a class name; you specified: ");
        sb.append(userSpecifiedType);
        return sb.toString();
    }

    private Renderer createRenderer() {
        if (StringUtil.isEmpty(this.type)) {
            throw new BuildException(Formatter.unknownRendererMessage("<unspecified>"));
        }
        Properties properties = this.createProperties();
        Renderer renderer = RendererFactory.createRenderer(this.type, properties);
        renderer.setShowSuppressedViolations(this.showSuppressed);
        return renderer;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        for (Parameter parameter : this.parameters) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        return properties;
    }

    private Writer getToFileWriter(String baseDir) throws IOException {
        if (!this.toFile.isAbsolute()) {
            return new BufferedWriter(new FileWriter(new File(baseDir + System.getProperty("file.separator") + this.toFile.getPath())));
        }
        return new BufferedWriter(new FileWriter(this.toFile));
    }
}

