/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.util.ResourceLoader;
import net.sourceforge.pmd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSetReferenceId {
    private final boolean external;
    private final String ruleSetFileName;
    private final boolean allRules;
    private final String ruleName;
    private final RuleSetReferenceId externalRuleSetReferenceId;

    public RuleSetReferenceId(String id) {
        this(id, null);
    }

    public RuleSetReferenceId(String id, RuleSetReferenceId externalRuleSetReferenceId) {
        if (externalRuleSetReferenceId != null && !externalRuleSetReferenceId.isExternal()) {
            throw new IllegalArgumentException("Cannot pair with non-external <" + externalRuleSetReferenceId + ">.");
        }
        if (id != null && id.indexOf(44) >= 0) {
            throw new IllegalArgumentException("A single RuleSetReferenceId cannot contain ',' (comma) characters: " + id);
        }
        if (StringUtil.isEmpty(id) || RuleSetReferenceId.isFullRuleSetName(id)) {
            this.external = true;
            this.ruleSetFileName = id;
            this.allRules = true;
            this.ruleName = null;
        } else {
            int separatorIndex = Math.max(id.lastIndexOf(47), id.lastIndexOf(92));
            if (separatorIndex >= 0 && separatorIndex != id.length() - 1) {
                int index;
                String name = id.substring(0, separatorIndex);
                this.external = true;
                this.ruleSetFileName = RuleSetReferenceId.isFullRuleSetName(name) ? name : ((index = name.indexOf(45)) >= 0 ? "rulesets/" + name.substring(0, index) + "/" + name.substring(index + 1) + ".xml" : (name.matches("[0-9]+.*") ? "rulesets/releases/" + name + ".xml" : name));
                this.allRules = false;
                this.ruleName = id.substring(separatorIndex + 1);
            } else {
                int index = id.indexOf(45);
                if (index >= 0) {
                    this.external = true;
                    this.ruleSetFileName = "rulesets/" + id.substring(0, index) + "/" + id.substring(index + 1) + ".xml";
                    this.allRules = true;
                    this.ruleName = null;
                } else if (id.matches("[0-9]+.*")) {
                    this.external = true;
                    this.ruleSetFileName = "rulesets/releases/" + id + ".xml";
                    this.allRules = true;
                    this.ruleName = null;
                } else {
                    this.external = externalRuleSetReferenceId != null;
                    this.ruleSetFileName = externalRuleSetReferenceId != null ? externalRuleSetReferenceId.getRuleSetFileName() : null;
                    this.allRules = false;
                    this.ruleName = id;
                }
            }
        }
        if (this.external && this.ruleName != null && !this.ruleName.equals(id) && externalRuleSetReferenceId != null) {
            throw new IllegalArgumentException("Cannot pair external <" + this + "> with external <" + externalRuleSetReferenceId + ">.");
        }
        this.externalRuleSetReferenceId = externalRuleSetReferenceId;
    }

    private static boolean isFullRuleSetName(String name) {
        return name.endsWith(".xml");
    }

    public static List<RuleSetReferenceId> parse(String referenceString) {
        ArrayList<RuleSetReferenceId> references = new ArrayList<RuleSetReferenceId>();
        if (referenceString.indexOf(44) == -1) {
            references.add(new RuleSetReferenceId(referenceString));
        } else {
            for (String name : referenceString.split(",")) {
                references.add(new RuleSetReferenceId(name));
            }
        }
        return references;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean isAllRules() {
        return this.allRules;
    }

    public String getRuleSetFileName() {
        return this.ruleSetFileName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public InputStream getInputStream(ClassLoader classLoader) throws RuleSetNotFoundException {
        if (this.externalRuleSetReferenceId == null) {
            InputStream in;
            InputStream inputStream = in = StringUtil.isEmpty(this.ruleSetFileName) ? null : ResourceLoader.loadResourceAsStream(this.ruleSetFileName, classLoader);
            if (in == null) {
                throw new RuleSetNotFoundException("Can't find resource " + this.ruleSetFileName + ".  Make sure the resource is a valid file or URL or is on the CLASSPATH.  Here's the current classpath: " + System.getProperty("java.class.path"));
            }
            return in;
        }
        return this.externalRuleSetReferenceId.getInputStream(classLoader);
    }

    public String toString() {
        if (this.ruleSetFileName != null) {
            if (this.allRules) {
                return this.ruleSetFileName;
            }
            return this.ruleSetFileName + "/" + this.ruleName;
        }
        if (this.allRules) {
            return "anonymous all Rule";
        }
        return this.ruleName;
    }
}

