/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ResourceLoader {
    public InputStream getResourceStream(String path) throws IOException {
        InputStream stream;
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((stream = cl.getResourceAsStream(path)) == null) {
            throw new IOException("Resource not found: " + path);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveResourceToFile(String resPath, File toFile) throws IOException {
        InputStream in = this.getResourceStream(resPath);
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            try {
                byte[] buf = new byte[4096];
                int r = 0;
                while (r != -1) {
                    if (r > 0) {
                        ((OutputStream)out).write(buf, 0, r);
                    }
                    r = in.read(buf);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }
}

