/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.visitors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMDASMVisitor
implements ClassVisitor {
    private Map<String, String> packages = new HashMap<String, String>();
    private AnnotationVisitor annotationVisitor = new PMDAnnotationVisitor(this);
    private FieldVisitor fieldVisitor = new PMDFieldVisitor(this);
    private SignatureVisitor sigVisitor = new PMDSignatureVisitor(this);
    private MethodVisitor methodVisitor = new PMDMethodVisitor(this);
    public List<String> innerClasses;

    public Map<String, String> getPackages() {
        return this.packages;
    }

    public List<String> getInnerClasses() {
        return this.innerClasses;
    }

    private String parseClassName(String name) {
        if (name == null) {
            return null;
        }
        String className = name;
        int n = name.lastIndexOf(47);
        if (n > -1) {
            className = name.substring(n + 1);
        }
        name = name.replace('/', '.');
        this.packages.put(className, name);
        n = className.indexOf(36);
        if (n > -1) {
            this.packages.put(className.substring(n + 1), name);
            this.packages.put(className.replace('$', '.'), name);
        }
        return name;
    }

    private void parseClassName(String[] names) {
        if (names != null) {
            for (String s : names) {
                this.parseClassName(s);
            }
        }
    }

    private void extractSignature(String sig) {
        if (sig != null) {
            new SignatureReader(sig).accept(this.sigVisitor);
        }
    }

    @Override
    public void visit(int version, int access, String name, String sig, String superName, String[] interfaces) {
        this.parseClassName(name);
        this.parseClassName(interfaces);
        if (sig != null) {
            this.extractSignature(sig);
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.addType(Type.getType(desc));
        return this.annotationVisitor;
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String sig, Object value) {
        if (sig != null) {
            this.extractSignature(sig);
        }
        this.addType(Type.getType(desc));
        if (value instanceof Type) {
            this.addType((Type)value);
        }
        return this.fieldVisitor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String sig, String[] exceptions) {
        if (sig != null) {
            this.extractSignature(sig);
        }
        this.addMethodDesc(desc);
        this.parseClassName(exceptions);
        return this.methodVisitor;
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.innerClasses == null) {
            this.innerClasses = new ArrayList<String>();
        }
        if (!this.innerClasses.contains(name.replace('/', '.'))) {
            this.innerClasses.add(name.replace('/', '.'));
        }
        this.packages.put(innerName, name.replace('/', '.'));
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
    }

    @Override
    public void visitEnd() {
    }

    private void addMethodDesc(String desc) {
        this.addTypes(desc);
        this.addType(Type.getReturnType(desc));
    }

    private void addTypes(String desc) {
        Type[] types;
        for (Type type : types = Type.getArgumentTypes(desc)) {
            this.addType(type);
        }
    }

    private void addType(Type t) {
        switch (t.getSort()) {
            case 9: {
                this.addType(t.getElementType());
                break;
            }
            case 10: {
                this.parseClassName(t.getClassName().replace('.', '/'));
                break;
            }
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    private static class PMDMethodVisitor
    implements MethodVisitor {
        private PMDASMVisitor parent;

        public PMDMethodVisitor(PMDASMVisitor visitor) {
            this.parent = visitor;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (desc.charAt(0) == '[') {
                this.parent.addType(Type.getType(desc));
            } else {
                this.parent.parseClassName(desc);
            }
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.parent.parseClassName(owner);
            this.parent.addType(Type.getType(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.parent.parseClassName(owner);
            this.parent.addMethodDesc(desc);
        }

        public void visitLdcInsn(Object cst) {
            if (cst instanceof Type) {
                this.parent.addType((Type)cst);
            } else if (cst instanceof String) {
                this.parent.parseClassName((String)cst);
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.parent.addType(Type.getType(desc));
        }

        public void visitLocalVariable(String name, String desc, String sig, Label start, Label end, int index) {
            this.parent.extractSignature(sig);
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.parent.parseClassName(type);
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return this.parent.annotationVisitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        public void visitEnd() {
        }

        public void visitAttribute(Attribute attr) {
        }
    }

    private static class PMDSignatureVisitor
    implements SignatureVisitor {
        private PMDASMVisitor parent;

        public PMDSignatureVisitor(PMDASMVisitor visitor) {
            this.parent = visitor;
        }

        public void visitFormalTypeParameter(String name) {
        }

        public SignatureVisitor visitClassBound() {
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            return this;
        }

        public SignatureVisitor visitInterface() {
            return this;
        }

        public SignatureVisitor visitParameterType() {
            return this;
        }

        public SignatureVisitor visitReturnType() {
            return this;
        }

        public SignatureVisitor visitExceptionType() {
            return this;
        }

        public void visitBaseType(char descriptor) {
        }

        public void visitTypeVariable(String name) {
        }

        public SignatureVisitor visitArrayType() {
            return this;
        }

        public void visitClassType(String name) {
            this.parent.parseClassName(name);
        }

        public void visitInnerClassType(String name) {
            this.parent.parseClassName(name);
        }

        public void visitTypeArgument() {
        }

        public SignatureVisitor visitTypeArgument(char wildcard) {
            return this;
        }

        public void visitEnd() {
        }
    }

    private static class PMDAnnotationVisitor
    implements AnnotationVisitor {
        private PMDASMVisitor parent;

        public PMDAnnotationVisitor(PMDASMVisitor visitor) {
            this.parent = visitor;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.parent.addType(Type.getType(desc));
            return this;
        }

        public void visitEnum(String name, String desc, String value) {
            this.parent.addType(Type.getType(desc));
        }

        public AnnotationVisitor visitArray(String name) {
            return this;
        }

        public void visitEnd() {
        }

        public void visit(String name, Object value) {
            if (value instanceof Type) {
                this.parent.addType((Type)value);
            }
        }
    }

    private static class PMDFieldVisitor
    implements FieldVisitor {
        private PMDASMVisitor parent;

        public PMDFieldVisitor(PMDASMVisitor visitor) {
            this.parent = visitor;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.parent.addType(Type.getType(desc));
            return this.parent.annotationVisitor;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitEnd() {
        }
    }
}

