/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.rules;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureDeclareThrowsException
extends AbstractJavaRule {
    private static final BooleanProperty IGNORE_JUNIT_COMPLETELY_DESCRIPTOR = new BooleanProperty("IgnoreJUnitCompletely", "Allow all methods in a JUnit testcase to throw Exceptions", false, 1.0f);
    private boolean junitImported = false;

    public SignatureDeclareThrowsException() {
        this.definePropertyDescriptor(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTClassOrInterfaceType type;
        if (this.junitImported) {
            return super.visit(node, data);
        }
        ASTImplementsList impl = node.getFirstChildOfType(ASTImplementsList.class);
        if (impl != null && impl.jjtGetParent().equals(node)) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                ASTClassOrInterfaceType type2 = (ASTClassOrInterfaceType)impl.jjtGetChild(ix);
                if (!this.isJUnitTest(type2)) continue;
                this.junitImported = true;
                return super.visit(node, data);
            }
        }
        if (node.jjtGetNumChildren() != 0 && node.jjtGetChild(0) instanceof ASTExtendsList && this.isJUnitTest(type = (ASTClassOrInterfaceType)node.jjtGetChild(0).jjtGetChild(0))) {
            this.junitImported = true;
            return super.visit(node, data);
        }
        return super.visit(node, data);
    }

    private boolean isJUnitTest(ASTClassOrInterfaceType type) {
        Class<?> clazz = type.getType();
        if (clazz == null) {
            if ("junit.framework.Test".equals(type.getImage())) {
                return true;
            }
        } else {
            if (this.isJUnitTest(clazz)) {
                return true;
            }
            while (clazz != null && !Object.class.equals(clazz)) {
                for (Class<?> intf : clazz.getInterfaces()) {
                    if (!this.isJUnitTest(intf)) continue;
                    return true;
                }
                clazz = clazz.getSuperclass();
            }
        }
        return false;
    }

    private boolean isJUnitTest(Class<?> clazz) {
        return clazz.getName().equals("junit.framework.Test");
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if (this.junitImported && this.isAllowedMethod(methodDeclaration)) {
            return super.visit(methodDeclaration, o);
        }
        this.checkExceptions(methodDeclaration, o);
        return super.visit(methodDeclaration, o);
    }

    private boolean isAllowedMethod(ASTMethodDeclaration methodDeclaration) {
        if (this.getProperty(IGNORE_JUNIT_COMPLETELY_DESCRIPTOR).booleanValue()) {
            return true;
        }
        return methodDeclaration.getMethodName().equals("setUp") || methodDeclaration.getMethodName().equals("tearDown");
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        this.checkExceptions(constructorDeclaration, o);
        return super.visit(constructorDeclaration, o);
    }

    private void checkExceptions(Node method, Object o) {
        List<ASTName> exceptionList = method.findDescendantsOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
    }

    private void evaluateExceptions(List<ASTName> exceptionList, Object context) {
        for (ASTName exception : exceptionList) {
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        Node parent = exception.jjtGetParent().jjtGetParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

