/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codesize;

import java.util.List;
import java.util.Stack;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.codesize.NPathComplexityRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class CyclomaticComplexityRule
extends AbstractJavaRule {
    public static final IntegerProperty REPORT_LEVEL_DESCRIPTOR = new IntegerProperty("reportLevel", "Cyclomatic Complexity reporting threshold", 1, 30, 10, 1.0f);
    public static final BooleanProperty SHOW_CLASSES_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showClassesComplexity", "Add class average violations to the report", true, 2.0f);
    public static final BooleanProperty SHOW_METHODS_COMPLEXITY_DESCRIPTOR = new BooleanProperty("showMethodsComplexity", "Add method average violations to the report", true, 3.0f);
    private int reportLevel;
    private boolean showClassesComplexity = true;
    private boolean showMethodsComplexity = true;
    private Stack<Entry> entryStack = new Stack();

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.definePropertyDescriptor(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
    }

    public Object visit(ASTCompilationUnit node, Object data) {
        this.reportLevel = this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        this.showClassesComplexity = this.getProperty(SHOW_CLASSES_COMPLEXITY_DESCRIPTOR);
        this.showMethodsComplexity = this.getProperty(SHOW_METHODS_COMPLEXITY_DESCRIPTOR);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompIf);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTCatchStatement node, Object data) {
        this.entryStack.peek().bumpDecisionPoints();
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity(node.getFirstDescendantOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompFor);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTDoStatement node, Object data) {
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompDo);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        Entry entry = this.entryStack.peek();
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        entry.bumpDecisionPoints(boolCompSwitch);
        int childCount = node.jjtGetNumChildren();
        int lastIndex = childCount - 1;
        for (int n = 0; n < lastIndex; ++n) {
            ASTSwitchLabel sl;
            Node childNode = node.jjtGetChild(n);
            if (!(childNode instanceof ASTSwitchLabel) || (sl = (ASTSwitchLabel)childNode).isDefault() || !((childNode = node.jjtGetChild(n + 1)) instanceof ASTBlockStatement)) continue;
            entry.bumpDecisionPoints();
        }
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
        this.entryStack.peek().bumpDecisionPoints(++boolCompWhile);
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.isTernary()) {
            int boolCompTern = NPathComplexityRule.sumExpressionComplexity(node.getFirstChildOfType(ASTExpression.class));
            this.entryStack.peek().bumpDecisionPoints(++boolCompTern);
            super.visit(node, data);
        }
        return data;
    }

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Entry classEntry;
        if (node.isInterface()) {
            return data;
        }
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        if (this.showClassesComplexity && ((classEntry = this.entryStack.pop()).getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel)) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + " (Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry methodEntry = this.entryStack.pop();
        if (!this.isSuppressed(node)) {
            int methodDecisionPoints = methodEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.bumpDecisionPoints(methodDecisionPoints);
            if (methodDecisionPoints > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = methodDecisionPoints;
            }
            ASTMethodDeclarator methodDeclarator = null;
            for (int n = 0; n < node.jjtGetNumChildren(); ++n) {
                Node childNode = node.jjtGetChild(n);
                if (!(childNode instanceof ASTMethodDeclarator)) continue;
                methodDeclarator = (ASTMethodDeclarator)childNode;
                break;
            }
            if (this.showMethodsComplexity && methodEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, (Node)node, new String[]{"method", methodDeclarator == null ? "" : methodDeclarator.getImage(), String.valueOf(methodEntry.decisionPoints)});
            }
        }
        return data;
    }

    public Object visit(ASTEnumDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = this.entryStack.pop();
        if (classEntry.getComplexityAverage() >= this.reportLevel || classEntry.highestDecisionPoints >= this.reportLevel) {
            this.addViolation(data, (Node)node, new String[]{"class", node.getImage(), classEntry.getComplexityAverage() + "(Highest = " + classEntry.highestDecisionPoints + ')'});
        }
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry constructorEntry = this.entryStack.pop();
        if (!this.isSuppressed(node)) {
            int constructorDecisionPointCount = constructorEntry.decisionPoints;
            Entry classEntry = this.entryStack.peek();
            ++classEntry.methodCount;
            classEntry.decisionPoints += constructorDecisionPointCount;
            if (constructorDecisionPointCount > classEntry.highestDecisionPoints) {
                classEntry.highestDecisionPoints = constructorDecisionPointCount;
            }
            if (this.showMethodsComplexity && constructorEntry.decisionPoints >= this.reportLevel) {
                this.addViolation(data, (Node)node, new String[]{"constructor", classEntry.node.getImage(), String.valueOf(constructorDecisionPointCount)});
            }
        }
        return data;
    }

    private boolean isSuppressed(Node node) {
        boolean result = false;
        ASTClassOrInterfaceBodyDeclaration parent = node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        List<ASTAnnotation> annotations = parent.findChildrenOfType(ASTAnnotation.class);
        for (ASTAnnotation a : annotations) {
            ASTName name = a.getFirstDescendantOfType(ASTName.class);
            if ("SuppressWarnings".equals(name.getImage())) {
                List<ASTLiteral> literals = a.findDescendantsOfType(ASTLiteral.class);
                for (ASTLiteral l : literals) {
                    if (!l.isStringLiteral() || !"\"PMD.CyclomaticComplexity\"".equals(l.getImage())) continue;
                    result = true;
                    break;
                }
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private static class Entry {
        private Node node;
        private int decisionPoints = 1;
        public int highestDecisionPoints;
        public int methodCount;

        private Entry(Node node) {
            this.node = node;
        }

        public void bumpDecisionPoints() {
            ++this.decisionPoints;
        }

        public void bumpDecisionPoints(int size) {
            this.decisionPoints += size;
        }

        public int getComplexityAverage() {
            return (double)this.methodCount == 0.0 ? 1 : (int)Math.rint((double)this.decisionPoints / (double)this.methodCount);
        }
    }
}

