/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.StringReader;
import java.util.Properties;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLParserTokenManager;
import net.sourceforge.pmd.lang.plsql.ast.SimpleCharStream;
import net.sourceforge.pmd.lang.plsql.ast.Token;

public class PLSQLTokenizer
implements Tokenizer {
    public static final String IGNORE_COMMENTS = "ignore_comments";
    public static final String IGNORE_IDENTIFIERS = "ignore_identifiers";
    public static final String IGNORE_LITERALS = "ignore_literals";
    private boolean isInitialised = false;
    private boolean ignoreComments;
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;

    public void setProperties(Properties properties) {
        this.ignoreComments = Boolean.parseBoolean(properties.getProperty(IGNORE_COMMENTS, "true"));
        this.ignoreIdentifiers = Boolean.parseBoolean(properties.getProperty(IGNORE_IDENTIFIERS, "false"));
        this.ignoreLiterals = Boolean.parseBoolean(properties.getProperty(IGNORE_LITERALS, "false"));
    }

    public void setIgnoreComments(boolean ignore) {
        this.ignoreComments = ignore;
    }

    public void setIgnoreLiterals(boolean ignore) {
        this.ignoreLiterals = ignore;
    }

    public void setIgnoreIdentifiers(boolean ignore) {
        this.ignoreIdentifiers = ignore;
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        long encounteredTokens = 0L;
        long addedTokens = 0L;
        if (!this.isInitialised) {
            this.setProperties(System.getProperties());
            this.isInitialised = true;
            System.err.println("PLSQLTokenizer: ignoreComments==" + this.ignoreComments);
            System.err.println("PLSQLTokenizer: ignoreIdentifiers==" + this.ignoreIdentifiers);
            System.err.println("PLSQLTokenizer: ignoreLiterals==" + this.ignoreLiterals);
        }
        String fileName = sourceCode.getFileName();
        StringBuilder sb = sourceCode.getCodeBuffer();
        PLSQLParserTokenManager tokenMgr = new PLSQLParserTokenManager(new SimpleCharStream(new StringReader(sb.toString())));
        Token currentToken = tokenMgr.getNextToken();
        while (currentToken.image.length() > 0) {
            String image = currentToken.image;
            ++encounteredTokens;
            if (this.ignoreComments && (currentToken.kind == 30 || currentToken.kind == 33 || currentToken.kind == 32 || currentToken.kind == 74 || currentToken.kind == 2 || currentToken.kind == 1)) {
                image = String.valueOf(currentToken.kind);
            }
            if (this.ignoreIdentifiers && currentToken.kind == 420) {
                image = String.valueOf(currentToken.kind);
            }
            if (this.ignoreLiterals && (currentToken.kind == 421 || currentToken.kind == 422 || currentToken.kind == 423 || currentToken.kind == 425 || currentToken.kind == 426 || currentToken.kind == 428)) {
                image = String.valueOf(currentToken.kind);
            }
            tokenEntries.add(new TokenEntry(image, fileName, currentToken.beginLine));
            ++addedTokens;
            currentToken = tokenMgr.getNextToken();
        }
        tokenEntries.add(TokenEntry.getEOF());
    }
}

