/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.benchmark.Benchmark;
import net.sourceforge.pmd.benchmark.Benchmarker;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ParseException;
import net.sourceforge.pmd.lang.xpath.Initializer;
import net.sourceforge.pmd.util.IOUtil;

public class SourceCodeProcessor {
    private final PMDConfiguration configuration;

    public SourceCodeProcessor(PMDConfiguration configuration) {
        this.configuration = configuration;
    }

    public void processSourceCode(InputStream sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        try {
            this.processSourceCode(new InputStreamReader(sourceCode, this.configuration.getSourceEncoding()), ruleSets, ctx);
        }
        catch (UnsupportedEncodingException uee) {
            throw new PMDException("Unsupported encoding exception: " + uee.getMessage());
        }
    }

    public void processSourceCode(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) throws PMDException {
        this.determineLanguage(ctx);
        Initializer.initialize();
        if (ruleSets.applies(ctx.getSourceCodeFile())) {
            try {
                this.processSource(sourceCode, ruleSets, ctx);
            }
            catch (ParseException pe) {
                throw new PMDException("Error while parsing " + ctx.getSourceCodeFilename(), pe);
            }
            catch (Exception e) {
                throw new PMDException("Error while processing " + ctx.getSourceCodeFilename(), e);
            }
            finally {
                IOUtil.closeQuietly(sourceCode);
            }
        }
    }

    private Node parse(RuleContext ctx, Reader sourceCode, Parser parser) {
        long start = System.nanoTime();
        Node rootNode = parser.parse(ctx.getSourceCodeFilename(), sourceCode);
        ctx.getReport().suppress(parser.getSuppressMap());
        long end = System.nanoTime();
        Benchmarker.mark(Benchmark.Parser, end - start, 0L);
        return rootNode;
    }

    private void symbolFacade(Node rootNode, LanguageVersionHandler languageVersionHandler) {
        long start = System.nanoTime();
        languageVersionHandler.getSymbolFacade().start(rootNode);
        long end = System.nanoTime();
        Benchmarker.mark(Benchmark.SymbolTable, end - start, 0L);
    }

    private void usesDFA(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesDFA(language)) {
            long start = System.nanoTime();
            languageVersion.getLanguageVersionHandler().getDataFlowFacade().start(rootNode);
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.DFA, end - start, 0L);
        }
    }

    private void usesTypeResolution(LanguageVersion languageVersion, Node rootNode, RuleSets ruleSets, Language language) {
        if (ruleSets.usesTypeResolution(language)) {
            long start = System.nanoTime();
            languageVersion.getLanguageVersionHandler().getTypeResolutionFacade(this.configuration.getClassLoader()).start(rootNode);
            long end = System.nanoTime();
            Benchmarker.mark(Benchmark.TypeResolution, end - start, 0L);
        }
    }

    private void processSource(Reader sourceCode, RuleSets ruleSets, RuleContext ctx) {
        LanguageVersion languageVersion = ctx.getLanguageVersion();
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        Parser parser = PMD.parserFor(languageVersion, this.configuration);
        Node rootNode = this.parse(ctx, sourceCode, parser);
        this.symbolFacade(rootNode, languageVersionHandler);
        Language language = languageVersion.getLanguage();
        this.usesDFA(languageVersion, rootNode, ruleSets, language);
        this.usesTypeResolution(languageVersion, rootNode, ruleSets, language);
        ArrayList<Node> acus = new ArrayList<Node>();
        acus.add(rootNode);
        ruleSets.apply(acus, ctx, language);
    }

    private void determineLanguage(RuleContext ctx) {
        if (ctx.getLanguageVersion() == null) {
            LanguageVersion languageVersion = this.configuration.getLanguageVersionOfFile(ctx.getSourceCodeFilename());
            ctx.setLanguageVersion(languageVersion);
        }
    }
}

