/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc.cpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.pldoc.DbmsMetadata;
import net.sourceforge.pldoc.SourceCodeScraper;
import net.sourceforge.pldoc.Utils;
import net.sourceforge.pldoc.cpd.DatabaseCodeLoader;
import net.sourceforge.pldoc.cpd.Settings;
import net.sourceforge.pldoc.cpd.Version;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.util.FileFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPD {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static String programName = "PLDoc(CPD) version: " + Version.id();
    private static HashMap hashMap = new HashMap();
    private static HashMap fileSuffixMap;
    private Map<String, SourceCode> source = new TreeMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private MatchAlgorithm matchAlgorithm;
    public Settings settings;
    private Set<String> current = new HashSet<String>();

    public CPD(Settings settings) {
        this.settings = settings;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        System.err.println("");
        System.err.println(programName);
        Settings settings = new Settings();
        settings.processCommandString(args);
        CPD cpd = new CPD(settings);
        try {
            cpd.run();
            cpd.go();
            if (cpd.getMatches().hasNext()) {
                File outputFile = settings.getOutputFile();
                PrintStream outputStream = System.out;
                if (null != outputFile) {
                    System.err.println("Outputting CPD to " + outputFile.getAbsolutePath());
                    outputStream = new PrintStream(new FileOutputStream(outputFile));
                }
                outputStream.println(settings.renderer().render(cpd.getMatches()));
                File stylesheet = settings.getStylesheet();
                if (null != outputFile && "xml".equalsIgnoreCase(settings.getFormatString())) {
                    System.err.println("Generating CPD HTML to " + outputFile.getAbsolutePath());
                    settings.generateHtml(outputFile);
                }
                System.exit(0);
            }
        }
        catch (SystemExitException e) {
            System.exit(-1);
        }
        long finishTime = System.currentTimeMillis();
        System.err.println("Done (" + (double)(finishTime - startTime) / 1000.0 + " seconds).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        block56: {
            long startTime = System.currentTimeMillis();
            TreeMap<String, Throwable> skippedPackages = new TreeMap<String, Throwable>();
            long processedPackages = 0L;
            if (this.settings.isVerbose()) {
                System.out.println("Run() ");
            }
            if (!this.settings.getOutputDirectory().exists()) {
                System.err.println("Directory \"" + this.settings.getOutputDirectory() + "\" does not exist, creating ...");
                this.settings.getOutputDirectory().mkdir();
            }
            try {
                if (this.settings.isVerbose()) {
                    System.out.println("Parsing files ...");
                }
                Iterator it = this.settings.getInputFiles().iterator();
                while (it.hasNext()) {
                    String inputFileName;
                    String packagename = inputFileName = (String)it.next();
                    if (this.settings.isVerbose()) {
                        System.err.println("Parsing file " + inputFileName + " ...");
                    }
                    try {
                        if (this.settings.isVerbose()) {
                            System.err.println("Processing : " + inputFileName + " as inputEncoding=\"" + this.settings.getInputEncoding() + "\"");
                        }
                        this.add(new File(inputFileName));
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File not found: " + inputFileName);
                        throw new SystemExitException(e);
                    }
                }
                if (this.settings.isVerbose()) {
                    System.err.println("Finished parsing files.");
                }
                if (this.settings.isVerbose()) {
                    System.err.println("Parsing database source ...");
                }
                if (this.settings.getDbUrl() == null || this.settings.getDbUser() == null || this.settings.getDbPassword() == null) break block56;
                Class.forName(this.settings.getDriverName());
                Connection conn = null;
                Statement pstmt = null;
                try {
                    String typeList = "";
                    Collection inputTypes = this.settings.getInputTypes();
                    if (null != inputTypes && !inputTypes.isEmpty()) {
                        for (String inputType : inputTypes) {
                            typeList = typeList + (0 == typeList.length() ? "" : ",") + "'" + inputType.toUpperCase() + "'";
                        }
                    }
                    if (typeList.equals("")) {
                        typeList = "'PACKAGE','TYPE','PROCEDURE','FUNCTION','TRIGGER','PACKAGE BODY','TYPE BODY'";
                    }
                    String sqlStatement = "SELECT  object_name, object_type FROM dba_objects WHERE owner = ? AND   object_name LIKE ? AND  object_type in (" + typeList + ")" + " ORDER BY " + " object_name";
                    if (this.settings.isVerbose()) {
                        System.err.println("Using \"" + sqlStatement + "\"");
                    }
                    if (this.settings.isVerbose()) {
                        System.err.println("Connecting ..");
                    }
                    conn = DriverManager.getConnection(this.settings.getDbUrl(), this.settings.getDbUser(), this.settings.getDbPassword());
                    if (this.settings.isVerbose()) {
                        System.err.println("Connected");
                    }
                    pstmt = conn.prepareStatement(sqlStatement);
                    String outputRootPath = this.settings.getOutputDirectory().getCanonicalPath();
                    DbmsMetadata dbmsMetadata = new DbmsMetadata(conn, this.settings.getGetMetadataStatement(), this.settings.getReturnType());
                    it = this.settings.getInputObjects().iterator();
                    while (it.hasNext()) {
                        String[] input = ((String)it.next()).split("\\.");
                        if (input.length == 0 || input.length > 2) continue;
                        String inputSchemaName = input.length == 2 ? input[0] : this.settings.getDbUser();
                        String inputObjectName = input.length == 2 ? input[1] : input[0];
                        ResultSet rset = null;
                        try {
                            pstmt.setString(1, inputSchemaName);
                            pstmt.setString(2, inputObjectName);
                            try {
                                rset = pstmt.executeQuery();
                            }
                            catch (Exception e) {
                                sqlStatement = sqlStatement.replaceFirst(" dba_", " all_");
                                if (this.settings.isVerbose()) {
                                    System.out.println("Reverting to \"" + sqlStatement + "\"");
                                }
                                pstmt = conn.prepareStatement(sqlStatement);
                                pstmt.setString(1, inputSchemaName);
                                pstmt.setString(2, inputObjectName);
                                rset = pstmt.executeQuery();
                            }
                            if (!rset.next()) {
                                System.err.println("Object(s) like " + inputSchemaName + "." + inputObjectName + " do not exist or " + this.settings.getDbUser() + " does not have enough permissions (SELECT_CATALOG_ROLE role).");
                                continue;
                            }
                            do {
                                String objectName = rset.getString(1);
                                String objectType = rset.getString(2);
                                String dbmsMetadataObjectType = hashMap.containsKey(rset.getString(2)) ? (String)hashMap.get(objectType) : objectType;
                                String fullyQualifiedObjectName = inputSchemaName + "." + objectName;
                                if (this.settings.isVerbose()) {
                                    System.err.println("Parsing " + objectType + " name " + fullyQualifiedObjectName + " ...");
                                }
                                if (this.settings.isVerbose()) {
                                    System.err.println("Extracting DBMS_METADATA DDL for (object_type,object_name,schema)=(" + objectType + "," + objectName + "," + inputSchemaName + ") ...");
                                }
                                if (startTime >= this.settings.getOutputDirectory().lastModified()) {
                                    Utils.copyStaticRootDirectoryFiles(this.settings.getOutputDirectory(), this.settings.getStylesheet(), this.settings.getSourceStylesheet());
                                    if (this.settings.isVerbose()) {
                                        System.err.println("Refreshed static files in " + this.settings.getOutputDirectory().getCanonicalPath());
                                    }
                                }
                                File savedSchemaDirectory = new File(this.settings.getOutputDirectory(), inputSchemaName);
                                if (this.settings.isSaveSourceCode() && !savedSchemaDirectory.exists()) {
                                    savedSchemaDirectory.mkdir();
                                }
                                File savedObjectTypeDirectory = new File(savedSchemaDirectory, objectType.replace(' ', '_'));
                                if (this.settings.isSaveSourceCode()) {
                                    if (!savedObjectTypeDirectory.exists()) {
                                        savedObjectTypeDirectory.mkdir();
                                        Utils.copyStaticSourceDirectoryFiles(savedObjectTypeDirectory, "../../");
                                    } else if (startTime > savedObjectTypeDirectory.lastModified()) {
                                        Utils.copyStaticSourceDirectoryFiles(savedObjectTypeDirectory, "../../");
                                        if (this.settings.isVerbose()) {
                                            System.err.println("Refreshed static files in " + savedObjectTypeDirectory.getCanonicalPath());
                                        }
                                    }
                                }
                                File savedSourceFile = new File(savedObjectTypeDirectory, rset.getString(1).replace(' ', '_') + "." + fileSuffixMap.get(rset.getString(2)) + ".xml");
                                OutputStreamWriter savedSourceFileWriter = null;
                                BufferedReader bufferedReader = null;
                                Throwable throwable = null;
                                try {
                                    if (this.settings.isSaveSourceCode()) {
                                        System.err.println("Saving DDL for (object_type,object_name,schema)=(" + dbmsMetadataObjectType + "," + rset.getString(1) + "," + inputSchemaName + ") to " + savedSourceFile.getCanonicalPath());
                                        savedSourceFileWriter = new FileWriter(savedSourceFile);
                                        bufferedReader = new BufferedReader(new SourceCodeScraper(dbmsMetadata.getDdl(dbmsMetadataObjectType, rset.getString(1), inputSchemaName, "COMPATIBLE", "ORACLE", "DDL"), (Writer)savedSourceFileWriter, false, "sourcecode.xsl"));
                                        throwable = this.add(0, (Reader)bufferedReader, savedSourceFile.getCanonicalPath().replaceFirst(outputRootPath, "."));
                                    } else {
                                        bufferedReader = new BufferedReader(dbmsMetadata.getDdl(dbmsMetadataObjectType, rset.getString(1), inputSchemaName, "COMPATIBLE", "ORACLE", "DDL"));
                                        throwable = this.add(0, bufferedReader, objectName, inputSchemaName, objectType);
                                    }
                                    if (throwable == null) {
                                        ++processedPackages;
                                        continue;
                                    }
                                    skippedPackages.put(fullyQualifiedObjectName, throwable);
                                }
                                catch (SQLException sqlE) {
                                    sqlE.printStackTrace(System.err);
                                    skippedPackages.put(fullyQualifiedObjectName, sqlE);
                                }
                                finally {
                                    if (null != bufferedReader) {
                                        bufferedReader.close();
                                        bufferedReader = null;
                                    }
                                    if (null != savedSourceFileWriter) {
                                        savedSourceFileWriter.flush();
                                        savedSourceFileWriter.close();
                                        savedSourceFileWriter = null;
                                    }
                                }
                            } while (rset.next());
                        }
                        finally {
                            if (rset == null) continue;
                            rset.close();
                        }
                    }
                }
                finally {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SystemExitException();
            }
        }
        if (this.settings.isVerbose()) {
            System.err.println("Added  " + this.tokens.size() + " Token(s) from " + this.source.size() + " Abstract Syntax Tree Source(s).");
        }
        if (null == this.tokens || 0 == this.tokens.size()) {
            System.err.println("run(): no Abstract Syntax Trees to compare");
        }
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void go() {
        if (this.settings.isVerbose()) {
            System.err.println("Checking  " + this.tokens.size() + " Token(s) from " + this.source.size() + " Abstract Syntax Tree Source(s).");
        }
        if (null == this.tokens || 0 == this.tokens.size()) {
            System.err.println("go(): no Abstract Syntax Trees to compare");
        } else {
            TokenEntry.clearImages();
            this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.settings.minimumTileSize(), this.listener);
            this.matchAlgorithm.findMatches();
        }
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        Throwable throwable = this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(files.size(), f);
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        if (!new File(dir).exists()) {
            throw new FileNotFoundException("Couldn't find directory " + dir);
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.settings.filenameFilter(), recurse));
    }

    private Throwable add(int fileCount, File file) throws IOException {
        String filePath = file.getCanonicalPath();
        if (this.settings.skipDuplicates()) {
            String signature = file.getName() + '_' + file.length();
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + file.getAbsolutePath() + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return null;
            }
            this.current.add(signature);
        }
        if (!filePath.equals(new File(file.getAbsolutePath()).getCanonicalPath())) {
            System.err.println("Skipping " + file + " since it appears to be a symlink");
            return null;
        }
        Throwable result = null;
        try {
            this.listener.addedFile(fileCount, file);
            SourceCode sourceCode = this.settings.sourceCodeFor(file);
            this.settings.tokenizer().tokenize(sourceCode, this.tokens);
            this.source.put(sourceCode.getFileName(), sourceCode);
            if (this.settings.isVerbose()) {
                System.err.println("Tokenized " + sourceCode.getFileName());
            }
        }
        catch (Throwable t) {
            System.err.println("Throwable at object <" + filePath + ">: " + t);
            t.printStackTrace(System.err);
            if (this.settings.isExitOnError()) {
                throw new SystemExitException(t);
            }
            System.err.println("Package " + filePath + " skipped.");
            result = t;
        }
        return result;
    }

    private Throwable add(int fileCount, Reader codeReader, String objectName, String schemaName, String objectType) throws IOException {
        String signature = schemaName + '/' + objectType + '/' + objectName;
        if (this.settings.isVerbose()) {
            System.err.println("Tokenizing database source code with pseudo-signature " + signature);
        }
        return this.add(fileCount, codeReader, signature);
    }

    private Throwable add(int fileCount, Reader codeReader, File file) throws IOException {
        return this.add(fileCount, codeReader, file.getCanonicalPath());
    }

    private Throwable add(int fileCount, Reader codeReader, String signature) throws IOException {
        if (this.settings.skipDuplicates()) {
            if (this.current.contains(signature)) {
                System.err.println("Skipping " + signature + " since it appears to be a duplicate file and --skip-duplicate-files is set");
                return null;
            }
            this.current.add(signature);
        }
        Throwable result = null;
        try {
            if (this.settings.isVerbose()) {
                System.err.println("Tokenizing database source code " + signature);
            }
            this.listener.addedFile(fileCount, new File(signature));
            DatabaseCodeLoader codeLoader = new DatabaseCodeLoader(codeReader, signature);
            SourceCode sourceCode = new SourceCode(codeLoader);
            this.settings.tokenizer().tokenize(sourceCode, this.tokens);
            this.source.put(signature, sourceCode);
            if (this.settings.isVerbose()) {
                System.err.println("Tokenized database source code " + sourceCode.getFileName());
            }
        }
        catch (IOException ioe) {
            result = ioe;
            if (this.settings.isVerbose()) {
                System.err.println("Problem tokenizing database source code " + signature);
            }
            ioe.printStackTrace(System.err);
        }
        catch (Throwable t) {
            System.err.println("Throwable for signature <" + signature + ">: " + t);
            t.printStackTrace(System.err);
            if (this.settings.isExitOnError()) {
                throw new SystemExitException(t);
            }
            System.err.println("Source Code " + signature + " skipped.");
            result = t;
        }
        return result;
    }

    static {
        hashMap.put("PACKAGE", "PACKAGE_SPEC");
        hashMap.put("TYPE", "TYPE_SPEC");
        hashMap.put("PACKAGE BODY", "PACKAGE_BODY");
        hashMap.put("TYPE BODY", "TYPE_BODY");
        fileSuffixMap = new HashMap();
        fileSuffixMap.put("PROCEDURE", "prc");
        fileSuffixMap.put("FUNCTION", "fnc");
        fileSuffixMap.put("TRIGGER", "trg");
        fileSuffixMap.put("PACKAGE", "pks");
        fileSuffixMap.put("TYPE", "tps");
        fileSuffixMap.put("PACKAGE BODY", "pkb");
        fileSuffixMap.put("TYPE BODY", "tpb");
    }

    private static class SystemExitException
    extends RuntimeException {
        static final long serialVersionUID = 1L;

        SystemExitException() {
        }

        SystemExitException(Throwable t) {
            super(t);
        }
    }
}

