/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pldoc;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLWriter {
    private OutputStream outStream;
    private Document doc;
    private Stack upperNodes;
    private LinkedList pendingAttributes = new LinkedList();
    private Properties serProperties;

    public XMLWriter(OutputStream outStream) throws IOException {
        this.outStream = outStream;
        this.serProperties = new Properties();
        this.setMethod("xml");
        this.setVersion("1.1");
        this.setEncoding("UTF-8");
        this.setIndent(true);
        this.setIndentSize(2);
        this.setOmitXMLDeclaration(false);
        this.setStandalone(false);
    }

    public XMLWriter() throws IOException {
        this(null);
    }

    public void setMethod(String method) {
        this.serProperties.setProperty("method", method);
        this.serProperties.putAll((Map<?, ?>)OutputPropertiesFactory.getDefaultMethodProperties(method));
    }

    private void setVersion(String version) {
        this.serProperties.setProperty("version", version);
    }

    public void setEncoding(String encoding) {
        this.serProperties.setProperty("encoding", encoding);
    }

    public void setIndent(boolean indent) {
        this.serProperties.setProperty("indent", indent ? "yes" : "no");
    }

    private void setIndentSize(int indentSize) {
        this.serProperties.setProperty("{http://xml.apache.org/xalan}indent-amount", String.valueOf(indentSize));
    }

    private void setOmitXMLDeclaration(boolean omit) {
        this.serProperties.setProperty("omit-xml-declaration", omit ? "yes" : "no");
    }

    private void setStandalone(boolean standalone) {
        this.serProperties.setProperty("standalone", standalone ? "yes" : "no");
    }

    public void setDocType(String sPublic, String sSystem) {
        if (sPublic != null) {
            this.serProperties.setProperty("doctype-public", sPublic);
        }
        if (sSystem != null) {
            this.serProperties.setProperty("doctype-system", sSystem);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e.toString());
        }
        this.upperNodes = new Stack();
        this.upperNodes.push(new Object[]{this.doc, new LinkedList()});
    }

    public void endDocument() throws SAXException {
        if (this.outStream != null) {
            try {
                Serializer serializer = SerializerFactory.getSerializer(this.serProperties);
                serializer.setOutputStream(this.outStream);
                serializer.asDOMSerializer().serialize(this.doc);
            }
            catch (IOException e) {
                throw new SAXException(e.toString());
            }
        }
    }

    public void pushAttribute(String name, String value) throws SAXException {
        if (this.pendingAttributes == null) {
            this.pendingAttributes = new LinkedList();
        }
        Attr attr = this.doc.createAttribute(name);
        attr.setValue(value);
        this.pendingAttributes.add(attr);
    }

    public void startElement(String name) throws SAXException {
        this.upperNodes.push(new Object[]{this.doc.createElement(name), this.pendingAttributes});
        this.pendingAttributes = new LinkedList();
    }

    public void endElement(String name) throws SAXException {
        Object[] pendingNodeArray = (Object[])this.upperNodes.pop();
        Node pendingNode = (Node)pendingNodeArray[0];
        LinkedList pendingAttributes = (LinkedList)pendingNodeArray[1];
        if (!(pendingNode instanceof Element)) {
            throw new IllegalStateException("Element " + name + " was not started !");
        }
        Element pendingElement = (Element)pendingNode;
        if (!pendingElement.getTagName().equals(name)) {
            throw new IllegalStateException("Element " + name + " was not started !");
        }
        while (!pendingAttributes.isEmpty()) {
            Attr attr = (Attr)pendingAttributes.removeFirst();
            pendingElement.setAttributeNode(attr);
        }
        Object[] upperNodeArray = (Object[])this.upperNodes.peek();
        Node upperNode = (Node)upperNodeArray[0];
        upperNode.appendChild(pendingElement);
    }

    public void endElementRecursive(String name) throws SAXException {
        Element pendingElement = null;
        while (true) {
            Object[] pendingNodeArray = (Object[])this.upperNodes.peek();
            Node pendingNode = (Node)pendingNodeArray[0];
            LinkedList pendingAttributes = (LinkedList)pendingNodeArray[1];
            if (!(pendingNode instanceof Element)) {
                throw new IllegalStateException("Element " + name + " was not started !");
            }
            pendingElement = (Element)pendingNode;
            if (pendingElement.getTagName().equals(name)) break;
            this.endElement(pendingElement.getTagName());
        }
        this.upperNodes.pop();
        while (!this.pendingAttributes.isEmpty()) {
            Attr attr = (Attr)this.pendingAttributes.removeFirst();
            pendingElement.setAttributeNode(attr);
        }
        Object[] upperNodeArray = (Object[])this.upperNodes.peek();
        Node upperNode = (Node)upperNodeArray[0];
        upperNode.appendChild(pendingElement);
    }

    public void element(String name) throws SAXException {
        this.startElement(name);
        this.endElement(name);
    }

    public void cdata(String str) throws SAXException {
        Object[] upperNodeArray = (Object[])this.upperNodes.peek();
        Node upperNode = (Node)upperNodeArray[0];
        upperNode.appendChild(this.doc.createCDATASection(str));
    }

    public Document getDocument() {
        return this.doc;
    }

    public void appendNodeChildren(Node node) throws SAXException {
        Object[] upperNodeArray = (Object[])this.upperNodes.peek();
        Node upperNode = (Node)upperNodeArray[0];
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            upperNode.appendChild(this.doc.importNode(n, true));
        }
    }

    public Node findObjectNode(String schemaName, String objectName) throws SAXException {
        Iterator it = this.upperNodes.iterator();
        it.next();
        Object[] upperNodeArray = (Object[])it.next();
        Node application = (Node)upperNodeArray[0];
        for (Node n = application.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element object = (Element)n;
            if (!object.getAttribute("SCHEMA").equalsIgnoreCase(schemaName) || !object.getAttribute("NAME").equalsIgnoreCase(objectName)) continue;
            return object;
        }
        return null;
    }

    public Element createElement(String tagName) throws DOMException {
        return this.doc.createElement(tagName);
    }

    public CDATASection createCDATASection(String data) throws DOMException {
        return this.doc.createCDATASection(data);
    }
}

